/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

class VerticalTextIcon
implements Icon,
SwingConstants {
    private Font font = UIManager.getFont("TabbedPane.font");
    private FontMetrics fm = new JLabel().getFontMetrics(this.font);
    private final String text;
    private int width;
    private int height;
    private final boolean clockwize;
    private final Icon icon;

    public VerticalTextIcon(String string, Icon icon, boolean bl) {
        this.text = string;
        this.width = this.fm.stringWidth(string) + 3 + icon.getIconWidth();
        this.height = Math.max(this.fm.getHeight(), icon.getIconHeight());
        this.clockwize = bl;
        this.icon = icon;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics.setFont(this.font);
        graphics.setColor(Color.black);
        if (this.clockwize) {
            graphics2D.translate(n + this.getIconWidth(), n2);
            graphics2D.rotate(1.5707963267948966);
        } else {
            graphics2D.translate(n, n2 + this.getIconHeight());
            graphics2D.rotate(-1.5707963267948966);
        }
        graphics.drawString(this.text, 3 + this.icon.getIconWidth(), this.fm.getLeading() + this.fm.getAscent());
        this.icon.paintIcon(component, graphics, 0, 2);
        graphics.setFont(font);
        graphics.setColor(color);
        graphics2D.setTransform(affineTransform);
    }

    public int getIconWidth() {
        return this.height;
    }

    public int getIconHeight() {
        return this.width;
    }
}

