/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.swing.CompTitledPane;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.LimitedPlainDocument;
import net.wordrider.dialogs.layouts.EqualsLayout;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class ConnectDialog
extends AppDialog {
    private final JTextField inputLoginName = new JTextField();
    private JCheckBox checkProxy = Swinger.getCheckBox("dialog.connect.checkProxy");
    private JButton btnCheck;
    private JButton btnCancel;
    private final JTextField inputHostName = new JTextField();
    private JCheckBox checkAuthentification;
    private final JTextField inputPortNumber = new JTextField();
    private JCheckBox checkSavePassword = new JCheckBox();
    private final JTextField inputPassword = new JPasswordField();
    private final CompTitledPane panelProxyPane = new CompTitledPane(this.checkProxy);
    private final JPanel panelProxy = this.panelProxyPane.getContentPane();
    private JLabel labelLoginName = Swinger.getLabel("dialog.connect.labelLoginName");
    private JLabel labelPassword = Swinger.getLabel("dialog.connect.labelPassword");
    private JLabel labelWarning = Swinger.getLabel("dialog.connect.labelWarning");
    private static final Logger logger = Logger.getLogger(ConnectDialog.class.getName());

    public ConnectDialog(Frame frame) throws HeadlessException {
        super(frame, true);
        try {
            this.init();
            this.initData();
            this.useHttpProxy(this.checkProxy.isSelected());
            this.useAuthentification(this.checkAuthentification.isSelected());
            this.setModal(true);
            this.setTitle(Lng.getLabel("dialog.connect.title", "WordRider 0.8 alpha 3 preview"));
            this.setDefaultCloseOperation(2);
            this.pack();
            Swinger.centerDialog(frame, this);
            this.setVisible(true);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    private void initData() {
        this.checkProxy.setSelected(AppPrefs.getProperty("settings.proxy.proxy", false));
        this.checkAuthentification.setSelected(AppPrefs.getProperty("settings.proxy.login", false));
        this.inputHostName.setText(AppPrefs.getProperty("settings.proxy.url", ""));
        this.inputPortNumber.setText(AppPrefs.getProperty("settings.proxy.port", ""));
        this.checkSavePassword.setSelected(AppPrefs.getProperty("settings.proxy.savepassword", false));
        this.inputLoginName.setText(AppPrefs.getProperty("settings.proxy.username", ""));
        this.inputPassword.setText(Utils.generateXorString(AppPrefs.getProperty("settings.proxy.password", "")));
    }

    private void doCancelButtonAction() {
        this.result = 1;
        this.doClose();
    }

    protected final AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    protected final AbstractButton getOkButton() {
        return this.btnCheck;
    }

    private void btnCheck_actionPerformed() {
        if (this.checkProxy.isSelected()) {
            if (this.inputHostName.getText().length() == 0) {
                Swinger.showErrorDialog((Frame)this.getParent(), Lng.getLabel("dialog.connect.message.enterHostName"));
                Swinger.inputFocus(this.inputHostName);
                return;
            }
            if (this.inputPortNumber.getText().length() == 0) {
                Swinger.showErrorDialog((Frame)this.getParent(), Lng.getLabel("dialog.connect.message.enterPort"));
                Swinger.inputFocus(this.inputPortNumber);
                return;
            }
            if (this.checkAuthentification.isSelected() && this.inputLoginName.getText().length() == 0) {
                Swinger.showErrorDialog((Frame)this.getParent(), Lng.getLabel("dialog.connect.message.enterLogin"));
                Swinger.inputFocus(this.inputLoginName);
                return;
            }
        }
        AppPrefs.storeProperty("settings.proxy.proxy", this.checkProxy.isSelected());
        AppPrefs.storeProperty("settings.proxy.login", this.checkAuthentification.isSelected());
        AppPrefs.storeProperty("settings.proxy.url", this.inputHostName.getText());
        AppPrefs.storeProperty("settings.proxy.port", this.inputPortNumber.getText());
        AppPrefs.storeProperty("settings.proxy.savepassword", this.checkSavePassword.isSelected());
        AppPrefs.storeProperty("settings.proxy.username", this.inputLoginName.getText());
        AppPrefs.storeProperty("settings.proxy.password", Utils.generateXorString(this.inputPassword.getText()));
        this.result = 0;
        this.doClose();
    }

    private void useAuthentification(boolean bl) {
        this.inputLoginName.setEnabled(bl);
        this.inputPassword.setEnabled(bl);
        this.checkSavePassword.setEnabled(bl);
        this.labelLoginName.setEnabled(bl);
        this.labelPassword.setEnabled(bl);
        this.labelWarning.setEnabled(bl);
        if (bl) {
            Swinger.inputFocus(this.inputLoginName);
        }
    }

    private void useHttpProxy(boolean bl) {
        Component[] componentArray;
        this.checkProxy.setSelected(bl);
        for (Component component : componentArray = this.panelProxy.getComponents()) {
            if (componentArray.equals(this.checkProxy)) continue;
            component.setEnabled(bl);
        }
        if (this.checkAuthentification.isSelected() && bl) {
            this.useAuthentification(true);
        } else {
            this.useAuthentification(false);
        }
        if (bl) {
            Swinger.inputFocus(this.inputHostName);
        }
        this.checkProxy.setEnabled(true);
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.panelProxy.setLayout(new GridBagLayout());
        CheckAdapter checkAdapter = new CheckAdapter();
        this.inputPortNumber.setDocument(new LimitedPlainDocument("[0-9]{0,6}"));
        Swinger.addKeyActions(this.inputHostName);
        Swinger.addKeyActions(this.inputLoginName);
        Swinger.addKeyActions(this.inputPassword);
        Swinger.addKeyActions(this.inputPortNumber);
        int n = this.inputLoginName.getPreferredSize().height;
        Swinger.SelectAllOnFocusListener selectAllOnFocusListener = new Swinger.SelectAllOnFocusListener();
        this.inputHostName.addFocusListener(selectAllOnFocusListener);
        this.inputPortNumber.addFocusListener(selectAllOnFocusListener);
        this.inputLoginName.addFocusListener(selectAllOnFocusListener);
        this.inputPassword.addFocusListener(selectAllOnFocusListener);
        this.inputHostName.setPreferredSize(new Dimension(75, n));
        this.inputPortNumber.setPreferredSize(new Dimension(50, n));
        this.checkProxy.addActionListener(checkAdapter);
        JLabel jLabel = new JLabel(Lng.getLabel("dialog.connect.labelHostName"));
        jLabel.setLabelFor(this.inputHostName);
        this.panelProxy.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.panelProxy.add((Component)this.inputHostName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        JLabel jLabel2 = new JLabel(Lng.getLabel("dialog.connect.labelPortNumber"));
        jLabel2.setLabelFor(this.inputPortNumber);
        this.panelProxy.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 4, 1, 1), 0, 0));
        this.panelProxy.add((Component)this.inputPortNumber, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.panelProxy.add((Component)this.inputPassword, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.checkAuthentification = Swinger.getCheckBox("dialog.connect.checkAutentification");
        this.checkAuthentification.addActionListener(checkAdapter);
        this.panelProxy.add((Component)this.checkAuthentification, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.labelLoginName.setLabelFor(this.inputLoginName);
        this.panelProxy.add((Component)this.labelLoginName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.panelProxy.add((Component)this.inputLoginName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.labelPassword.setLabelFor(this.inputPassword);
        this.panelProxy.add((Component)this.labelPassword, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 2));
        this.checkSavePassword = Swinger.getCheckBox("dialog.connect.checkSavePassword");
        this.panelProxy.add((Component)this.checkSavePassword, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 2, 1, 1), 0, 4));
        this.panelProxy.add((Component)this.labelWarning, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        JPanel jPanel = new JPanel(new EqualsLayout(5));
        this.btnCheck = Swinger.getButton("dialog.connect.btnCheck");
        container.add((Component)this.panelProxyPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0));
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 6), 0, 6));
        this.btnCancel = Swinger.getButton("dialog.connect.btnCancel");
        Dimension dimension = new Dimension(85, 25);
        ActionButtonsAdapter actionButtonsAdapter = new ActionButtonsAdapter();
        this.btnCheck.addActionListener(actionButtonsAdapter);
        this.btnCancel.addActionListener(actionButtonsAdapter);
        this.btnCheck.setRolloverEnabled(false);
        this.btnCancel.setRolloverEnabled(false);
        this.btnCheck.setMinimumSize(dimension);
        this.btnCancel.setMinimumSize(dimension);
        jPanel.add(this.btnCheck);
        jPanel.add(this.btnCancel);
    }

    private final class ActionButtonsAdapter
    implements ActionListener {
        private ActionButtonsAdapter() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ConnectDialog.this.btnCheck)) {
                ConnectDialog.this.btnCheck_actionPerformed();
            } else {
                ConnectDialog.this.doCancelButtonAction();
            }
        }
    }

    private final class CheckAdapter
    implements ActionListener {
        private CheckAdapter() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ConnectDialog.this.checkProxy)) {
                ConnectDialog.this.useHttpProxy(ConnectDialog.this.checkProxy.isSelected());
            } else if (actionEvent.getSource().equals(ConnectDialog.this.checkAuthentification)) {
                ConnectDialog.this.useAuthentification(ConnectDialog.this.checkAuthentification.isSelected());
            }
        }
    }
}

