/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.wordrider.area.AlphaBetaKeyListener;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.swing.RecentsComboModel;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.layouts.EqualsLayout;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

public final class FindReplaceDialog
extends AppDialog {
    private int mode;
    private JEditorPane editor;
    private Document doc;
    private String searchText;
    private String phrase;
    private String newPhrase;
    private int lastPos;
    private int offset;
    private int replaceDiff;
    private boolean findInProgress = false;
    private int operation;
    private int replaceChoice;
    private final Vector listeners = new Vector(0);
    private static final Object[] replaceOptions = new Object[]{Lng.getLabel("dialog.findr.btnYes"), Lng.getLabel("dialog.findr.btnNo"), Lng.getLabel("dialog.findr.btnAll"), Lng.getLabel("dialog.findr.btnDone")};
    private static final boolean STATE_LOCKED = false;
    private static final boolean STATE_UNLOCKED = true;
    private static final int RO_YES = 0;
    private static final int RO_NO = 1;
    private static final int RO_ALL = 2;
    private static final int RO_DONE = 3;
    private static final int MODE_DOCUMENT = 1;
    private static final int MODE_PROJECT = 2;
    private static final int OP_NONE = 0;
    private static final int OP_FIND = 1;
    private static final int OP_REPLACE = 2;
    private final JButton btnFindNext = Swinger.getButton("dialog.findr.findNext");
    private final JCheckBox jcbStartOnTop = Swinger.getCheckBox("dialog.findr.fromStart");
    private final JRadioButton radioButtonDown = new JRadioButton();
    private final JCheckBox jcbWholeWords = Swinger.getCheckBox("dialog.findr.whole");
    private final JPanel panelOptions = new JPanel();
    private final JPanel panelFind = new JPanel();
    private JComboBox textFieldReplace;
    private final JPanel panelMain = new JPanel();
    private final JRadioButton radioButtonUp = new JRadioButton();
    private JComboBox textFieldPhrase;
    private final JCheckBox jcbMatchCase = Swinger.getCheckBox("dialog.findr.case");
    private final JLabel jLabel3 = new JLabel();
    private final JLabel jLabel4 = new JLabel();
    private final GridBagLayout gridBagLayout5 = new GridBagLayout();
    private final JButton btnClose = Swinger.getButton("dialog.findr.closeBtn");
    private final GridBagLayout gridBagLayout6 = new GridBagLayout();
    private final JButton btnReplace = Swinger.getButton("dialog.findr.replaceBtn");
    private final JButton btnCancel = Swinger.getButton("dialog.findr.cancelBtn");
    private final JCheckBox jcbProject = new JCheckBox();
    private int replaceCount;
    private static final String PHRASE_PREFERENCES = "findPhrase";
    private static final String REPLACE_PREFERENCES = "replacePhrase";
    private static final Logger logger = Logger.getLogger(FindReplaceDialog.class.getName());

    public FindReplaceDialog(Frame frame, JEditorPane jEditorPane) {
        super(frame, true);
        this.setDefaultCloseOperation(2);
        this.setEditor(jEditorPane);
        this.setMode(1);
        try {
            this.init();
            this.initDialogContents();
            this.centerDialog(frame);
            this.setTitle(Lng.getLabel("dialog.findr.title"));
            this.pack();
            this.setVisible(true);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            logger.info("Saving find/replace strings to preferences");
            this.saveUsedPhrases();
        }
        super.processWindowEvent(windowEvent);
    }

    protected AbstractButton getCancelButton() {
        if (this.btnCancel.isEnabled()) {
            return this.btnCancel;
        }
        return this.btnClose;
    }

    private void terminateOperation() {
        switch (this.operation) {
            case 1: {
                this.message(Lng.getLabel("dialog.findr.notfound"));
                this.toggleState(true);
                this.btnReplace.setEnabled(true);
                break;
            }
            case 2: {
                switch (this.replaceChoice) {
                    case 0: 
                    case 1: {
                        this.message(Lng.getLabel("dialog.findr.notfound"));
                        break;
                    }
                    case 2: {
                        this.message(Lng.getLabel("dialog.findr.replaceCount", this.replaceCount));
                        break;
                    }
                }
                this.toggleState(true);
                this.editor.firePropertyChange("undoredo", true, false);
                this.setVisible(true);
            }
        }
        this.operation = 0;
    }

    private void btnFindNext_actionPerformed() {
        this.operation = 1;
        this.btnReplace.setEnabled(false);
        if (this.mode != 2 || !this.jcbProject.isSelected() || this.listeners.isEmpty() || this.findInProgress) {
            this.initFind();
            this.find();
        }
    }

    private void btnReplace_actionPerformed() {
        this.operation = 2;
        this.replaceChoice = 0;
        this.setVisible(false);
        if (this.mode != 2 || !this.jcbProject.isSelected() || this.listeners.isEmpty()) {
            this.initFind();
            this.replace();
        }
        Swinger.inputFocus(this.textFieldReplace);
    }

    private void btnCancel_actionPerformed() {
        this.toggleState(true);
        this.btnReplace.setEnabled(true);
        Swinger.inputFocus(this.textFieldPhrase);
    }

    private void storeProperties(String string, JComboBox jComboBox) {
        Collection collection = ((RecentsComboModel)jComboBox.getModel()).getList();
        int n = collection.size() - 1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AppPrefs.storeProperty(string + n, iterator.next().toString());
            --n;
        }
    }

    private void saveUsedPhrases() {
        this.storeProperties(PHRASE_PREFERENCES, this.textFieldPhrase);
        this.storeProperties(REPLACE_PREFERENCES, this.textFieldReplace);
    }

    private void btnClose_actionPerformed() {
        this.saveUsedPhrases();
        this.dispose();
    }

    private void setEditor(JEditorPane jEditorPane) {
        this.editor = jEditorPane;
        this.doc = jEditorPane.getDocument();
    }

    private void setMode(int n) {
        this.mode = n;
        if (n == 2) {
            this.jcbProject.setVisible(true);
        } else {
            this.jcbProject.setVisible(false);
        }
    }

    private void initFind() {
        if (!this.findInProgress) {
            try {
                this.searchText = this.doc.getText(0, this.doc.getLength());
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
            this.phrase = this.textFieldPhrase.getEditor().getItem().toString();
            ((RecentsComboModel)this.textFieldPhrase.getModel()).addElement(this.phrase);
            this.newPhrase = this.textFieldReplace.getEditor().getItem().toString();
            ((RecentsComboModel)this.textFieldReplace.getModel()).addElement(this.newPhrase);
            this.replaceDiff = this.newPhrase.length() - this.phrase.length();
            this.offset = 0;
            if (!this.jcbMatchCase.isSelected()) {
                this.phrase = this.phrase.toLowerCase();
                this.searchText = this.searchText.toLowerCase();
            }
            this.lastPos = this.jcbStartOnTop.isSelected() ? (this.radioButtonUp.isSelected() ? this.doc.getLength() : 0) : this.editor.getSelectionStart();
            this.toggleState(false);
        }
    }

    private void find() {
        if (!this.doFind()) {
            if (this.mode != 2 || !this.jcbProject.isSelected() || this.listeners.isEmpty()) {
                this.terminateOperation();
            }
            Swinger.inputFocus(this.textFieldPhrase);
        } else {
            this.btnFindNext.setEnabled(true);
            Swinger.inputFocus(this.btnFindNext);
        }
    }

    private boolean doFind() {
        boolean bl = false;
        int n = this.findNext();
        if (this.jcbWholeWords.isSelected()) {
            n = this.findWholeWords(n);
        }
        if (n >= 0) {
            this.lastPos = n;
            if (this.radioButtonDown.isSelected()) {
                n += this.offset;
            }
            this.editor.select(n, n + this.phrase.length());
            bl = true;
        }
        return bl;
    }

    private int findNext() {
        int n = this.radioButtonUp.isSelected() ? (this.lastPos < this.doc.getLength() ? this.searchText.lastIndexOf(this.phrase, this.lastPos - 1) : this.searchText.lastIndexOf(this.phrase, this.lastPos)) : (this.lastPos > 0 ? this.searchText.indexOf(this.phrase, this.lastPos + this.phrase.length()) : this.searchText.indexOf(this.phrase, this.lastPos));
        return n;
    }

    private int findWholeWords(int n) {
        while (!(n <= 0 || RiderEditorKit.WORD_SEPARATORS.get(this.searchText.charAt(n - 1)) && RiderEditorKit.WORD_SEPARATORS.get(this.searchText.charAt(n + this.phrase.length())))) {
            this.lastPos = n;
            n = this.findNext();
        }
        return n;
    }

    private void replace() {
        this.editor.firePropertyChange("undoredo", false, true);
        while (this.doFind() && this.replaceChoice != 3) {
            if (this.replaceChoice != 2) {
                this.replaceChoice = this.getReplaceChoice();
            }
            switch (this.replaceChoice) {
                case 0: {
                    this.replaceOne();
                    break;
                }
                case 2: {
                    this.replaceOne();
                    this.replaceCount = 1;
                    while (this.doFind()) {
                        this.replaceOne();
                        ++this.replaceCount;
                    }
                    break;
                }
            }
        }
        if (this.mode == 2 && this.jcbProject.isSelected() && !this.listeners.isEmpty()) {
            switch (this.replaceChoice) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    this.terminateOperation();
                    break;
                }
                default: {
                    this.terminateOperation();
                    break;
                }
            }
        } else {
            this.terminateOperation();
        }
    }

    private int getReplaceChoice() {
        return JOptionPane.showOptionDialog(this, Lng.getLabel("dialog.findr.confirmR", this.phrase), Lng.getLabel("dialog.findr.title"), 1, 3, null, replaceOptions, null);
    }

    private void replaceOne() {
        this.editor.replaceSelection(this.newPhrase);
        this.offset += this.replaceDiff;
    }

    private void initDialogContents() {
        this.btnCancel.setEnabled(false);
        this.radioButtonUp.setSelected(false);
        this.radioButtonDown.setSelected(true);
        this.jcbWholeWords.setSelected(false);
        this.jcbMatchCase.setSelected(false);
        this.jcbStartOnTop.setSelected(true);
        this.jcbProject.setSelected(false);
        this.textFieldPhrase.getEditor().setItem(this.editor.getSelectedText());
        this.btnFindNext.setEnabled(!Swinger.isEmpty(this.textFieldPhrase));
        this.btnReplace.setEnabled(this.btnFindNext.isEnabled());
        this.textFieldReplace.getEditor().setItem("");
    }

    private void centerDialog(Frame frame) {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = frame.getSize();
        Point point = frame.getLocation();
        this.setLocation((dimension2.width - dimension.width) / 2 + point.x + 150, (dimension2.height - dimension.height) / 2 + point.y - 50);
    }

    private void toggleState(boolean bl) {
        this.btnCancel.setEnabled(!bl);
        this.btnFindNext.setEnabled(bl && !Swinger.isEmpty(this.textFieldPhrase));
        this.textFieldPhrase.setEnabled(bl);
        this.textFieldReplace.setEnabled(bl);
        this.jLabel3.setEnabled(bl);
        this.jLabel4.setEnabled(bl);
        this.jcbWholeWords.setEnabled(bl);
        this.jcbMatchCase.setEnabled(bl);
        this.jcbStartOnTop.setEnabled(bl);
        this.radioButtonUp.setEnabled(bl);
        this.radioButtonDown.setEnabled(bl);
        this.jcbProject.setEnabled(bl);
        this.findInProgress = !bl;
    }

    private void message(String string) {
        JOptionPane.showMessageDialog(this, string, Lng.getLabel("dialog.findr.title"), 1);
    }

    private void init() {
        Serializable serializable;
        JPanel jPanel = new JPanel(new EqualsLayout(1, 5));
        this.textFieldPhrase = new JComboBox(Swinger.loadSearchUsedList(PHRASE_PREFERENCES));
        this.textFieldReplace = new JComboBox(Swinger.loadSearchUsedList(REPLACE_PREFERENCES));
        this.textFieldPhrase.setEditable(true);
        this.textFieldReplace.setEditable(true);
        this.textFieldPhrase.setMaximumRowCount(5);
        this.textFieldReplace.setMaximumRowCount(5);
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Lng.getLabel("dialog.findr.options"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnFindNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnFindNext_actionPerformed();
            }
        });
        this.radioButtonDown.setText(Lng.getLabel("dialog.findr.searchDown"));
        this.radioButtonDown.setMnemonic(Lng.getMnemonic("dialog.findr.searchDown"));
        this.panelOptions.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(3, 2, 4, 2)));
        this.panelOptions.setLayout(new GridBagLayout());
        this.panelFind.setLayout(this.gridBagLayout5);
        this.textFieldReplace.setMinimumSize(new Dimension(4, 12));
        this.textFieldReplace.setPreferredSize(new Dimension(30, 12));
        this.panelMain.setLayout(this.gridBagLayout6);
        this.radioButtonUp.setText(Lng.getLabel("dialog.findr.searchup"));
        this.radioButtonUp.setMnemonic(Lng.getMnemonic("dialog.findr.searchup"));
        this.textFieldPhrase.setMinimumSize(new Dimension(4, 12));
        this.textFieldPhrase.setPreferredSize(new Dimension(44, 12));
        Swinger.SelectAllOnFocusListener selectAllOnFocusListener = new Swinger.SelectAllOnFocusListener();
        ActionKeyListener actionKeyListener = new ActionKeyListener();
        this.textFieldPhrase.addKeyListener(actionKeyListener);
        Component component = this.textFieldPhrase.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            serializable = (JTextComponent)component;
            ((Component)serializable).addKeyListener(actionKeyListener);
            ((JTextComponent)serializable).getDocument().addDocumentListener(new InputFieldsMethodListener());
            ((Component)serializable).addFocusListener(selectAllOnFocusListener);
            Swinger.addKeyActions((JComponent)serializable);
        }
        if ((component = this.textFieldReplace.getEditor().getEditorComponent()) instanceof JTextComponent) {
            serializable = (JTextComponent)component;
            ((Component)serializable).addKeyListener(actionKeyListener);
            ((Component)serializable).addFocusListener(selectAllOnFocusListener);
            Swinger.addKeyActions((JComponent)serializable);
        }
        serializable = RiderStyles.getAreaFont().deriveFont(0, 12.0f);
        this.textFieldPhrase.setFont((Font)serializable);
        this.textFieldReplace.setFont((Font)serializable);
        this.jLabel3.setText(Lng.getLabel("dialog.findr.replacewith"));
        this.jLabel4.setText(Lng.getLabel("dialog.findr.textfind"));
        this.jLabel3.setLabelFor(this.textFieldPhrase);
        this.jLabel3.setDisplayedMnemonic(Lng.getMnemonic("dialog.findr.replacewith"));
        this.jLabel4.setDisplayedMnemonic(Lng.getMnemonic("dialog.findr.textfind"));
        this.jLabel4.setLabelFor(this.textFieldReplace);
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnClose_actionPerformed();
            }
        });
        this.btnReplace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnReplace_actionPerformed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplaceDialog.this.btnCancel_actionPerformed();
            }
        });
        Dimension dimension = new Dimension(75, 25);
        this.btnFindNext.setMinimumSize(dimension);
        this.btnClose.setMinimumSize(dimension);
        this.btnReplace.setMinimumSize(dimension);
        this.btnCancel.setMinimumSize(dimension);
        jPanel.add(this.btnFindNext);
        jPanel.add(this.btnClose);
        jPanel.add(this.btnReplace);
        jPanel.add(this.btnCancel);
        this.getContentPane().add((Component)this.panelMain, "North");
        this.panelMain.add((Component)this.panelFind, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.panelMain.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 12, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.panelFind.add((Component)this.textFieldPhrase, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 0, 0), 0, 12));
        this.panelFind.add((Component)this.jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.panelFind.add((Component)this.textFieldReplace, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 0, 0), 0, 12));
        this.panelFind.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.panelMain.add((Component)this.panelOptions, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.panelOptions.add((Component)this.jcbWholeWords, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(-10, 0, 0, 0), 10, 0));
        this.panelOptions.add((Component)this.jcbMatchCase, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(-6, 0, -5, 0), 10, 0));
        this.panelOptions.add((Component)this.jcbStartOnTop, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(-3, 0, -5, 0), 10, 0));
        this.panelOptions.add((Component)this.radioButtonUp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(-10, 0, 0, 0), 0, 0));
        this.panelOptions.add((Component)this.radioButtonDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(-3, 0, 0, 0), 0, 0));
        buttonGroup.add(this.radioButtonUp);
        buttonGroup.add(this.radioButtonDown);
    }

    private final class InputFieldsMethodListener
    implements DocumentListener {
        private InputFieldsMethodListener() {
        }

        public void inputMethodTextChanged() {
            boolean bl = Swinger.isEmpty(FindReplaceDialog.this.textFieldPhrase);
            if (FindReplaceDialog.this.btnFindNext.isEnabled() != !bl) {
                FindReplaceDialog.this.btnFindNext.setEnabled(!bl);
            }
            if (FindReplaceDialog.this.btnReplace.isEnabled() != !bl) {
                FindReplaceDialog.this.btnReplace.setEnabled(!bl);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.inputMethodTextChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.inputMethodTextChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.inputMethodTextChanged();
        }
    }

    private final class ActionKeyListener
    extends AlphaBetaKeyListener {
        private ActionKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTextField jTextField = (JTextField)keyEvent.getSource();
                keyEvent.consume();
                if (jTextField.equals(FindReplaceDialog.this.textFieldPhrase.getEditor().getEditorComponent())) {
                    FindReplaceDialog.this.btnFindNext.doClick();
                    FindReplaceDialog.this.btnFindNext_actionPerformed();
                } else {
                    FindReplaceDialog.this.btnReplace.doClick();
                    FindReplaceDialog.this.btnReplace_actionPerformed();
                }
            } else {
                super.keyPressed(keyEvent);
            }
        }
    }
}

