/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.JButtonGroup;
import net.wordrider.dialogs.LimitedPlainDocument;
import net.wordrider.dialogs.layouts.EqualsLayout;
import net.wordrider.files.ti68kformat.TIFileInfo;
import net.wordrider.files.ti68kformat.TIImageFileInfo;
import net.wordrider.files.ti68kformat.TITextFileInfo;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

public final class SaveSettingsDialog
extends AppDialog {
    private final JTextField inputFolder = new JTextField();
    private final JTextField inputVariable = new JTextField();
    private final JTextField inputComment = new JTextField();
    private final JButtonGroup buttonGroup = new JButtonGroup();
    private final JButtonGroup radioGroup = new JButtonGroup();
    private JRadioButton radioDontChange;
    private JRadioButton radioUseLast;
    private JRadioButton radioSameAsDocument;
    private JRadioButton radioSetNew;
    private JRadioButton radioStoreType1;
    private JRadioButton radioStoreType2;
    private JRadioButton radioStoreType3;
    private final JTextField inputPictureFolder = new JTextField();
    private final JComboBox comboOutputFormat = new JComboBox<Object>(new Object[]{"Hibview", "TxtRider/uView"});
    private JButton btnCancel;
    private JButton btnSave;
    private final JCheckBox checkSave = Swinger.getCheckBox("savesettings.pictures");
    private final JCheckBox checkInsertIntoDocument = Swinger.getCheckBox("savesettings.pictures.insert");
    private TIFileInfo fileInfo;
    private final Frame frame;
    private final JPanel pictureTabPanel = new JPanel(new GridBagLayout());
    private final JPanel generalPanel = new JPanel(new GridBagLayout());
    private final JPanel outputFormatPanel = new JPanel(new GridBagLayout());
    private final JTabbedPane tabbedPane = new JTabbedPane(1, 1);
    public static final Pattern regexpFolderPattern = Pattern.compile("\\p{Alpha}\\w{0,7}");
    public static final int STATUS_TEXTFILE = 0;
    public static final int STATUS_IMAGE = 1;
    public static final int STATUS_IMAGE_IMAGEPROPERTIES = 2;
    private final int statusWindow;
    public static final Pattern regexpComment = Pattern.compile("^\\p{Alnum}[A-Za-z0-9_]{0,39}$");
    private static final Logger logger = Logger.getLogger(SaveSettingsDialog.class.getName());

    public SaveSettingsDialog(Frame frame, TIFileInfo tIFileInfo, int n) {
        super(frame, true);
        this.frame = frame;
        this.statusWindow = n;
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        switch (n) {
            case 0: {
                this.tabbedPane.addTab(Lng.getLabel("savesettings.tab.pictures"), this.pictureTabPanel);
                TITextFileInfo tITextFileInfo = (TITextFileInfo)tIFileInfo;
                int n2 = tITextFileInfo.getOutputFormat();
                if (n2 == -1) {
                    this.comboOutputFormat.setSelectedIndex(AppPrefs.getProperty("settings.outputFormat", 0));
                } else {
                    this.comboOutputFormat.setSelectedIndex(n2);
                }
                this.setTitle(Lng.getLabel("savesettings.title"));
                break;
            }
            case 1: {
                this.checkInsertIntoDocument.setSelected(AppPrefs.getProperty("settings.insertImage", true));
                this.setTitle(Lng.getLabel("savesettings.title"));
                break;
            }
            case 2: {
                this.setTitle(Lng.getLabel("savesettings.title2"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid argument status Window");
            }
        }
        this.tabbedPane.setSelectedComponent(this.generalPanel);
        this.pack();
        this.initDialogContents(tIFileInfo);
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void initDialogContents(TIFileInfo tIFileInfo) {
        boolean bl;
        Swinger.addKeyActions(this.inputFolder);
        Swinger.addKeyActions(this.inputVariable);
        Swinger.addKeyActions(this.inputComment);
        Swinger.addKeyActions(this.inputPictureFolder);
        if (tIFileInfo.getFolderName().length() == 0) {
            this.inputFolder.setText(AppPrefs.getProperty("settings.defaultFolder", "main"));
            this.inputComment.setText(AppPrefs.getProperty("settings.defaultComment", "generated_by_WordRider"));
            this.inputVariable.setText(AppPrefs.getProperty("settings.defaultVariable", "unknown"));
        } else {
            this.inputFolder.setText(tIFileInfo.getFolderName());
            this.inputComment.setText(tIFileInfo.getComment());
            this.inputVariable.setText(tIFileInfo.getVarName());
        }
        if (tIFileInfo instanceof TITextFileInfo) {
            this.inputPictureFolder.setText(((TITextFileInfo)tIFileInfo).getPictureFolder());
        }
        if (bl = tIFileInfo instanceof TITextFileInfo) {
            switch (((TITextFileInfo)tIFileInfo).getPictureProcessingType()) {
                case 3: {
                    this.checkSave.setSelected(false);
                    this.radioDontChange.setSelected(true);
                    break;
                }
                case 4: {
                    this.radioSameAsDocument.setSelected(true);
                    break;
                }
                case 0: {
                    this.radioDontChange.setSelected(true);
                    break;
                }
                case 1: {
                    this.radioUseLast.setSelected(true);
                    break;
                }
                case 2: {
                    this.radioSetNew.setSelected(true);
                    break;
                }
            }
        }
        switch (tIFileInfo.getStoreType()) {
            case 0: {
                this.radioStoreType1.setSelected(true);
                break;
            }
            case 1: {
                this.radioStoreType2.setSelected(true);
                break;
            }
            case 2: {
                this.radioStoreType3.setSelected(true);
                break;
            }
        }
        if (bl) {
            this.checkSave.setSelected(((TITextFileInfo)tIFileInfo).getPictureProcessingType() != 3);
        }
        this.checkSave_actionPerformed();
        this.inputPictureFolder.setEnabled(this.radioSetNew.isSelected());
        Swinger.inputFocus(this.inputFolder);
    }

    public TIFileInfo getResult() {
        return this.fileInfo;
    }

    private void doCancelButtonAction() {
        this.doClose();
    }

    protected AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    protected AbstractButton getOkButton() {
        return this.btnSave;
    }

    private boolean checkNameValidity(JTextField jTextField, Component component) {
        boolean bl = true;
        String string = jTextField.getText();
        if (string == null || string.equals("") && !jTextField.equals(this.inputComment)) {
            Swinger.showErrorDialog(this.frame, Lng.getLabel("savesettings.mustbeset"));
            bl = false;
        }
        this.tabbedPane.setSelectedComponent(component);
        if (!bl) {
            Swinger.inputFocus(jTextField);
        }
        return bl;
    }

    private void btnSave_actionPerformed() {
        int n;
        if (!(this.checkNameValidity(this.inputFolder, this.generalPanel) && this.checkNameValidity(this.inputVariable, this.generalPanel) && this.checkNameValidity(this.inputComment, this.generalPanel))) {
            return;
        }
        TITextFileInfo tITextFileInfo = null;
        switch (this.statusWindow) {
            case 0: {
                this.fileInfo = new TITextFileInfo();
                tITextFileInfo = (TITextFileInfo)this.fileInfo;
                n = this.comboOutputFormat.getSelectedIndex();
                tITextFileInfo.setOutputFormat(n);
                AppPrefs.storeProperty("settings.outputFormat", n);
                break;
            }
            case 1: {
                this.fileInfo = new TIImageFileInfo();
                boolean bl = this.checkInsertIntoDocument.isSelected();
                ((TIImageFileInfo)this.fileInfo).setInsertIntoDocument(bl);
                AppPrefs.storeProperty("settings.insertImage", bl);
                break;
            }
            case 2: {
                this.fileInfo = new TIFileInfo();
            }
        }
        this.fileInfo.setComment(this.inputComment.getText());
        this.fileInfo.setFolderName(this.inputFolder.getText());
        this.fileInfo.setVarName(this.inputVariable.getText());
        if (!this.checkSave.isSelected()) {
            n = 3;
        } else {
            AbstractButton abstractButton = this.buttonGroup.getSelected();
            if (abstractButton.equals(this.radioDontChange)) {
                n = 0;
            } else if (abstractButton.equals(this.radioUseLast)) {
                n = 1;
            } else if (abstractButton.equals(this.radioSameAsDocument)) {
                n = 4;
            } else if (abstractButton.equals(this.radioSetNew)) {
                if (!this.checkNameValidity(this.inputPictureFolder, this.pictureTabPanel)) {
                    return;
                }
                n = 2;
                if (tITextFileInfo != null) {
                    tITextFileInfo.setPictureFolder(this.inputPictureFolder.getText());
                }
            } else {
                n = 0;
            }
        }
        AbstractButton abstractButton = this.radioGroup.getSelected();
        if (abstractButton.equals(this.radioStoreType1)) {
            this.fileInfo.setStoreType(0, false);
        } else if (abstractButton.equals(this.radioStoreType2)) {
            this.fileInfo.setStoreType(1, false);
        } else {
            this.fileInfo.setStoreType(2, false);
        }
        if (tITextFileInfo != null) {
            tITextFileInfo.setPictureProcessingType(n);
        }
        this.doClose();
    }

    private void checkSave_actionPerformed() {
        boolean bl = this.checkSave.isSelected();
        this.radioDontChange.setEnabled(bl);
        this.radioSetNew.setEnabled(bl);
        this.radioUseLast.setEnabled(bl);
        this.radioSameAsDocument.setEnabled(bl);
    }

    private void init() {
        this.inputFolder.setDocument(new LimitedPlainDocument(regexpFolderPattern));
        this.inputVariable.setDocument(new LimitedPlainDocument(regexpFolderPattern));
        this.inputComment.setDocument(new LimitedPlainDocument(regexpComment));
        this.inputPictureFolder.setDocument(new LimitedPlainDocument(regexpFolderPattern));
        Swinger.SelectAllOnFocusListener selectAllOnFocusListener = new Swinger.SelectAllOnFocusListener();
        this.inputFolder.addFocusListener(selectAllOnFocusListener);
        this.inputVariable.addFocusListener(selectAllOnFocusListener);
        this.inputComment.addFocusListener(selectAllOnFocusListener);
        this.inputPictureFolder.addFocusListener(selectAllOnFocusListener);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new GridBagLayout());
        container.setLayout(new GridBagLayout());
        JLabel jLabel = Swinger.getLabel("savesettings.input.folder");
        jLabel.setLabelFor(this.inputFolder);
        JLabel jLabel2 = Swinger.getLabel("savesettings.input.variable");
        jLabel2.setLabelFor(this.inputVariable);
        JLabel jLabel3 = Swinger.getLabel("savesettings.input.comment");
        jLabel3.setLabelFor(this.inputComment);
        jPanel.setEnabled(true);
        jPanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.gray, 1), Lng.getLabel("savesettings.pictures.folder")));
        this.radioDontChange = Swinger.getRadio("savesettings.pictures.samesource");
        this.radioSameAsDocument = Swinger.getRadio("savesettings.pictures.samefolder");
        this.radioUseLast = Swinger.getRadio("savesettings.pictures.lastfolder");
        this.radioSetNew = Swinger.getRadio("savesettings.pictures.newfolder");
        this.radioStoreType1 = Swinger.getRadio("savesettings.storetype.ram");
        this.radioStoreType2 = Swinger.getRadio("savesettings.storetype.ramLocked");
        this.radioStoreType3 = Swinger.getRadio("savesettings.storetype.archive");
        Border border = BorderFactory.createEmptyBorder(3, 2, 3, 2);
        this.radioStoreType1.setBorder(border);
        this.radioStoreType2.setBorder(border);
        this.radioStoreType3.setBorder(border);
        RadiosAdapter radiosAdapter = new RadiosAdapter();
        this.radioSameAsDocument.addActionListener(radiosAdapter);
        this.radioDontChange.addActionListener(radiosAdapter);
        this.radioUseLast.addActionListener(radiosAdapter);
        this.radioSetNew.addActionListener(radiosAdapter);
        JPanel jPanel2 = new JPanel(new EqualsLayout(5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        Dimension dimension = new Dimension(85, 25);
        this.btnCancel = Swinger.getButton("savesettings.cancelBtn");
        this.btnCancel.setMinimumSize(dimension);
        this.btnSave = Swinger.getButton("savesettings.saveBtn");
        this.btnSave.setMinimumSize(dimension);
        ActionButtonsAdapter actionButtonsAdapter = new ActionButtonsAdapter();
        this.btnSave.addActionListener(actionButtonsAdapter);
        this.btnCancel.addActionListener(actionButtonsAdapter);
        this.checkSave.addActionListener(new CheckSaveAdapter());
        this.inputFolder.setPreferredSize(new Dimension(80, this.inputFolder.getPreferredSize().height));
        this.inputVariable.setPreferredSize(this.inputFolder.getPreferredSize());
        this.generalPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(3, 4, 4, 0), 0, 0));
        this.generalPanel.add((Component)jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(4, 4, 4, 0), 0, 0));
        this.generalPanel.add((Component)this.inputFolder, new GridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 17, 2, new Insets(4, 4, 4, 4), this.statusWindow != 0 ? 20 : 0, 0));
        this.generalPanel.add((Component)this.inputVariable, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.generalPanel.add((Component)this.inputComment, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.generalPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(4, 4, 4, 4), 0, 0));
        if (this.statusWindow == 0) {
            this.inputPictureFolder.setMaximumSize(this.inputFolder.getPreferredSize());
            jPanel.add((Component)this.radioDontChange, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 0, 0), 0, 0));
            jPanel.add((Component)this.radioUseLast, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 2, 2), 0, 0));
            jPanel.add((Component)this.radioSameAsDocument, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 0, 0), 0, 0));
            jPanel.add((Component)this.radioSetNew, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 0, 0), 0, 0));
            jPanel.add((Component)this.inputPictureFolder, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 4, 5), 80, 0));
            this.pictureTabPanel.add((Component)this.checkSave, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 5, 0));
            JLabel jLabel4 = Swinger.getLabel("savesettings.outputFormat");
            Dimension dimension2 = this.comboOutputFormat.getPreferredSize();
            dimension2.height = 23;
            this.comboOutputFormat.setPreferredSize(dimension2);
            jLabel3.setLabelFor(this.comboOutputFormat);
            this.outputFormatPanel.add((Component)jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(3, 4, 4, 0), 0, 0));
            this.outputFormatPanel.add((Component)this.comboOutputFormat, new GridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 17, 3, new Insets(4, 4, 4, 4), 0, 0));
        }
        this.radioGroup.add(this.radioStoreType1);
        this.radioGroup.add(this.radioStoreType2);
        this.radioGroup.add(this.radioStoreType3);
        this.buttonGroup.add(this.radioDontChange);
        this.buttonGroup.add(this.radioUseLast);
        this.buttonGroup.add(this.radioSameAsDocument);
        this.buttonGroup.add(this.radioSetNew);
        jPanel3.setBorder(BorderFactory.createTitledBorder(Lng.getLabel("savesettings.storetype")));
        jPanel3.add(this.radioStoreType1);
        jPanel3.add(this.radioStoreType2);
        jPanel3.add(this.radioStoreType3);
        jPanel2.add(this.btnSave);
        jPanel2.add(this.btnCancel);
        this.pictureTabPanel.add((Component)jPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)jPanel3, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 12, 2, new Insets(0, 0, 2, 0), 0, 0));
        if (this.statusWindow == 0) {
            this.generalPanel.add((Component)this.outputFormatPanel, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 12, 2, new Insets(0, 0, 2, 0), 0, 0));
        }
        if (this.statusWindow == 1) {
            this.generalPanel.add((Component)this.checkInsertIntoDocument, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 4, 5), 0, 0));
        }
        container.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 2, 2, 2), 0, 0));
        container.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(2, 2, 2, 6), 0, 2));
        this.tabbedPane.addTab(Lng.getLabel("savesettings.tab.general"), this.generalPanel);
    }

    private final class RadiosAdapter
    implements ActionListener {
        private RadiosAdapter() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            boolean bl = actionEvent.getSource().equals(SaveSettingsDialog.this.radioSetNew);
            SaveSettingsDialog.this.inputPictureFolder.setEnabled(bl);
            if (bl) {
                Swinger.inputFocus(SaveSettingsDialog.this.inputPictureFolder);
            }
        }
    }

    private final class CheckSaveAdapter
    implements ActionListener {
        private CheckSaveAdapter() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            SaveSettingsDialog.this.checkSave_actionPerformed();
        }
    }

    private final class ActionButtonsAdapter
    implements ActionListener {
        private ActionButtonsAdapter() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(SaveSettingsDialog.this.btnSave)) {
                SaveSettingsDialog.this.btnSave_actionPerformed();
            } else {
                SaveSettingsDialog.this.doCancelButtonAction();
            }
        }
    }
}

