/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.pictures;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.SaveAsFileAction;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.JButtonGroup;
import net.wordrider.dialogs.layouts.EqualsLayout;
import net.wordrider.dialogs.pictures.FilterPlugin;
import net.wordrider.dialogs.pictures.InputPicturePanel;
import net.wordrider.dialogs.pictures.PicturePanel;
import net.wordrider.dialogs.pictures.WidthSpinnerModel;
import net.wordrider.dialogs.pictures.filters.AlphaFilter;
import net.wordrider.dialogs.pictures.filters.BrightnessFilter;
import net.wordrider.dialogs.pictures.filters.BurkeFilter;
import net.wordrider.dialogs.pictures.filters.ContrastFilter;
import net.wordrider.dialogs.pictures.filters.DitherRaster;
import net.wordrider.dialogs.pictures.filters.ErrorDiffusion;
import net.wordrider.dialogs.pictures.filters.JarvisErrorDiffusion;
import net.wordrider.dialogs.pictures.filters.OrderedDither;
import net.wordrider.dialogs.pictures.filters.OrderedFilter2x2;
import net.wordrider.dialogs.pictures.filters.OrderedFilter3x3_1;
import net.wordrider.dialogs.pictures.filters.OrderedFilter3x3_2;
import net.wordrider.dialogs.pictures.filters.OrderedFilter4x4;
import net.wordrider.dialogs.pictures.filters.QuantizeRaster;
import net.wordrider.dialogs.pictures.filters.RandomRaster;
import net.wordrider.dialogs.pictures.filters.Shiau2ErrorDiffusion;
import net.wordrider.dialogs.pictures.filters.StuckiErrorDiffusion;
import net.wordrider.files.ti68kformat.TIImageFileInfo;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class FilterDialog
extends AppDialog {
    private final JButton btnSave = Swinger.getButton("dialog.images.btn.save");
    private final JButton btnCancel = Swinger.getButton("dialog.images.btn.cancel");
    private final JButton btnReset = Swinger.getButton("dialog.images.btn.reset");
    private final PicturePanel panelOutputPicture = new PicturePanel();
    private final JScrollPane scrollPaneInput = new JScrollPane(20, 30);
    private final JLabel labelFileInputPath = new JLabel();
    private final JCheckBox checkSaveSettings = Swinger.getCheckBox("dialog.images.checkSaveSettings");
    private final JCheckBox checkCropSelection = Swinger.getCheckBox("dialog.images.cropcheck");
    private final JSpinner spinnerWidth = new JSpinner();
    private final JSlider sliderBrightness = new JSlider();
    private final JRadioButton radioBgWhite = Swinger.getRadio("dialog.images.white");
    private final JRadioButton radioBgLCD = Swinger.getRadio("dialog.images.lcd");
    private JComboBox comboFilter;
    private final JSlider sliderContrast = new JSlider();
    private final JSpinner spinnerHeight = new JSpinner();
    private JComboBox comboPosition;
    private final InputPicturePanel panelInputPicture = new InputPicturePanel(this);
    private final JLabel labelInputImageSize = new JLabel();
    private static final int FILTER_INPUT_PICTURE = 0;
    static final int FILTER_SELECTION = 1;
    private static final int FILTER_CROPFIT = 2;
    private static final int FILTER_BRIGHTNESS = 3;
    private static final int FILTER_CONTRAST = 4;
    private static final int FILTER_DITHER = 5;
    private static final int FILTER_SCREEN = 6;
    private static final int FILTER_COUNT = 7;
    private final FilterPlugin[] filterPlugins = new FilterPlugin[7];
    private static final int TI89SCREENWIDTH = 152;
    private static final int TI89SCREENHEIGHT = 79;
    private static final int TI92SCREENWIDTH = 240;
    private static final int TI92SCREENHEIGHT = 120;
    private static final int POSITION_CROP = 0;
    private static final int POSITION_FITWIDTH = 1;
    private static final int POSITION_FITHEIGHT = 2;
    private static final int POSITION_STRETCH = 3;
    private final File file;
    private File outputFile = null;
    private TIImageFileInfo fileInfo = null;
    private final ChangeListener spinnerChangeListener = new SpinnerChangeListener();
    private static final int SRC_SPINNER_WIDTH = 0;
    private static final int SRC_SPINNER_HEIGHT = 1;
    private static final int SRC_INIT = 2;
    static final int SRC_SELECTIONCHANGED = 3;
    private static final int SRC_CROPONOFF = 4;
    private static final int SRC_POSITION = 5;
    private static final int SRC_FILTER = 6;
    private static final int SRC_BRIGHTNESS = 7;
    private static final int SRC_CONTRAST = 8;
    private static final int SRC_BACKGROUND = 9;
    private static final String PROPERTY_IMAGES_CROP = "images.crop";
    private static final String PROPERTY_IMAGES_FILTER = "images.filter";
    private static final String PROPERTY_IMAGES_POSITION = "images.position";
    private static final String PROPERTY_IMAGES_BRIGHTNESS = "images.brightness";
    private static final String PROPERTY_IMAGES_CONTRAST = "images.contrast";
    private static final String PROPERTY_IMAGES_BACKGROUND = "images.background";
    private final boolean formatTI92;
    private final int imageScreenWidth;
    private final int imageScreenHeight;
    private static final Logger logger = Logger.getLogger(FilterDialog.class.getName());
    private final JLabel labelInfoPosition = new JLabel();

    public JScrollPane getScrollPaneInput() {
        return this.scrollPaneInput;
    }

    public FilterDialog(Frame frame, File file, Image image) throws HeadlessException {
        super(frame, true);
        this.formatTI92 = AppPrefs.getProperty("settings.ti92ImageFormat", false);
        if (this.formatTI92) {
            this.imageScreenWidth = 240;
            this.imageScreenHeight = 120;
        } else {
            this.imageScreenWidth = 152;
            this.imageScreenHeight = 79;
        }
        this.file = file;
        try {
            this.init();
            this.initValues();
            this.initFilters(image);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.pack();
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("dialog.images.title"));
        this.setDefaultCloseOperation(2);
    }

    void updateLabelInfoPosition(String string) {
        this.labelInfoPosition.setText(string);
    }

    boolean isCropEnabled() {
        return this.checkCropSelection.isSelected();
    }

    private void initValues() {
        Object object;
        this.checkCropSelection.setSelected(AppPrefs.getProperty(PROPERTY_IMAGES_CROP, true));
        this.radioBgWhite.setSelected(AppPrefs.getProperty(PROPERTY_IMAGES_BACKGROUND, true));
        WidthSpinnerModel widthSpinnerModel = new WidthSpinnerModel();
        this.spinnerWidth.setModel(widthSpinnerModel);
        widthSpinnerModel.setValue(new Integer(this.imageScreenWidth));
        widthSpinnerModel.setMinimum(Integer.valueOf(8));
        widthSpinnerModel.setMaximum(Integer.valueOf(this.imageScreenWidth));
        ((SpinnerNumberModel)this.spinnerHeight.getModel()).setMaximum(Integer.valueOf(this.imageScreenHeight));
        ((SpinnerNumberModel)this.spinnerHeight.getModel()).setMinimum(Integer.valueOf(1));
        this.spinnerHeight.setValue(this.imageScreenHeight);
        this.spinnerWidth.addChangeListener(this.spinnerChangeListener);
        this.spinnerHeight.addChangeListener(this.spinnerChangeListener);
        SliderChangeListener sliderChangeListener = new SliderChangeListener();
        this.sliderBrightness.setMinimum(-50);
        this.sliderBrightness.setMaximum(50);
        this.sliderBrightness.setValue(AppPrefs.getProperty(PROPERTY_IMAGES_BRIGHTNESS, 0));
        this.sliderBrightness.setMajorTickSpacing(50);
        this.sliderBrightness.setPaintTicks(true);
        this.sliderBrightness.addChangeListener(sliderChangeListener);
        this.sliderContrast.setMinimum(-50);
        this.sliderContrast.setMaximum(50);
        this.sliderContrast.setValue(AppPrefs.getProperty(PROPERTY_IMAGES_CONTRAST, 0));
        this.sliderContrast.setMajorTickSpacing(50);
        if (this.file != null) {
            object = this.file.getPath();
            this.labelFileInputPath.setText(Lng.getLabel("dialog.images.filename", this.file.getName()));
            this.labelFileInputPath.setToolTipText((String)object);
        } else {
            this.labelFileInputPath.setText("");
        }
        this.sliderContrast.setPaintTicks(true);
        this.sliderContrast.addChangeListener(sliderChangeListener);
        this.comboFilter.setSelectedIndex(AppPrefs.getProperty(PROPERTY_IMAGES_FILTER, 0));
        this.comboPosition.setSelectedIndex(AppPrefs.getProperty(PROPERTY_IMAGES_POSITION, 0));
        object = new ComboChangeListener();
        this.comboFilter.addItemListener((ItemListener)object);
        this.comboPosition.addItemListener((ItemListener)object);
        this.checkCropSelection.addItemListener(new CropSelectionChangeStatus());
        OutputScreenListener outputScreenListener = new OutputScreenListener();
        this.radioBgLCD.addItemListener(outputScreenListener);
        this.radioBgWhite.addItemListener(outputScreenListener);
    }

    public final TIImageFileInfo getFileInfo() {
        return this.fileInfo;
    }

    private int getNextHighWidth(int n) {
        if (n > this.imageScreenWidth) {
            return this.imageScreenWidth;
        }
        if (n % 8 == 0) {
            return n;
        }
        return WidthSpinnerModel.getNextHigh(n);
    }

    private int getOutputImgHeight() {
        return ((Number)this.spinnerHeight.getValue()).intValue();
    }

    private int getOutputImgWidth() {
        return ((Number)this.spinnerWidth.getValue()).intValue();
    }

    private void initFilters(Image image) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.filterPlugins[0] = new InputImageFilterPlugin(image);
        this.filterPlugins[3] = new BrigthnessFilterPlugin();
        this.filterPlugins[4] = new ContrastFilterPlugin();
        this.filterPlugins[2] = new CropFitFilterPlugin();
        this.filterPlugins[5] = new DitherFilterPlugin();
        this.filterPlugins[1] = new SelectionFilterPlugin();
        this.filterPlugins[6] = new ScreenFilterPlugin();
        this.updateFilter(0, 2);
        this.labelInputImageSize.setText(Lng.getLabel("dialog.images.imagesize", new Object[]{image.getWidth(null), image.getHeight(null)}));
        this.radioBgLCD.setSelected(!this.radioBgWhite.isSelected());
    }

    void updateFilter(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilterDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                Image image = n > 0 ? FilterDialog.this.filterPlugins[n - 1].getGeneratedImage() : FilterDialog.this.filterPlugins[0].getGeneratedImage();
                for (int i = n; i < 7; ++i) {
                    image = FilterDialog.this.filterPlugins[i].updateFilter(image, n2);
                }
                FilterDialog.this.panelOutputPicture.setImg(image);
                FilterDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    private void setOutputFile(File file) {
        this.outputFile = file;
    }

    protected final AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    protected final AbstractButton getOkButton() {
        return this.btnSave;
    }

    private void setSpinnerValue(JSpinner jSpinner, Integer n) {
        jSpinner.removeChangeListener(this.spinnerChangeListener);
        jSpinner.getModel().setValue(n);
        jSpinner.addChangeListener(this.spinnerChangeListener);
    }

    private void setSpinnerValue(JSpinner jSpinner, int n) {
        jSpinner.removeChangeListener(this.spinnerChangeListener);
        jSpinner.getModel().setValue(n);
        jSpinner.addChangeListener(this.spinnerChangeListener);
    }

    private void init() throws Exception {
        JPanel jPanel = new JPanel(new BorderLayout(5, 4));
        jPanel.setBorder(BorderFactory.createCompoundBorder(jPanel.getBorder(), BorderFactory.createEmptyBorder(2, 4, 2, 6)));
        JPanel jPanel2 = new JPanel(new EqualsLayout(5));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JLabel jLabel = Swinger.getLabel("dialog.images.outputpicture");
        JLabel jLabel2 = Swinger.getLabel("dialog.images.inputpicture");
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        JLabel jLabel3 = Swinger.getLabel("dialog.images.brightness", "light.gif");
        JLabel jLabel4 = Swinger.getLabel("dialog.images.width");
        JLabel jLabel5 = Swinger.getLabel("dialog.images.filter");
        JLabel jLabel6 = Swinger.getLabel("dialog.images.contrast", "contrast.gif");
        JLabel jLabel7 = Swinger.getLabel("dialog.images.height");
        Container container = this.getContentPane();
        this.panelInputPicture.setBackground(Color.GRAY);
        container.setLayout(new BorderLayout());
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), Lng.getLabel("dialog.images.options"));
        JLabel jLabel8 = Swinger.getLabel("dialog.images.position");
        jLabel8.setLabelFor(this.comboPosition);
        String string = Lng.getLabel("dialog.images.ordered");
        this.comboFilter = new JComboBox<Object>(new Object[]{Lng.getLabel("dialog.images.quantize"), string + " 4x4 #1", string + " 4x4 #2", "Floyd-Steinberg", "Jarvis", "Shiau", "Stucki", "Burke", string + " 2x2", string + " 3x3 #1", string + " 3x3 #2", Lng.getLabel("dialog.images.random")});
        this.comboPosition = new JComboBox<Object>(new Object[]{Swinger.getLabel("dialog.images.crop", "crop.gif"), Swinger.getLabel("dialog.images.fitwidth", "res-width.gif"), Swinger.getLabel("dialog.images.fitheight", "res-height.gif"), Swinger.getLabel("dialog.images.stretch", "res-both.gif")});
        this.comboPosition.setRenderer(new CellRenderer());
        ClickButtonAction clickButtonAction = new ClickButtonAction();
        this.btnSave.addActionListener(clickButtonAction);
        this.btnCancel.addActionListener(clickButtonAction);
        this.btnReset.addActionListener(clickButtonAction);
        jPanel2.setPreferredSize(new Dimension(239, 30));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel2.setFont(jLabel.getFont());
        Dimension dimension = new Dimension(this.imageScreenWidth + 2, this.imageScreenHeight + 2);
        this.panelOutputPicture.setPreferredSize(dimension);
        this.panelOutputPicture.setMaximumSize(dimension);
        this.panelOutputPicture.setMinimumSize(dimension);
        jPanel4.setBorder(BorderFactory.createLineBorder(Color.black));
        jLabel3.setLabelFor(this.sliderBrightness);
        JLabel jLabel9 = Swinger.getLabel(this.formatTI92 ? "dialog.images.maxsizeTi92" : "dialog.images.maxsize");
        jLabel5.setMaximumSize(new Dimension(23, 15));
        jLabel5.setLabelFor(this.comboFilter);
        jLabel6.setLabelFor(this.sliderContrast);
        jPanel5.setBorder(titledBorder);
        this.scrollPaneInput.setPreferredSize(new Dimension(200, 100));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.scrollPaneInput.getViewport().setBackground(Color.LIGHT_GRAY);
        this.labelInfoPosition.setSize(new Dimension(165, 15));
        this.labelInfoPosition.setMaximumSize(new Dimension(165, 15));
        this.labelInfoPosition.setMinimumSize(new Dimension(165, 15));
        Dimension dimension2 = new Dimension(75, 25);
        this.btnCancel.setMinimumSize(dimension2);
        this.btnSave.setMinimumSize(dimension2);
        this.btnReset.setMinimumSize(dimension2);
        jPanel.add((Component)this.checkSaveSettings, "West");
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add(this.btnSave);
        jPanel2.add(this.btnCancel);
        jPanel2.add(this.btnReset);
        container.add((Component)jPanel3, "Center");
        container.add((Component)jPanel, "South");
        jPanel3.add((Component)jPanel4, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        JButtonGroup jButtonGroup = new JButtonGroup();
        jButtonGroup.add(this.radioBgLCD);
        jButtonGroup.add(this.radioBgWhite);
        jPanel6.setBorder(null);
        jPanel6.add(Swinger.getLabel("dialog.images.background"));
        jPanel6.add(this.radioBgWhite);
        jPanel6.add(this.radioBgLCD);
        jPanel4.add((Component)jLabel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(3, 4, 2, 0), 0, 0));
        jPanel4.add((Component)this.labelInputImageSize, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 4, 4, 4), 0, 0));
        jPanel4.add((Component)this.labelFileInputPath, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 4, 4, 4), 0, 0));
        jPanel4.add((Component)this.scrollPaneInput, new GridBagConstraints(0, 2, 2, 1, 1.0, 2.0, 10, 1, new Insets(0, 3, 0, 7), 70, 40));
        jPanel4.add((Component)this.checkCropSelection, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(4, 4, 6, 7), 0, 0));
        jPanel4.add((Component)this.labelInfoPosition, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 6, 0), 0, 0));
        jPanel4.add((Component)jLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 4, 2, 0), 0, 0));
        jPanel4.add((Component)jLabel9, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 4, 2, 0), 0, 0));
        jPanel4.add((Component)this.panelOutputPicture, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 20, 2, 4), 0, 0));
        jPanel4.add((Component)jPanel6, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 2, 4), 0, 0));
        this.scrollPaneInput.setVerticalScrollBarPolicy(22);
        this.scrollPaneInput.setHorizontalScrollBarPolicy(32);
        this.scrollPaneInput.getViewport().add((Component)this.panelInputPicture, null);
        this.panelInputPicture.init();
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        Dimension dimension3 = new Dimension(45, 20);
        this.spinnerWidth.setPreferredSize(dimension3);
        this.spinnerHeight.setPreferredSize(dimension3);
        jPanel7.setBorder(null);
        jPanel8.setBorder(null);
        jPanel7.add((Component)jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 10), 0, 0));
        jPanel7.add((Component)this.spinnerWidth, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 2));
        jPanel7.add((Component)jLabel7, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 3, 10), 0, 0));
        jPanel7.add((Component)this.spinnerHeight, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 5, 2));
        jPanel5.add((Component)jPanel7, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        jPanel5.add((Component)this.comboPosition, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        jPanel5.add((Component)this.comboFilter, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 10, 5, 0), 0, 0));
        Integer n = 999;
        String string2 = Lng.formatLabel(Lng.getLabel("dialog.images.cropinfo"), new Object[]{n, n, n, n});
        Dimension dimension4 = this.labelInfoPosition.getMinimumSize();
        dimension4.width = this.labelInfoPosition.getFontMetrics(this.labelInfoPosition.getFont()).stringWidth(string2);
        this.labelInfoPosition.setPreferredSize(dimension4);
        jPanel8.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel8.add((Component)this.sliderBrightness, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        jPanel8.add((Component)jLabel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 0, 0), 0, 0));
        jPanel8.add((Component)this.sliderContrast, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
        jPanel5.add((Component)jPanel8, new GridBagConstraints(2, 0, 1, 3, 1.0, 0.0, 17, 2, new Insets(0, 5, 10, 0), 0, 0));
        jPanel5.add((Component)jLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 6, 0), 0, 0));
        jPanel5.add((Component)jLabel8, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 10, 6, 0), 0, 0));
        jPanel3.add((Component)jPanel5, "South");
    }

    private static class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setComponentOrientation(jList.getComponentOrientation());
            JLabel jLabel = (JLabel)object;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setIcon(jLabel.getIcon());
            this.setIconTextGap(10);
            this.setText(jLabel.getText());
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    private final class ClickButtonAction
    extends AbstractAction {
        private ClickButtonAction() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(FilterDialog.this.btnSave)) {
                Object object;
                FilterDialog.this.fileInfo = new TIImageFileInfo();
                if (FilterDialog.this.file != null && ((String)(object = Utils.getPureFilename(FilterDialog.this.file))).length() > 0) {
                    FilterDialog.this.fileInfo.setVarName((String)object);
                }
                if (FilterDialog.this.checkSaveSettings.isSelected()) {
                    AppPrefs.storeProperty(FilterDialog.PROPERTY_IMAGES_CROP, FilterDialog.this.checkCropSelection.isSelected());
                    AppPrefs.storeProperty(FilterDialog.PROPERTY_IMAGES_BACKGROUND, FilterDialog.this.radioBgWhite.isSelected());
                    AppPrefs.storeProperty(FilterDialog.PROPERTY_IMAGES_CONTRAST, FilterDialog.this.sliderContrast.getValue());
                    AppPrefs.storeProperty(FilterDialog.PROPERTY_IMAGES_BRIGHTNESS, FilterDialog.this.sliderBrightness.getValue());
                    AppPrefs.storeProperty(FilterDialog.PROPERTY_IMAGES_FILTER, FilterDialog.this.comboFilter.getSelectedIndex());
                    AppPrefs.storeProperty(FilterDialog.PROPERTY_IMAGES_POSITION, FilterDialog.this.comboPosition.getSelectedIndex());
                }
                if ((object = SaveAsFileAction.saveAsImageProcess(FilterDialog.this.fileInfo, FilterDialog.this.panelOutputPicture.getImg())) != null) {
                    FilterDialog.this.setOutputFile((File)object);
                    FilterDialog.this.doClose();
                }
            } else if (actionEvent.getSource().equals(FilterDialog.this.btnCancel)) {
                FilterDialog.this.doClose();
            } else if (actionEvent.getSource().equals(FilterDialog.this.btnReset)) {
                FilterDialog.this.radioBgWhite.setSelected(AppPrefs.getProperty(FilterDialog.PROPERTY_IMAGES_BACKGROUND, true));
                FilterDialog.this.radioBgLCD.setSelected(!FilterDialog.this.radioBgWhite.isSelected());
                FilterDialog.this.checkCropSelection.setSelected(AppPrefs.getProperty(FilterDialog.PROPERTY_IMAGES_CROP, true));
                FilterDialog.this.sliderContrast.setValue(AppPrefs.getProperty(FilterDialog.PROPERTY_IMAGES_CONTRAST, 0));
                FilterDialog.this.sliderBrightness.setValue(AppPrefs.getProperty(FilterDialog.PROPERTY_IMAGES_BRIGHTNESS, 0));
                FilterDialog.this.comboFilter.setSelectedIndex(AppPrefs.getProperty(FilterDialog.PROPERTY_IMAGES_FILTER, 0));
                FilterDialog.this.comboPosition.setSelectedIndex(AppPrefs.getProperty(FilterDialog.PROPERTY_IMAGES_POSITION, 0));
            }
        }
    }

    private final class ScreenFilterPlugin
    extends FilterPlugin {
        private final ImageFilter alphaFilter = new AlphaFilter();

        private ScreenFilterPlugin() {
        }

        public final Image updateFilter(Image image, int n) {
            this.freeActualImage();
            this.generatedImage = FilterDialog.this.radioBgLCD.isSelected() ? FilterDialog.this.createImage(new FilteredImageSource(image.getSource(), this.alphaFilter)) : image;
            return this.generatedImage;
        }
    }

    private final class BrigthnessFilterPlugin
    extends FilterPlugin {
        private final BrightnessFilter brightnessFilter = new BrightnessFilter();

        private BrigthnessFilterPlugin() {
        }

        public final Image updateFilter(Image image, int n) {
            int n2 = FilterDialog.this.sliderBrightness.getValue();
            this.freeActualImage();
            if (n2 != 0) {
                this.brightnessFilter.setBrightness(n2 * 2);
                this.generatedImage = FilterDialog.this.createImage(new FilteredImageSource(image.getSource(), this.brightnessFilter));
            } else {
                this.generatedImage = image;
            }
            return this.generatedImage;
        }
    }

    private final class ContrastFilterPlugin
    extends FilterPlugin {
        private final ContrastFilter contrastFilter = new ContrastFilter();

        private ContrastFilterPlugin() {
        }

        public final Image updateFilter(Image image, int n) {
            this.freeActualImage();
            int n2 = FilterDialog.this.sliderContrast.getValue();
            if (n2 != 0) {
                this.contrastFilter.setGain(n2 * 2);
                this.generatedImage = FilterDialog.this.createImage(new FilteredImageSource(image.getSource(), this.contrastFilter));
            } else {
                this.generatedImage = image;
            }
            return this.generatedImage;
        }
    }

    private final class CropFitFilterPlugin
    extends FilterPlugin {
        private CropFitFilterPlugin() {
        }

        public final Image updateFilter(Image image, int n) {
            ImageFilter imageFilter;
            int n2 = FilterDialog.this.getOutputImgWidth();
            int n3 = FilterDialog.this.getOutputImgHeight();
            int n4 = FilterDialog.this.comboPosition.getSelectedIndex();
            this.freeActualImage();
            switch (n4) {
                case 0: {
                    if (n != 0 && n != 1) {
                        n2 = FilterDialog.this.getNextHighWidth(image.getWidth(null));
                        FilterDialog.this.setSpinnerValue(FilterDialog.this.spinnerWidth, n2);
                        n3 = Math.min(image.getHeight(null), FilterDialog.this.imageScreenHeight);
                        FilterDialog.this.setSpinnerValue(FilterDialog.this.spinnerHeight, n3);
                    }
                    imageFilter = new CropImageFilter(0, 0, n2, n3);
                    break;
                }
                case 1: {
                    imageFilter = new AreaAveragingScaleFilter(n2, -1);
                    break;
                }
                case 2: {
                    imageFilter = new AreaAveragingScaleFilter(-1, n3);
                    break;
                }
                case 3: {
                    imageFilter = new AreaAveragingScaleFilter(n2, n3);
                    break;
                }
                default: {
                    this.generatedImage = image;
                    return this.generatedImage;
                }
            }
            this.generatedImage = FilterDialog.this.createImage(new FilteredImageSource(image.getSource(), imageFilter));
            if (n4 == 2) {
                int n5;
                if ((n == 3 || n == 5 || n == 4) && (n5 = FilterDialog.this.getNextHighWidth(this.generatedImage.getWidth(null))) != n2) {
                    FilterDialog.this.setSpinnerValue(FilterDialog.this.spinnerWidth, n5);
                    n2 = n5;
                }
                this.generatedImage = this.makeCropImage(n2, n3);
            } else if (n4 == 1) {
                int n6;
                if ((n == 3 || n == 5 || n == 4) && (n6 = Math.min(this.generatedImage.getHeight(null), FilterDialog.this.imageScreenHeight)) != n3) {
                    FilterDialog.this.setSpinnerValue(FilterDialog.this.spinnerHeight, n6);
                    n3 = n6;
                }
                this.generatedImage = this.makeCropImage(n2, n3);
            }
            return this.generatedImage;
        }

        private Image makeCropImage(int n, int n2) {
            return FilterDialog.this.createImage(new FilteredImageSource(this.generatedImage.getSource(), new CropImageFilter(0, 0, n, n2)));
        }
    }

    private final class SelectionFilterPlugin
    extends FilterPlugin {
        private SelectionFilterPlugin() {
        }

        public final Image updateFilter(Image image, int n) {
            this.freeActualImage();
            if (FilterDialog.this.checkCropSelection.isSelected() && FilterDialog.this.panelInputPicture.isSelection()) {
                Rectangle rectangle = FilterDialog.this.panelInputPicture.getSelectionRectangle();
                this.generatedImage = FilterDialog.this.createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height)));
            } else {
                this.generatedImage = image;
            }
            return this.generatedImage;
        }
    }

    private final class DitherFilterPlugin
    extends FilterPlugin {
        private final DitherRaster[] raster = new DitherRaster[]{new QuantizeRaster(), new OrderedDither(), new OrderedFilter4x4(), new ErrorDiffusion(), new JarvisErrorDiffusion(), new Shiau2ErrorDiffusion(), new StuckiErrorDiffusion(), new BurkeFilter(), new OrderedFilter2x2(), new OrderedFilter3x3_1(), new OrderedFilter3x3_2(), new RandomRaster()};

        private DitherFilterPlugin() {
        }

        public final Image updateFilter(Image image, int n) {
            this.freeActualImage();
            this.generatedImage = FilterDialog.this.createImage(new FilteredImageSource(image.getSource(), this.raster[FilterDialog.this.comboFilter.getSelectedIndex()]));
            return this.generatedImage;
        }
    }

    private final class InputImageFilterPlugin
    extends FilterPlugin {
        public InputImageFilterPlugin(Image image) {
            this.generatedImage = image;
        }

        public final Image updateFilter(Image image, int n) {
            this.freeActualImage();
            this.generatedImage = image;
            FilterDialog.this.panelInputPicture.setImg(this.generatedImage);
            return image;
        }
    }

    private final class ComboChangeListener
    implements ItemListener {
        private ComboChangeListener() {
        }

        public final void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource().equals(FilterDialog.this.comboPosition)) {
                FilterDialog.this.updateFilter(2, 5);
            } else {
                FilterDialog.this.updateFilter(5, 6);
            }
        }
    }

    private final class SliderChangeListener
    implements ChangeListener {
        private SliderChangeListener() {
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource().equals(FilterDialog.this.sliderContrast)) {
                FilterDialog.this.updateFilter(4, 8);
            } else {
                FilterDialog.this.updateFilter(3, 7);
            }
        }
    }

    private final class OutputScreenListener
    implements ItemListener {
        private OutputScreenListener() {
        }

        public final void itemStateChanged(ItemEvent itemEvent) {
            FilterDialog.this.panelOutputPicture.setLCDBackground(FilterDialog.this.radioBgLCD.isSelected(), FilterDialog.this.formatTI92);
            FilterDialog.this.updateFilter(6, 9);
        }
    }

    private final class CropSelectionChangeStatus
    implements ItemListener {
        private CropSelectionChangeStatus() {
        }

        public final void itemStateChanged(ItemEvent itemEvent) {
            FilterDialog.this.updateFilter(1, 4);
        }
    }

    private final class SpinnerChangeListener
    implements ChangeListener {
        private SpinnerChangeListener() {
        }

        public final void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource().equals(FilterDialog.this.spinnerWidth)) {
                Number number = (Number)FilterDialog.this.spinnerWidth.getValue();
                int n = number.intValue();
                if (n % 8 != 0) {
                    FilterDialog.this.setSpinnerValue(FilterDialog.this.spinnerWidth, WidthSpinnerModel.getNextHigh(n, FilterDialog.this.imageScreenWidth));
                }
                FilterDialog.this.updateFilter(2, 0);
            } else {
                FilterDialog.this.updateFilter(2, 1);
            }
        }
    }
}

