/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JRadioButton;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.settings.IOptionGroup;
import net.wordrider.dialogs.settings.IOptionable;
import net.wordrider.dialogs.settings.OptionsGroupManager;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RadioOption
implements IOptionable<JRadioButton>,
ItemListener {
    private final int itemValue;
    private boolean applyedValue;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private String propertyName = null;
    private final JRadioButton radio;

    public RadioOption(OptionsGroupManager optionsGroupManager, String string, String string2, int n, int n2, IOptionGroup iOptionGroup) {
        this.propertyName = string2;
        this.radio = Swinger.getRadio(string);
        this.itemValue = n;
        this.group = iOptionGroup;
        this.applyedValue = n == AppPrefs.getProperty(string2, n2);
        this.radio.setSelected(this.applyedValue);
        this.optionsGroupManager = optionsGroupManager;
        this.radio.addItemListener(this);
        this.updateValue();
    }

    void updateValue() {
        this.wasChanged = this.applyedValue != this.radio.isSelected();
        this.optionsGroupManager.makeChange(this);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateValue();
    }

    @Override
    public final void setDefault() {
        this.radio.setSelected(this.applyedValue);
    }

    @Override
    public final void restorePrevious() {
        if (this.applyedValue != this.radio.isSelected()) {
            this.radio.setSelected(this.applyedValue);
        }
    }

    @Override
    public final boolean wasChanged() {
        return this.wasChanged;
    }

    @Override
    public void applyChange() {
        this.wasChanged = false;
        if (this.radio.isSelected()) {
            AppPrefs.storeProperty(this.propertyName, this.itemValue);
        }
    }

    @Override
    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JRadioButton getComponent() {
        return this.radio;
    }
}

