/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import net.wordrider.files.ti68kformat.TIFileWriter;

public final class TITextFileWriter
extends TIFileWriter {
    private static final String fileHeader = "**TI92P*";
    private String textContent = "";
    private static final HashMap<Character, Character> UNICODE2TI = new HashMap(134);
    private int sum = 0;

    public final void setTextContent(String string) {
        this.textContent = string == null ? "" : string;
    }

    protected final char getCheckSum() {
        return (char)(this.sum + 224 + 1);
    }

    protected final byte getDataType() {
        return 11;
    }

    protected final String getFileHeaderType() {
        return fileHeader;
    }

    protected final int getContentFileSize() {
        return 18 + this.textContent.length();
    }

    protected final void writeContent(DataOutputStream dataOutputStream) throws IOException {
        char[] cArray = this.textContent.toCharArray();
        int n = cArray.length;
        int n2 = n + 4;
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(1);
        this.sum = (n2 & 0xFF) + (n2 >> 8 & 0xFF);
        for (int i = 0; i < n; ++i) {
            int n3 = cArray[i];
            if (n3 >= 128) {
                Character c = UNICODE2TI.get(new Character((char)n3));
                if (c != null) {
                    n3 = c.charValue();
                }
            } else if (n3 == 10) {
                n3 = 13;
            }
            this.sum += n3;
            dataOutputStream.writeByte(n3);
        }
        dataOutputStream.writeShort(224);
    }

    static {
        UNICODE2TI.put(Character.valueOf('\u00d0'), Character.valueOf('\u0012'));
        UNICODE2TI.put(Character.valueOf('\u00bb'), Character.valueOf('\u0016'));
        UNICODE2TI.put(Character.valueOf('\u00bc'), Character.valueOf('\u001c'));
        UNICODE2TI.put(Character.valueOf('\u00bd'), Character.valueOf('\u001d'));
        UNICODE2TI.put(Character.valueOf('\u00be'), Character.valueOf('\u001e'));
        UNICODE2TI.put(Character.valueOf('\u00bf'), Character.valueOf('\u001f'));
        UNICODE2TI.put(Character.valueOf('\u20ac'), Character.valueOf('\u0080'));
        UNICODE2TI.put(Character.valueOf('\u0081'), Character.valueOf('\u0081'));
        UNICODE2TI.put(Character.valueOf('\u201a'), Character.valueOf('\u0082'));
        UNICODE2TI.put(Character.valueOf('\u0192'), Character.valueOf('\u0083'));
        UNICODE2TI.put(Character.valueOf('\u201e'), Character.valueOf('\u0084'));
        UNICODE2TI.put(Character.valueOf('\u2026'), Character.valueOf('\u0085'));
        UNICODE2TI.put(Character.valueOf('\u2020'), Character.valueOf('\u0086'));
        UNICODE2TI.put(Character.valueOf('\u2021'), Character.valueOf('\u0087'));
        UNICODE2TI.put(Character.valueOf('\u02c6'), Character.valueOf('\u0088'));
        UNICODE2TI.put(Character.valueOf('\u2030'), Character.valueOf('\u0089'));
        UNICODE2TI.put(Character.valueOf('\u0160'), Character.valueOf('\u008a'));
        UNICODE2TI.put(Character.valueOf('\u2039'), Character.valueOf('\u008b'));
        UNICODE2TI.put(Character.valueOf('\u0152'), Character.valueOf('\u008c'));
        UNICODE2TI.put(Character.valueOf('\u008d'), Character.valueOf('\u008d'));
        UNICODE2TI.put(Character.valueOf('\u017d'), Character.valueOf('\u008e'));
        UNICODE2TI.put(Character.valueOf('\u008f'), Character.valueOf('\u008f'));
        UNICODE2TI.put(Character.valueOf('\u0090'), Character.valueOf('\u0090'));
        UNICODE2TI.put(Character.valueOf('\u2018'), Character.valueOf('\u0091'));
        UNICODE2TI.put(Character.valueOf('\u2019'), Character.valueOf('\u0092'));
        UNICODE2TI.put(Character.valueOf('\u201c'), Character.valueOf('\u0093'));
        UNICODE2TI.put(Character.valueOf('\u0081'), Character.valueOf('\u0081'));
        UNICODE2TI.put(Character.valueOf('\u201d'), Character.valueOf('\u0094'));
        UNICODE2TI.put(Character.valueOf('\u2013'), Character.valueOf('\u0095'));
        UNICODE2TI.put(Character.valueOf('\u2014'), Character.valueOf('\u0096'));
        UNICODE2TI.put(Character.valueOf('\u00c6'), Character.valueOf('\u0097'));
        UNICODE2TI.put(Character.valueOf('\u02dc'), Character.valueOf('\u0098'));
        UNICODE2TI.put(Character.valueOf('\u2122'), Character.valueOf('\u0099'));
        UNICODE2TI.put(Character.valueOf('\u0161'), Character.valueOf('\u009a'));
        UNICODE2TI.put(Character.valueOf('\u203a'), Character.valueOf('\u009b'));
        UNICODE2TI.put(Character.valueOf('\u0153'), Character.valueOf('\u009c'));
        UNICODE2TI.put(Character.valueOf('\u009d'), Character.valueOf('\u009d'));
        UNICODE2TI.put(Character.valueOf('\u017e'), Character.valueOf('\u009e'));
        UNICODE2TI.put(Character.valueOf('\u0178'), Character.valueOf('\u009f'));
        UNICODE2TI.put(Character.valueOf('\u00a1'), Character.valueOf('\u00a0'));
        UNICODE2TI.put(Character.valueOf('\u00a2'), Character.valueOf('\u00a1'));
        UNICODE2TI.put(Character.valueOf('\u00a3'), Character.valueOf('\u00a2'));
        UNICODE2TI.put(Character.valueOf('\u00a4'), Character.valueOf('\u00a3'));
        UNICODE2TI.put(Character.valueOf('\u00a5'), Character.valueOf('\u00a4'));
        UNICODE2TI.put(Character.valueOf('\u00a6'), Character.valueOf('\u00a5'));
        UNICODE2TI.put(Character.valueOf('|'), Character.valueOf('\u00a6'));
        UNICODE2TI.put(Character.valueOf('\u00a7'), Character.valueOf('\u00a7'));
        UNICODE2TI.put(Character.valueOf('\u00a7'), Character.valueOf('\u00a8'));
        UNICODE2TI.put(Character.valueOf('\u00a8'), Character.valueOf('\u00a9'));
        UNICODE2TI.put(Character.valueOf('\u00aa'), Character.valueOf('\u00aa'));
        UNICODE2TI.put(Character.valueOf('\u00d7'), Character.valueOf('\u00ab'));
        UNICODE2TI.put(Character.valueOf('\u00a9'), Character.valueOf('\u00ac'));
        UNICODE2TI.put(Character.valueOf('\u00aa'), Character.valueOf('\u00ad'));
        UNICODE2TI.put(Character.valueOf('\u00a8'), Character.valueOf('\u00ae'));
        UNICODE2TI.put(Character.valueOf('\u00ab'), Character.valueOf('\u00af'));
        UNICODE2TI.put(Character.valueOf('\u00ac'), Character.valueOf('\u00b0'));
        UNICODE2TI.put(Character.valueOf('\u00ad'), Character.valueOf('\u00b1'));
        UNICODE2TI.put(Character.valueOf('\u00ae'), Character.valueOf('\u00b2'));
        UNICODE2TI.put(Character.valueOf('\u00af'), Character.valueOf('\u00b3'));
        UNICODE2TI.put(Character.valueOf('\u00b0'), Character.valueOf('\u00b4'));
        UNICODE2TI.put(Character.valueOf('\u00b1'), Character.valueOf('\u00b5'));
        UNICODE2TI.put(Character.valueOf('\u00b6'), Character.valueOf('\u00b6'));
        UNICODE2TI.put(Character.valueOf('\u00b2'), Character.valueOf('\u00b7'));
        UNICODE2TI.put(Character.valueOf('\u00b3'), Character.valueOf('\u00b8'));
        UNICODE2TI.put(Character.valueOf('\u00b4'), Character.valueOf('\u00b9'));
        UNICODE2TI.put(Character.valueOf('\u00b5'), Character.valueOf('\u00ba'));
        UNICODE2TI.put(Character.valueOf('\u00de'), Character.valueOf('\u00bb'));
        UNICODE2TI.put(Character.valueOf('\u00b6'), Character.valueOf('\u00bc'));
        UNICODE2TI.put(Character.valueOf('\u00b7'), Character.valueOf('\u00bd'));
        UNICODE2TI.put(Character.valueOf('\u00b8'), Character.valueOf('\u00be'));
        UNICODE2TI.put(Character.valueOf('\u00b9'), Character.valueOf('\u00bf'));
        UNICODE2TI.put(Character.valueOf('\u00c0'), Character.valueOf('\u00c0'));
        UNICODE2TI.put(Character.valueOf('\u00c1'), Character.valueOf('\u00c1'));
        UNICODE2TI.put(Character.valueOf('\u00c2'), Character.valueOf('\u00c2'));
        UNICODE2TI.put(Character.valueOf('\u00c3'), Character.valueOf('\u00c3'));
        UNICODE2TI.put(Character.valueOf('\u00c4'), Character.valueOf('\u00c4'));
        UNICODE2TI.put(Character.valueOf('\u00c5'), Character.valueOf('\u00c5'));
        UNICODE2TI.put(Character.valueOf('\u00e6'), Character.valueOf('\u00c6'));
        UNICODE2TI.put(Character.valueOf('\u00c7'), Character.valueOf('\u00c7'));
        UNICODE2TI.put(Character.valueOf('\u00c8'), Character.valueOf('\u00c8'));
        UNICODE2TI.put(Character.valueOf('\u00c9'), Character.valueOf('\u00c9'));
        UNICODE2TI.put(Character.valueOf('\u00ca'), Character.valueOf('\u00ca'));
        UNICODE2TI.put(Character.valueOf('\u00cb'), Character.valueOf('\u00cb'));
        UNICODE2TI.put(Character.valueOf('\u00cd'), Character.valueOf('\u00cc'));
        UNICODE2TI.put(Character.valueOf('\u00cc'), Character.valueOf('\u00cd'));
        UNICODE2TI.put(Character.valueOf('\u00cd'), Character.valueOf('\u00ce'));
        UNICODE2TI.put(Character.valueOf('\u00cf'), Character.valueOf('\u00cf'));
        UNICODE2TI.put(Character.valueOf('\u00d0'), Character.valueOf('\u0012'));
        UNICODE2TI.put(Character.valueOf('\u00d1'), Character.valueOf('\u00d1'));
        UNICODE2TI.put(Character.valueOf('\u00d2'), Character.valueOf('\u00d2'));
        UNICODE2TI.put(Character.valueOf('\u00d3'), Character.valueOf('\u00d3'));
        UNICODE2TI.put(Character.valueOf('\u00d4'), Character.valueOf('\u00d4'));
        UNICODE2TI.put(Character.valueOf('\u00d5'), Character.valueOf('\u00d5'));
        UNICODE2TI.put(Character.valueOf('\u00d6'), Character.valueOf('\u00d6'));
        UNICODE2TI.put(Character.valueOf('x'), Character.valueOf('\u00d7'));
        UNICODE2TI.put(Character.valueOf('\u00d8'), Character.valueOf('\u00d8'));
        UNICODE2TI.put(Character.valueOf('\u00d9'), Character.valueOf('\u00d9'));
        UNICODE2TI.put(Character.valueOf('\u00da'), Character.valueOf('\u00da'));
        UNICODE2TI.put(Character.valueOf('\u00db'), Character.valueOf('\u00db'));
        UNICODE2TI.put(Character.valueOf('\u00dc'), Character.valueOf('\u00dc'));
        UNICODE2TI.put(Character.valueOf('\u00dd'), Character.valueOf('\u00dd'));
        UNICODE2TI.put(Character.valueOf('\u00fe'), Character.valueOf('\u00de'));
        UNICODE2TI.put(Character.valueOf('\u00df'), Character.valueOf('\u00df'));
        UNICODE2TI.put(Character.valueOf('\u00e0'), Character.valueOf('\u00e0'));
        UNICODE2TI.put(Character.valueOf('\u00e1'), Character.valueOf('\u00e1'));
        UNICODE2TI.put(Character.valueOf('\u00e2'), Character.valueOf('\u00e2'));
        UNICODE2TI.put(Character.valueOf('\u00e3'), Character.valueOf('\u00e3'));
        UNICODE2TI.put(Character.valueOf('\u00e4'), Character.valueOf('\u00e4'));
        UNICODE2TI.put(Character.valueOf('\u00e5'), Character.valueOf('\u00e5'));
        UNICODE2TI.put(Character.valueOf('\u00e6'), Character.valueOf('\u00e6'));
        UNICODE2TI.put(Character.valueOf('\u00e7'), Character.valueOf('\u00e7'));
        UNICODE2TI.put(Character.valueOf('\u00e8'), Character.valueOf('\u00e8'));
        UNICODE2TI.put(Character.valueOf('\u00e9'), Character.valueOf('\u00e9'));
        UNICODE2TI.put(Character.valueOf('\u00ea'), Character.valueOf('\u00ea'));
        UNICODE2TI.put(Character.valueOf('\u00eb'), Character.valueOf('\u00eb'));
        UNICODE2TI.put(Character.valueOf('\u00ec'), Character.valueOf('\u00ec'));
        UNICODE2TI.put(Character.valueOf('\u00ed'), Character.valueOf('\u00ed'));
        UNICODE2TI.put(Character.valueOf('\u00ee'), Character.valueOf('\u00ee'));
        UNICODE2TI.put(Character.valueOf('\u00ef'), Character.valueOf('\u00ef'));
        UNICODE2TI.put(Character.valueOf('\u00f0'), Character.valueOf('\u00f0'));
        UNICODE2TI.put(Character.valueOf('\u00f1'), Character.valueOf('\u00f1'));
        UNICODE2TI.put(Character.valueOf('\u00f2'), Character.valueOf('\u00f2'));
        UNICODE2TI.put(Character.valueOf('\u00f3'), Character.valueOf('\u00f3'));
        UNICODE2TI.put(Character.valueOf('\u00f4'), Character.valueOf('\u00f4'));
        UNICODE2TI.put(Character.valueOf('\u00f5'), Character.valueOf('\u00f5'));
        UNICODE2TI.put(Character.valueOf('\u00f6'), Character.valueOf('\u00f6'));
        UNICODE2TI.put(Character.valueOf('\u00f7'), Character.valueOf('\u00f7'));
        UNICODE2TI.put(Character.valueOf('\u00f8'), Character.valueOf('\u00f8'));
        UNICODE2TI.put(Character.valueOf('\u00f9'), Character.valueOf('\u00f9'));
        UNICODE2TI.put(Character.valueOf('\u00fa'), Character.valueOf('\u00fa'));
        UNICODE2TI.put(Character.valueOf('\u00fb'), Character.valueOf('\u00fb'));
        UNICODE2TI.put(Character.valueOf('\u00fc'), Character.valueOf('\u00fc'));
        UNICODE2TI.put(Character.valueOf('\u00fd'), Character.valueOf('\u00fd'));
        UNICODE2TI.put(Character.valueOf('\u00fe'), Character.valueOf('\u00fe'));
        UNICODE2TI.put(Character.valueOf('\u00ff'), Character.valueOf('\u00ff'));
    }
}

