/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

public class PgsScrollBarButton
extends MetalScrollButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;

    public PgsScrollBarButton(int n, int n2, boolean bl) {
        super(n, n2, bl);
        shadowColor = UIManager.getColor("ScrollBar.darkShadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.isFreeStanding = bl;
        this.putClientProperty("rolloverBackground", UIManager.getColor("Button.rolloverBackground"));
        this.putClientProperty("pgs.isFlat", UIManager.get("Button.isFlat"));
        this.putClientProperty("gradientStart", UIManager.get("Button.gradientStart"));
        this.putClientProperty("gradientEnd", UIManager.get("Button.gradientEnd"));
        this.putClientProperty("rollover.gradientStart", UIManager.get("Button.rolloverGradientStart"));
        this.putClientProperty("rollover.gradientEnd", UIManager.get("Button.rolloverGradientEnd"));
    }

    public void setFreeStanding(boolean bl) {
        super.setFreeStanding(bl);
        this.isFreeStanding = bl;
    }

    public void paint(Graphics graphics) {
        boolean bl = PgsUtils.isLeftToRight(this);
        boolean bl2 = this.getParent().isEnabled();
        boolean bl3 = this.getModel().isPressed();
        ColorUIResource colorUIResource = bl2 ? PgsLookAndFeel.getControlInfo() : PgsLookAndFeel.getControlDisabled();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n2 + 1 >> 2;
        if (bl3) {
            PgsUtils.drawGradient(graphics, -1, 0, this.getWidth(), this.getHeight(), UIManager.getColor("Button.select"), UIManager.getColor("Button.select").brighter());
        } else {
            PgsUtils.drawGradient(graphics, this);
        }
        if (this.getDirection() == 1) {
            this.paintNorth(graphics, bl, bl2, colorUIResource, bl3, n, n2, n, n2, n3);
        } else if (this.getDirection() == 5) {
            this.paintSouth(graphics, bl, bl2, colorUIResource, bl3, n, n2, n, n2, n3);
        } else if (this.getDirection() == 3) {
            this.paintEast(graphics, bl2, colorUIResource, bl3, n, n2, n, n2, n3);
        } else if (this.getDirection() == 7) {
            this.paintWest(graphics, bl2, colorUIResource, bl3, n, n2, n, n2, n3);
        }
        if (this.getModel().isEnabled() && this.getModel().isRollover() && !UIManager.getBoolean("Button.rolloverVistaStyle")) {
            PgsUtils.drawButtonBorder(graphics, 1, 1, n - 3, n2 - 3, PgsUtils.rolloverBorderStroke, PgsLookAndFeel.getGlow());
        }
        graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n - 1, n2 - 1);
    }

    private void paintWest(Graphics graphics, boolean bl, Color color, boolean bl2, int n, int n2, int n3, int n4, int n5) {
        if (!this.isFreeStanding) {
            n2 += 2;
            ++n;
            graphics.translate(-1, 0);
        }
        graphics.setColor(color);
        int n6 = (n3 + 1 - n5) / 2;
        int n7 = n4 / 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n6 + i, n7 - i, n6 + i, n7 + i);
        }
        if (bl) {
            graphics.setColor(highlightColor);
            if (!bl2) {
                graphics.drawLine(1, 1, n - 1, 1);
                graphics.drawLine(1, 1, 1, n2 - 3);
            }
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(shadowColor);
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(2, n2 - 2, n - 1, n2 - 2);
        } else {
            PgsUtils.drawDisabledBorder(graphics, 0, 0, n + 1, n2);
        }
        if (!this.isFreeStanding) {
            n2 -= 2;
            --n;
            graphics.translate(1, 0);
        }
    }

    private void paintEast(Graphics graphics, boolean bl, Color color, boolean bl2, int n, int n2, int n3, int n4, int n5) {
        if (!this.isFreeStanding) {
            n2 += 2;
            ++n;
        }
        graphics.setColor(color);
        int n6 = (n3 + 1 - n5) / 2 + n5 - 1;
        int n7 = n4 / 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n6 - i, n7 - i, n6 - i, n7 + i);
        }
        if (bl) {
            graphics.setColor(highlightColor);
            if (!bl2) {
                graphics.drawLine(0, 1, n - 3, 1);
                graphics.drawLine(0, 1, 0, n2 - 3);
            }
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.setColor(shadowColor);
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
            graphics.drawLine(0, n2 - 2, n - 2, n2 - 2);
        } else {
            PgsUtils.drawDisabledBorder(graphics, -1, 0, n + 1, n2);
        }
        if (!this.isFreeStanding) {
            n2 -= 2;
            --n;
        }
    }

    private void paintSouth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5) {
        if (!this.isFreeStanding) {
            ++n2;
            if (!bl) {
                ++n;
                graphics.translate(-1, 0);
            } else {
                n += 2;
            }
        }
        graphics.setColor(color);
        int n6 = (n4 + 1 - n5) / 2 + n5 - 1;
        int n7 = n3 / 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n7 - i, n6 - i, n7 + i, n6 - i);
        }
        if (bl2) {
            graphics.setColor(highlightColor);
            if (!bl3) {
                graphics.drawLine(1, 0, n - 3, 0);
                graphics.drawLine(1, 0, 1, n2 - 3);
            }
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.setColor(shadowColor);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(n - 2, 0, n - 2, n2 - 2);
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
        } else {
            PgsUtils.drawDisabledBorder(graphics, 0, -1, n, n2 + 1);
        }
        if (!this.isFreeStanding) {
            --n2;
            if (!bl) {
                --n;
                graphics.translate(1, 0);
            } else {
                n -= 2;
            }
        }
    }

    private void paintNorth(Graphics graphics, boolean bl, boolean bl2, Color color, boolean bl3, int n, int n2, int n3, int n4, int n5) {
        if (!this.isFreeStanding) {
            ++n2;
            graphics.translate(0, -1);
            if (!bl) {
                ++n;
                graphics.translate(-1, 0);
            } else {
                n += 2;
            }
        }
        graphics.setColor(color);
        int n6 = (n4 + 1 - n5) / 2;
        int n7 = n3 / 2;
        for (int i = 0; i < n5; ++i) {
            graphics.drawLine(n7 - i, n6 + i, n7 + i, n6 + i);
        }
        if (bl2) {
            graphics.setColor(highlightColor);
            if (!bl3) {
                graphics.drawLine(1, 1, n - 3, 1);
                graphics.drawLine(1, 1, 1, n2 - 1);
            }
            graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
            graphics.setColor(shadowColor);
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(n - 2, 2, n - 2, n2 - 1);
        } else {
            PgsUtils.drawDisabledBorder(graphics, 0, 0, n, n2 + 1);
        }
        if (!this.isFreeStanding) {
            --n2;
            graphics.translate(0, 1);
            if (!bl) {
                --n;
                graphics.translate(1, 0);
            } else {
                n -= 2;
            }
        }
    }

    private class RolloverHandler
    extends MouseAdapter {
        private RolloverHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                buttonModel.setRollover(true);
            }
            if (buttonModel.isPressed()) {
                buttonModel.setArmed(true);
            }
            abstractButton.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled()) {
                buttonModel.setRollover(false);
            }
            if (buttonModel.isPressed()) {
                buttonModel.setArmed(false);
            }
            abstractButton.repaint();
        }
    }
}

