/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BaseInternalFrameUI
extends BasicInternalFrameUI {
    private static final PropertyChangeListener myPropertyChangeListener = new MyPropertyChangeHandler();

    public BaseInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty("JInternalFrame.isPalette");
        if (object != null) {
            this.setPalette((Boolean)object);
        }
        this.stripContentBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(myPropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(myPropertyChangeListener);
        super.uninstallListeners();
    }

    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    public void stripContentBorder() {
        Container container = this.frame.getContentPane();
        if (container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new BaseInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public void setPalette(boolean bl) {
        if (bl) {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.paletteBorder"));
        } else {
            this.frame.setBorder(UIManager.getBorder("InternalFrame.border"));
        }
        if (this.titlePane instanceof BaseInternalFrameTitlePane) {
            ((BaseInternalFrameTitlePane)this.titlePane).setPalette(bl);
        }
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    private static class MyPropertyChangeHandler
    implements PropertyChangeListener {
        private MyPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            BaseInternalFrameUI baseInternalFrameUI = (BaseInternalFrameUI)jInternalFrame.getUI();
            if (!(baseInternalFrameUI instanceof BaseInternalFrameUI)) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("JInternalFrame.frameType")) {
                if (propertyChangeEvent.getNewValue() instanceof String) {
                    if ("palette".equals(propertyChangeEvent.getNewValue())) {
                        LookAndFeel.installBorder(baseInternalFrameUI.frame, "InternalFrame.paletteBorder");
                        baseInternalFrameUI.setPalette(true);
                    } else {
                        LookAndFeel.installBorder(baseInternalFrameUI.frame, "InternalFrame.border");
                        baseInternalFrameUI.setPalette(false);
                    }
                }
            } else if (string.equals("JInternalFrame.isPalette")) {
                if (propertyChangeEvent.getNewValue() != null) {
                    baseInternalFrameUI.setPalette((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    baseInternalFrameUI.setPalette(false);
                }
            } else if (string.equals("contentPane")) {
                baseInternalFrameUI.stripContentBorder();
            }
        }
    }
}

