/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.icons.ImageHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.plaf.basic.BasicArrowButton;

public class BaseScrollButton
extends BasicArrowButton {
    protected static Icon UP_ARROW = ImageHelper.loadImage("UpArrow.gif");
    protected static Icon DOWN_ARROW = ImageHelper.loadImage("DownArrow.gif");
    protected static Icon LEFT_ARROW = ImageHelper.loadImage("LeftArrow.gif");
    protected static Icon RIGHT_ARROW = ImageHelper.loadImage("RightArrow.gif");
    protected int buttonWidth = 24;

    public BaseScrollButton(int n, int n2) {
        super(n);
        this.buttonWidth = n2;
    }

    public void paint(Graphics graphics) {
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.getModel().isRollover();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color[] colorArray = null;
        colorArray = bl ? AbstractLookAndFeel.getTheme().getPressedColors() : (bl2 ? AbstractLookAndFeel.getTheme().getRolloverColors() : (!JTattooUtilities.isActive(this) ? AbstractLookAndFeel.getTheme().getInActiveColors() : AbstractLookAndFeel.getTheme().getButtonColors()));
        Color color = ColorHelper.brighter(colorArray[0], 20.0);
        Color color2 = ColorHelper.darker(colorArray[colorArray.length - 1], 20.0);
        if (this.getDirection() == 1 || this.getDirection() == 5) {
            JTattooUtilities.fillVerGradient(graphics, colorArray, 0, 0, n, n2);
        } else {
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
        }
        if (this.getDirection() == 1) {
            int n3 = n / 2 - UP_ARROW.getIconWidth() / 2;
            int n4 = n2 / 2 - UP_ARROW.getIconHeight() / 2 - 1;
            UP_ARROW.paintIcon(this, graphics, n3, n4);
        } else if (this.getDirection() == 5) {
            int n5 = n / 2 - DOWN_ARROW.getIconWidth() / 2;
            int n6 = n2 / 2 - DOWN_ARROW.getIconHeight() / 2;
            DOWN_ARROW.paintIcon(this, graphics, n5, n6);
        } else if (this.getDirection() == 7) {
            int n7 = n / 2 - LEFT_ARROW.getIconWidth() / 2 - 1;
            int n8 = n2 / 2 - LEFT_ARROW.getIconHeight() / 2;
            LEFT_ARROW.paintIcon(this, graphics, n7, n8);
        } else {
            int n9 = n / 2 - RIGHT_ARROW.getIconWidth() / 2;
            int n10 = n2 / 2 - RIGHT_ARROW.getIconHeight() / 2;
            RIGHT_ARROW.paintIcon(this, graphics, n9, n10);
        }
        JTattooUtilities.draw3DBorder(graphics, color2, ColorHelper.darker(color2, 10.0), 0, 0, n, n2);
        graphics.setColor(color);
        graphics.drawLine(1, 1, n - 2, 1);
        graphics.drawLine(1, 1, 1, n2 - 2);
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth + 1);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth + 1);
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth + 1, this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth + 1, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }
}

