/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class BaseTitlePane
extends JComponent {
    protected static final String PAINT_ACTIVE = "paintActive";
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action maximizeAction;
    protected JMenuBar menuBar;
    protected JButton iconifyButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected Icon iconifyIcon;
    protected Icon maximizeIcon;
    protected Icon minimizeIcon;
    protected Icon closeIcon;
    protected WindowListener windowListener;
    protected Window window;
    protected JRootPane rootPane;
    protected BaseRootPaneUI rootPaneUI;
    protected int buttonsWidth;
    protected int state;

    public BaseTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = baseRootPaneUI;
        this.state = -1;
        this.iconifyIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    protected void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    protected void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected WindowListener createWindowListener() {
        return new WindowHandler();
    }

    protected PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected Frame getFrame() {
        if (this.window instanceof Frame) {
            return (Frame)this.window;
        }
        return null;
    }

    protected Window getWindow() {
        return this.window;
    }

    protected int getWindowDecorationStyle() {
        return DecorationHelper.getWindowDecorationStyle(this.rootPane);
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(DecorationHelper.getExtendedState((Frame)this.window));
            } else {
                this.setState(0);
            }
            this.setActive(JTattooUtilities.isWindowActive(this.window));
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    protected void installSubcomponents() {
        if (this.getWindowDecorationStyle() == 1) {
            this.createActions();
            this.createMenuBar();
            this.createButtons();
            this.add(this.menuBar);
            this.add(this.iconifyButton);
            this.add(this.maxButton);
            this.add(this.closeButton);
        } else {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    protected void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
    }

    protected void uninstallDefaults() {
    }

    protected void createMenuBar() {
        this.menuBar = new SystemMenuBar();
        if (this.getWindowDecorationStyle() == 1) {
            JMenu jMenu = new JMenu("");
            JMenuItem jMenuItem = jMenu.add(this.restoreAction);
            int n = BaseTitlePane.getInt("MetalTitlePane.restoreMnemonic", -1);
            if (n != -1) {
                jMenuItem.setMnemonic(n);
            }
            jMenuItem = jMenu.add(this.iconifyAction);
            n = BaseTitlePane.getInt("MetalTitlePane.iconifyMnemonic", -1);
            if (n != -1) {
                jMenuItem.setMnemonic(n);
            }
            if (DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                jMenuItem = jMenu.add(this.maximizeAction);
                n = BaseTitlePane.getInt("MetalTitlePane.maximizeMnemonic", -1);
                if (n != -1) {
                    jMenuItem.setMnemonic(n);
                }
            }
            jMenu.add(new JSeparator());
            jMenuItem = jMenu.add(this.closeAction);
            n = BaseTitlePane.getInt("MetalTitlePane.closeMnemonic", -1);
            if (n != -1) {
                jMenuItem.setMnemonic(n);
            }
            this.menuBar.add(jMenu);
        }
    }

    protected void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    protected void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            DecorationHelper.setExtendedState(frame, this.state | 1);
        }
    }

    protected void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            if (JTattooUtilities.isWindows()) {
                GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                insets.bottom = Math.max(insets.bottom, 1);
                int n = Math.max(0, insets.left);
                int n2 = Math.max(0, insets.top);
                int n3 = rectangle.width - (insets.left + insets.right);
                int n4 = rectangle.height - (insets.top + insets.bottom);
                frame.setMaximizedBounds(new Rectangle(n, n2, n3, n4));
                DecorationHelper.setExtendedState(frame, this.state | 6);
            } else {
                DecorationHelper.setExtendedState(frame, this.state | 6);
            }
        }
    }

    protected void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            DecorationHelper.setExtendedState(frame, this.state & 0xFFFFFFFE);
        } else {
            DecorationHelper.setExtendedState(frame, this.state & 0xFFFFFFF9);
        }
    }

    protected void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    static int getInt(Object object, int n) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public void createButtons() {
        this.closeButton = new NoFocusButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty(PAINT_ACTIVE, Boolean.TRUE);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(this.closeIcon);
        this.iconifyButton = new NoFocusButton();
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.putClientProperty(PAINT_ACTIVE, Boolean.TRUE);
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.iconifyButton.setIcon(this.iconifyIcon);
        this.maxButton = new NoFocusButton();
        this.maxButton.setAction(this.restoreAction);
        this.maxButton.setText(null);
        this.maxButton.putClientProperty(PAINT_ACTIVE, Boolean.TRUE);
        this.maxButton.getAccessibleContext().setAccessibleName("Maximize");
        this.maxButton.setIcon(this.maximizeIcon);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected void setActive(boolean bl) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty(PAINT_ACTIVE, bl2);
            this.closeButton.putClientProperty(PAINT_ACTIVE, bl2);
            this.maxButton.putClientProperty(PAINT_ACTIVE, bl2);
        }
        this.getRootPane().repaint();
    }

    protected boolean isActive() {
        return this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
    }

    protected boolean isLeftToRight() {
        return this.window == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
    }

    protected void setState(int n) {
        this.setState(n, false);
    }

    protected void setState(int n, boolean bl) {
        if (this.window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == n && !bl) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane jRootPane = this.getRootPane();
                if ((n & 6) != 0 && (jRootPane.getBorder() == null || jRootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    jRootPane.setBorder(null);
                } else if ((n & 6) == 0) {
                    this.rootPaneUI.installBorder(jRootPane);
                }
                if (frame.isResizable()) {
                    if ((n & 6) != 0) {
                        this.updateMaxButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateMaxButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.maxButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.maxButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.maxButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.maxButton.getParent() != null) {
                        this.remove(this.maxButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.maxButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n;
        }
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        this.maxButton.setIcon(icon);
    }

    protected int getHorSpacing() {
        return 3;
    }

    protected int getVerSpacing() {
        return 4;
    }

    protected String getTitle() {
        if (this.window instanceof Frame) {
            return ((Frame)this.window).getTitle();
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).getTitle();
        }
        return null;
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor());
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(graphics);
        boolean bl = this.isLeftToRight();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 - this.buttonsWidth - 10;
        int n5 = n = bl ? 5 : n2 - 5;
        if (this.getWindowDecorationStyle() == 1) {
            n += bl ? n3 : -n3;
            n4 -= n3;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = JTattooUtilities.getClippedText(this.getTitle(), fontMetrics, n4);
        int n6 = fontMetrics.stringWidth(string);
        int n7 = (n3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        if (!bl) {
            n -= n6;
        }
        this.paintText(graphics, n, n7, string);
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            BaseTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            BaseTitlePane.this.setActive(false);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = BaseTitlePane.this.getFrame();
                if (frame != null) {
                    BaseTitlePane.this.setState(DecorationHelper.getExtendedState(frame), true);
                }
                if ("resizable".equals(string)) {
                    BaseTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                BaseTitlePane.this.repaint();
            } else if ("componentOrientation".equals(string)) {
                BaseTitlePane.this.revalidate();
                BaseTitlePane.this.repaint();
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        protected int computeHeight() {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(BaseTitlePane.this.getFont());
            return fontMetrics.getHeight() + 6;
        }

        public void layoutContainer(Container container) {
            int n;
            boolean bl = BaseTitlePane.this.isLeftToRight();
            int n2 = BaseTitlePane.this.getHorSpacing();
            int n3 = BaseTitlePane.this.getWidth();
            int n4 = BaseTitlePane.this.getHeight();
            int n5 = n = n4 - BaseTitlePane.this.getVerSpacing();
            int n6 = bl ? n2 : n3 - n5 - n2;
            int n7 = Math.max(0, (n4 - n) / 2 - 1);
            if (BaseTitlePane.this.menuBar != null) {
                if (bl) {
                    BaseTitlePane.this.menuBar.setBounds(5, n7, BaseTitlePane.this.getHeight() - 2, BaseTitlePane.this.getHeight() - 2);
                } else {
                    BaseTitlePane.this.menuBar.setBounds(BaseTitlePane.this.getWidth() - BaseTitlePane.this.getHeight() - 5, n7, BaseTitlePane.this.getHeight() - 2, BaseTitlePane.this.getHeight() - 2);
                }
            }
            int n8 = n6 = bl ? n3 - n2 : 0;
            if (BaseTitlePane.this.closeButton != null) {
                BaseTitlePane.this.closeButton.setBounds(n6 += bl ? -n5 : n2, n7, n5, n);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (BaseTitlePane.this.maxButton != null && BaseTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                BaseTitlePane.this.maxButton.setBounds(n6 += bl ? -n2 - n5 : n2, n7, n5, n);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (BaseTitlePane.this.iconifyButton != null && BaseTitlePane.this.iconifyButton.getParent() != null) {
                BaseTitlePane.this.iconifyButton.setBounds(n6 += bl ? -n2 - n5 : n2, n7, n5, n);
                if (!bl) {
                    n6 += n5;
                }
            }
            BaseTitlePane.this.buttonsWidth = bl ? n3 - n6 : n6;
        }
    }

    protected class SystemMenuBar
    extends JMenuBar {
        protected SystemMenuBar() {
        }

        public void paint(Graphics graphics) {
            Image image;
            Frame frame = BaseTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                int n = this.getHeight();
                int n2 = 2;
                int n3 = 0;
                graphics.drawImage(image, n2, n3, n, n, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Image image;
            Dimension dimension = super.getPreferredSize();
            Frame frame = BaseTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                return new Dimension(Math.max(image.getWidth(null), dimension.width), Math.max(image.getHeight(null), dimension.height));
            }
            return dimension;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString("MetalTitlePane.maximizeTitle"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BaseTitlePane.this.maximize();
        }
    }

    protected class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString("MetalTitlePane.restoreTitle"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BaseTitlePane.this.restore();
        }
    }

    protected class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString("MetalTitlePane.iconifyTitle"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BaseTitlePane.this.iconify();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString("MetalTitlePane.closeTitle"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BaseTitlePane.this.close();
        }
    }
}

