/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import com.jtattoo.plaf.aluminium.AluminiumUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class AluminiumTabbedPaneUI
extends BaseTabbedPaneUI {
    private static final Color[] SELECTED_TAB_COLORS = new Color[]{AbstractLookAndFeel.getBackgroundColor()};

    public static ComponentUI createUI(JComponent jComponent) {
        return new AluminiumTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets = new Insets(2, 6, 2, 6);
        this.contentBorderInsets = new Insets(2, 2, 2, 2);
    }

    protected Color[] getTabColors(int n, boolean bl) {
        if (bl && this.tabPane.getBackgroundAt(n) instanceof UIResource) {
            return SELECTED_TAB_COLORS;
        }
        return super.getTabColors(n, bl);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            if (this.tabPane.getBackgroundAt(n2) instanceof UIResource) {
                graphics.setColor(AluminiumLookAndFeel.getBackgroundColor());
                if (n == 1) {
                    AluminiumUtils.fillComponent(graphics, this.tabPane, n3 + 1, n4 + 1, n5 - 1, n6 + 1);
                } else if (n == 2) {
                    AluminiumUtils.fillComponent(graphics, this.tabPane, n3 + 1, n4 + 1, n5 + 1, n6 - 1);
                } else if (n == 3) {
                    AluminiumUtils.fillComponent(graphics, this.tabPane, n3 + 1, n4 - 1, n5 - 1, n6 + 1);
                } else {
                    AluminiumUtils.fillComponent(graphics, this.tabPane, n3 - 1, n4 + 1, n5 + 1, n6 - 1);
                }
            } else {
                super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
            }
        } else {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        AluminiumUtils.fillComponent(graphics, this.tabPane, n3, n4, n5, n6);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getControlDarkShadow();
        ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlHighlight();
        graphics.setColor(colorUIResource);
        switch (n) {
            case 1: {
                int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawRect(n3, n4 + n7 - 1, n3 + n5 - 1, n6 - n7);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + n7, n5 - 2, n4 + n7);
                graphics.drawLine(n3 + 1, n4 + n7, n3 + 1, n6 - 2);
                break;
            }
            case 2: {
                int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawRect(n3 + n8 - 1, n4, n5 - n8, n4 + n6 - 1);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + n8, n4 + 1, n3 + n8, n6 - 2);
                graphics.drawLine(n3 + n8, n4 + 1, n5 - 2, n4 + 1);
                break;
            }
            case 3: {
                int n9 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawRect(n3, n4, n3 + n5 - 1, n6 - n9);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + 1, n5 - 2, n4 + 1);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n6 - n9 - 1);
                break;
            }
            case 4: {
                int n10 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawRect(n3, n4, n5 - n10, n4 + n6 - 1);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n6 - 2);
                graphics.drawLine(n3 + 1, n4 + 1, n5 - n10 - 1, n4 + 1);
                break;
            }
        }
    }

    protected void paintScrollContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Insets insets = this.tabPane.getBorder().getBorderInsets(this.tabPane);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getControlDarkShadow();
        ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlHighlight();
        graphics.setColor(colorUIResource);
        switch (n) {
            case 1: {
                int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawLine(n3, n4 + n7 - 1 - insets.top, n5, n4 + n7 - 1 - insets.top);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3, n4 + n7 - insets.top, n5 - 1, n4 + n7 - insets.top);
                break;
            }
            case 2: {
                int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawLine(n3 + n8 - 1 - insets.left, n4, n3 + n8 - 1 - insets.left, n6);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + n8 - insets.left, n4, n3 + n8 - insets.left, n6);
                break;
            }
            case 3: {
                int n9 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                graphics.drawLine(n3, n6 - n9 + insets.bottom, n5, n6 - n9 + insets.bottom);
                break;
            }
            case 4: {
                int n10 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                graphics.drawLine(n5 - n10 + insets.right, n4, n5 - n10 + insets.right, n6);
                break;
            }
        }
    }

    protected void paintRoundedTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getControlDarkShadow();
        ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlHighlight();
        int n6 = 10;
        if (bl) {
            graphics.setColor(ColorHelper.brighter(colorUIResource, 20.0));
            graphics.drawLine(n2 + 5, n3, n4 - 5, n3);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n2 + 5, n3 + 1, n4 - 5, n3 + 1);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 10.0));
            graphics.drawArc(n2, n3, n6, n6, 90, 90);
            graphics.setColor(colorUIResource2);
            graphics.drawArc(n2 + 1, n3 + 1, n6, n6, 90, 90);
            graphics.setColor(ColorHelper.brighter(colorUIResource, 10.0));
            graphics.drawArc(n4 - n6, n3, n6, n6, 0, 90);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n2, n3 + 5 + 1, n2, n5);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(n2 + 1, n3 + 5 + 1, n2 + 1, n5);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n4, n3 + 5 + 1, n4, n5);
        } else {
            graphics.setColor(colorUIResource);
            graphics.drawLine(n2 + 5, n3, n4 - 5, n3);
            graphics.drawArc(n2, n3, n6, n6, 90, 90);
            graphics.drawArc(n4 - n6, n3, n6, n6, 0, 90);
            graphics.drawLine(n2, n3 + 5 + 1, n2, n5);
            graphics.drawLine(n4, n3 + 5 + 1, n4, n5);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

