/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JRootPane;

public class AluminiumTitlePane
extends BaseTitlePane {
    private static final Color foreColor = new Color(32, 32, 32);
    private static final Color shadowColor = new Color(232, 232, 232);
    private static final Color rolloverColor = new Color(196, 203, 163);
    protected static final Icon iconIcon = new BaseIcons.IconSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
    protected static final Icon minIcon = new BaseIcons.MinSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
    protected static final Icon maxIcon = new BaseIcons.MaxSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
    protected static final Icon closeIcon = new BaseIcons.CloseSymbol(foreColor, Color.white, rolloverColor, new Insets(0, 0, 1, 0));

    public AluminiumTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void createButtons() {
        super.createButtons();
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setBorder(BorderFactory.createEmptyBorder());
        this.iconifyButton.setContentAreaFilled(false);
        this.iconifyButton.setBorder(BorderFactory.createEmptyBorder());
        this.maxButton.setContentAreaFilled(false);
        this.maxButton.setBorder(BorderFactory.createEmptyBorder());
    }

    protected void setButtonIcons() {
        this.iconifyButton.setIcon(iconIcon);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(maxIcon);
        } else {
            this.maxButton.setIcon(minIcon);
        }
        this.closeButton.setIcon(closeIcon);
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(minIcon);
        } else {
            this.maxButton.setIcon(maxIcon);
        }
    }

    protected void setActive(boolean bl) {
        super.setActive(bl);
        this.setButtonIcons();
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight() - 1);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight() - 1);
        }
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getWindowBorderColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getTheme().getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
            JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
            JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
        }
    }
}

