/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.mcwin.McWinLookAndFeel;
import com.jtattoo.plaf.mcwin.McWinUtils;
import com.jtattoo.plaf.mcwin.icons.ImageHelper;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JRootPane;

public class McWinTitlePane
extends BaseTitlePane {
    protected static ImageIcon iconIcon = ImageHelper.loadImage("pearl_green.gif");
    protected static ImageIcon minIcon = ImageHelper.loadImage("pearl_orange.gif");
    protected static ImageIcon maxIcon = ImageHelper.loadImage("pearl_orange.gif");
    protected static ImageIcon closeIcon = ImageHelper.loadImage("pearl_red.gif");
    protected static ImageIcon iconRolloverIcon = ImageHelper.loadImage("iconizer.gif");
    protected static ImageIcon minRolloverIcon = ImageHelper.loadImage("minimizer.gif");
    protected static ImageIcon maxRolloverIcon = ImageHelper.loadImage("maximizer.gif");
    protected static ImageIcon closeRolloverIcon = ImageHelper.loadImage("closer.gif");
    protected static ImageIcon inactiveIcon = ImageHelper.loadImage("pearl_white.gif");
    protected static ImageIcon iconInactiveRolloverIcon = ImageHelper.loadImage("iconizer_inactive.gif");
    protected static ImageIcon minInactiveRolloverIcon = ImageHelper.loadImage("minimizer_inactive.gif");
    protected static ImageIcon maxInactiveRolloverIcon = ImageHelper.loadImage("maximizer_inactive.gif");
    protected static ImageIcon closeInactiveRolloverIcon = ImageHelper.loadImage("closer_inactive.gif");

    public McWinTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void createButtons() {
        this.maximizeIcon = maxIcon;
        this.minimizeIcon = minIcon;
        this.closeButton = new TitleButton(this.closeAction, "Close");
        this.iconifyButton = new TitleButton(this.iconifyAction, "Iconify");
        this.maxButton = new TitleButton(this.restoreAction, "Maximize");
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        if (JTattooUtilities.isWindowActive(this.getWindow())) {
            this.iconifyButton.setIcon(iconIcon);
            this.iconifyButton.setRolloverIcon(iconRolloverIcon);
            this.iconifyButton.setPressedIcon(iconRolloverIcon);
            if ((this.state & 6) == 0) {
                this.maxButton.setIcon(maxIcon);
                this.maxButton.setRolloverIcon(maxRolloverIcon);
                this.maxButton.setPressedIcon(maxRolloverIcon);
            } else {
                this.maxButton.setIcon(minIcon);
                this.maxButton.setRolloverIcon(minRolloverIcon);
                this.maxButton.setPressedIcon(minRolloverIcon);
            }
            this.closeButton.setIcon(closeIcon);
            this.closeButton.setRolloverIcon(closeRolloverIcon);
            this.closeButton.setPressedIcon(closeRolloverIcon);
        } else {
            this.iconifyButton.setIcon(inactiveIcon);
            this.iconifyButton.setRolloverIcon(iconInactiveRolloverIcon);
            this.iconifyButton.setPressedIcon(iconInactiveRolloverIcon);
            this.maxButton.setIcon(inactiveIcon);
            if ((this.state & 6) == 0) {
                this.maxButton.setRolloverIcon(maxInactiveRolloverIcon);
                this.maxButton.setPressedIcon(maxInactiveRolloverIcon);
            } else {
                this.maxButton.setRolloverIcon(minInactiveRolloverIcon);
                this.maxButton.setPressedIcon(minInactiveRolloverIcon);
            }
            this.closeButton.setIcon(inactiveIcon);
            this.closeButton.setRolloverIcon(closeInactiveRolloverIcon);
            this.closeButton.setPressedIcon(closeInactiveRolloverIcon);
        }
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(minIcon);
            this.maxButton.setRolloverIcon(minRolloverIcon);
            this.maxButton.setPressedIcon(minRolloverIcon);
        } else {
            this.maxButton.setIcon(maxIcon);
            this.maxButton.setRolloverIcon(maxRolloverIcon);
            this.maxButton.setPressedIcon(maxRolloverIcon);
        }
    }

    protected void setActive(boolean bl) {
        super.setActive(bl);
        this.setButtonIcons();
    }

    public void paintBackground(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isActive()) {
            McWinUtils.fillComponent(graphics, this, McWinLookAndFeel.getTheme().getWindowTitleColors());
            graphics.setColor(McWinLookAndFeel.getWindowBorderColor());
        } else {
            McWinUtils.fillComponent(graphics, this, McWinLookAndFeel.getTheme().getWindowInactiveTitleColors());
            graphics.setColor(McWinLookAndFeel.getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    private class TitleButton
    extends NoFocusButton {
        public TitleButton(Action action, String string) {
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setAction(action);
            this.setText(null);
            this.putClientProperty("paintActive", Boolean.TRUE);
            this.getAccessibleContext().setAccessibleName(string);
        }

        public void paint(Graphics graphics) {
            if (JTattooUtilities.isWindowActive(McWinTitlePane.this.window)) {
                super.paint(graphics);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite(alphaComposite);
                super.paint(graphics);
                graphics2D.setComposite(composite);
            }
        }
    }
}

