/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.mint.MintIcons;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRootPane;

public class MintTitlePane
extends BaseTitlePane {
    protected final Icon iconIcon = MintIcons.getIconButtonIcon();
    protected final Icon minIcon = MintIcons.getMinButtonIcon();
    protected final Icon maxIcon = MintIcons.getMaxButtonIcon();
    protected final Icon closeIcon = MintIcons.getCloseButtonIcon();

    public MintTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void createButtons() {
        this.maximizeIcon = this.maxIcon;
        this.minimizeIcon = this.minIcon;
        this.closeButton = new TitleButton(this.closeAction, "Close");
        this.iconifyButton = new TitleButton(this.iconifyAction, "Iconify");
        this.maxButton = new TitleButton(this.restoreAction, "Maximize");
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        this.iconifyButton.setIcon(this.iconIcon);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(this.maxIcon);
        } else {
            this.maxButton.setIcon(this.minIcon);
        }
        this.closeButton.setIcon(this.closeIcon);
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        if ((this.state & 6) == 0) {
            this.maxButton.setIcon(this.minIcon);
        } else {
            this.maxButton.setIcon(this.maxIcon);
        }
    }

    protected void setActive(boolean bl) {
        super.setActive(bl);
        this.setButtonIcons();
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            this.setBackground(MintLookAndFeel.getTheme().getWindowTitleBackgroundColor());
            JTattooUtilities.fillVerGradient(graphics, MintLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        } else {
            this.setBackground(MintLookAndFeel.getTheme().getWindowInactiveTitleBackgroundColor());
            JTattooUtilities.fillVerGradient(graphics, MintLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        }
        graphics.setColor(ColorHelper.darker(MintLookAndFeel.getTheme().getWindowTitleColorDark(), 10.0));
        graphics.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private class TitleButton
    extends NoFocusButton {
        public TitleButton(Action action, String string) {
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setAction(action);
            this.setText(null);
            this.putClientProperty("paintActive", Boolean.TRUE);
            this.getAccessibleContext().setAccessibleName(string);
        }

        public void paint(Graphics graphics) {
            if (JTattooUtilities.isWindowActive(MintTitlePane.this.window)) {
                super.paint(graphics);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
                graphics2D.setComposite(alphaComposite);
                super.paint(graphics);
                graphics2D.setComposite(composite);
            }
        }
    }
}

