/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidDesktopManager;
import com.birosoft.liquid.LiquidInternalFrameBorder;
import com.birosoft.liquid.LiquidInternalFrameTitlePane;
import com.birosoft.liquid.LiquidLookAndFeel;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class LiquidInternalFrameUI
extends BasicInternalFrameUI {
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private static String FRAME_TYPE = "JInternalFrame.frameType";
    private static String NORMAL_FRAME = "normal";
    private static String PALETTE_FRAME = "palette";
    private static String OPTION_DIALOG = "optionDialog";
    private static final PropertyChangeListener liquidPropertyChangeListener = new LiquidPropertyChangeHandler();
    static boolean allowRoundedWindows = false;
    private static DesktopManager sharedDesktopManager;
    Border frameBorder = null;
    private LiquidInternalFrameTitlePane titlePane;

    public LiquidInternalFrameUI(JInternalFrame frame) {
        super(frame);
    }

    public static ComponentUI createUI(JComponent c) {
        return new LiquidInternalFrameUI((JInternalFrame)c);
    }

    JDesktopPane getDesktopPane(JComponent frame) {
        JDesktopPane pane = null;
        Container c = frame.getParent();
        while (pane == null) {
            if (c instanceof JDesktopPane) {
                pane = (JDesktopPane)c;
                continue;
            }
            if (c == null) break;
            c = c.getParent();
        }
        return pane;
    }

    protected DesktopManager getDesktopManager() {
        if (!allowRoundedWindows) {
            return super.getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = this.createDesktopManager();
        }
        return sharedDesktopManager;
    }

    protected DesktopManager createDesktopManager() {
        if (!allowRoundedWindows) {
            return super.createDesktopManager();
        }
        return new LiquidDesktopManager();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (allowRoundedWindows) {
            this.frame.setOpaque(false);
        }
        this.frameBorder = LiquidLookAndFeel.winDecoPanther ? UIManager.getBorder("RootPane.frameBorder") : new LiquidInternalFrameBorder();
        this.frame.setBorder(this.frameBorder);
        this.frame.addPropertyChangeListener(liquidPropertyChangeListener);
        Object paletteProp = c.getClientProperty(IS_PALETTE);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
    }

    public void uninstallUI(JComponent c) {
        this.frame.removePropertyChangeListener(liquidPropertyChangeListener);
        super.uninstallUI(c);
    }

    protected JComponent createNorthPane(JInternalFrame frame) {
        super.createNorthPane(frame);
        this.titlePane = new LiquidInternalFrameTitlePane(frame);
        return this.titlePane;
    }

    protected void activateFrame(JInternalFrame f) {
        super.activateFrame(f);
        if (!LiquidLookAndFeel.winDecoPanther) {
            ((LiquidInternalFrameBorder)this.frameBorder).setActive(true);
        }
        this.titlePane.activate();
    }

    protected void deactivateFrame(JInternalFrame f) {
        super.deactivateFrame(f);
        if (!LiquidLookAndFeel.winDecoPanther) {
            ((LiquidInternalFrameBorder)this.frameBorder).setActive(false);
        }
        this.titlePane.deactivate();
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        this.titlePane.setPalette(isPalette);
        if (!LiquidLookAndFeel.winDecoPanther) {
            ((LiquidInternalFrameBorder)this.frameBorder).isPalette = isPalette;
        }
        this.frame.setBorder(this.frameBorder);
    }

    private void stripContentBorder(Object c) {
        JComponent contentComp;
        Border contentBorder;
        if (c instanceof JComponent && ((contentBorder = (contentComp = (JComponent)c).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentComp.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
    }

    private void setFrameType(String frameType) {
        if (frameType.equals(OPTION_DIALOG)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.optionDialogBorder");
            this.titlePane.setPalette(false);
        } else if (frameType.equals(PALETTE_FRAME)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
            this.titlePane.setPalette(true);
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
            this.titlePane.setPalette(false);
        }
    }

    private static class LiquidPropertyChangeHandler
    implements PropertyChangeListener {
        private LiquidPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            JInternalFrame jif = (JInternalFrame)e.getSource();
            if (!(jif.getUI() instanceof LiquidInternalFrameUI)) {
                return;
            }
            LiquidInternalFrameUI ui = (LiquidInternalFrameUI)jif.getUI();
            if (name.equals(FRAME_TYPE)) {
                if (e.getNewValue() instanceof String) {
                    ui.setFrameType((String)e.getNewValue());
                }
            } else if (name.equals(IS_PALETTE)) {
                if (e.getNewValue() != null) {
                    ui.setPalette((Boolean)e.getNewValue());
                } else {
                    ui.setPalette(false);
                }
            } else if (name.equals("contentPane")) {
                ui.stripContentBorder(e.getNewValue());
            }
        }
    }
}

