/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.util.Colors;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class LiquidPanelUI
extends BasicPanelUI {
    private static LiquidPanelUI panelUI;
    private static ArrayList panels;

    public static ComponentUI createUI(JComponent c) {
        if (panelUI == null) {
            panelUI = new LiquidPanelUI();
        }
        return panelUI;
    }

    public void installUI(JComponent c) {
        JPanel p = (JPanel)c;
        super.installUI(p);
        this.installDefaults(p);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        Iterator i = panels.iterator();
        while (i.hasNext()) {
            ((JPanel)i.next()).setOpaque(true);
        }
        panels.removeAll(panels);
    }

    public void paint(Graphics g, JComponent c) {
        Color bg = LiquidLookAndFeel.getBackgroundColor();
        if (LiquidLookAndFeel.areStipplesUsed()) {
            Container container = c.getParent();
            if (LiquidLookAndFeel.panelTransparency && container instanceof JPanel && c.isOpaque() && ((JPanel)c).getClientProperty("panelTransparency") == null) {
                panels.add(c);
                c.setOpaque(false);
                if (c.isOpaque()) {
                    ((JPanel)c).putClientProperty("panelTransparency", null);
                }
                container.invalidate();
                container.repaint();
            }
            if (LiquidLookAndFeel.getBackgroundColor().equals(c.getBackground()) && c.isOpaque()) {
                Colors.drawStipples(g, c, bg);
            }
        }
        super.paint(g, c);
    }

    static {
        panels = new ArrayList();
    }
}

