/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;

public class NimRODBorders
extends MetalBorders {
    private static Border butBorder;
    private static Border popupMenuBorder;
    private static Border rolloverButtonBorder;
    private static Border scrollPaneBorder;

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new NimRODPopupMenuBorder();
        }
        return popupMenuBorder;
    }

    public static Border getButtonBorder() {
        if (butBorder == null) {
            butBorder = new BorderUIResource.CompoundBorderUIResource(new NimRODButtonBorder(), new BasicBorders.MarginBorder());
        }
        return butBorder;
    }

    public static Border getRolloverButtonBorder() {
        if (rolloverButtonBorder == null) {
            rolloverButtonBorder = new BorderUIResource.CompoundBorderUIResource(new NimRODRolloverButtonBorder(), new BasicBorders.MarginBorder());
        }
        return rolloverButtonBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new NimRODScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    public static class NimRODButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2083885266582056467L;

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JButton button;
            g.translate(x, y);
            g.setColor(NimRODLookAndFeel.getControlDarkShadow());
            g.drawRoundRect(0, 0, w - 1, h - 1, 8, 8);
            if (c instanceof JButton && (button = (JButton)c).isDefaultButton()) {
                g.setColor(NimRODLookAndFeel.getControlDarkShadow().darker());
                g.drawRoundRect(1, 1, w - 3, h - 3, 7, 7);
            }
        }
    }

    public static class NimRODPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2083885266582056468L;
        protected static Insets borderInsets = new Insets(1, 1, 5, 5);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(NimRODLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 5, h - 5);
            Icon icono = UIManager.getIcon("BorderPopupMenu.SombraEsqIcon");
            icono.paintIcon(c, g, w - 5, h - 5);
            icono = UIManager.getIcon("BorderPopupMenu.SombraUpIcon");
            icono.paintIcon(c, g, w - 5, 0);
            icono = UIManager.getIcon("BorderPopupMenu.SombraIzqIcon");
            icono.paintIcon(c, g, 0, h - 5);
            icono = UIManager.getIcon("BorderPopupMenu.SombraBajIcon");
            int xi = 5;
            while (xi < w - 5) {
                icono.paintIcon(c, g, xi, h - 5);
                ++xi;
            }
            icono = UIManager.getIcon("BorderPopupMenu.SombraDerIcon");
            int yi = 5;
            while (yi < h - 5) {
                icono.paintIcon(c, g, w - 5, yi);
                ++yi;
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = NimRODPopupMenuBorder.borderInsets.top;
            newInsets.left = NimRODPopupMenuBorder.borderInsets.left;
            newInsets.bottom = NimRODPopupMenuBorder.borderInsets.bottom;
            newInsets.right = NimRODPopupMenuBorder.borderInsets.right;
            return newInsets;
        }
    }

    public static class NimRODRolloverButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -2083885266582056469L;

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ButtonModel model = ((AbstractButton)c).getModel();
            if (model.isRollover()) {
                g.setColor(NimRODLookAndFeel.getControlDarkShadow());
                g.drawRoundRect(0, 0, w - 1, h - 1, 8, 8);
                RoundRectangle2D.Float boton = new RoundRectangle2D.Float();
                boton.x = 0.0f;
                boton.y = 0.0f;
                boton.width = c.getWidth();
                boton.height = c.getHeight();
                boton.arcwidth = 8.0f;
                boton.archeight = 8.0f;
                GradientPaint grad = null;
                grad = model.isPressed() ? new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.sombra, 0.0f, c.getHeight() / 2, NimRODLookAndFeel.brillo) : new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.brillo, 0.0f, c.getHeight(), NimRODLookAndFeel.sombra);
                Graphics2D g2D = (Graphics2D)g;
                g2D.setPaint(grad);
                g2D.fill(boton);
            }
        }
    }

    public static class NimRODScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -6416636693876853556L;
        private static final Insets insets = new Insets(1, 1, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(NimRODLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(NimRODLookAndFeel.getControlHighlight());
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }
    }
}

