/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODIconFactory;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class NimRODLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 7191199335214123414L;
    public static Color brillo = new Color(255, 255, 255, 64);
    public static Color sombra = new Color(20, 20, 20, 50);
    public static Color negroOpaco = new Color(0, 0, 0, 64);
    public static Color negroTrans = new Color(0, 0, 0, 0);
    public static Color blancoOpaco = new Color(255, 255, 255, 128);
    public static Color blancoTrans = new Color(255, 255, 255, 0);
    protected static Color rollColor;
    public String fichTheme = "";
    protected static MetalTheme theme;

    public NimRODLookAndFeel() {
        String op;
        String b;
        String w;
        String s3;
        String s2;
        String s1;
        String p3;
        String p2;
        String p1;
        String background;
        String selection;
        NimRODTheme nt = new NimRODTheme();
        try {
            String nomFich = System.getProperty("nimrodlf.themeFile");
            nomFich = nomFich == null ? "NimRODThemeFile.theme" : nomFich;
            Properties props = new Properties();
            props.load(new FileInputStream(nomFich));
            selection = props.getProperty("nimrodlf.selection");
            background = props.getProperty("nimrodlf.background");
            p1 = props.getProperty("nimrodlf.p1");
            p2 = props.getProperty("nimrodlf.p2");
            p3 = props.getProperty("nimrodlf.p3");
            s1 = props.getProperty("nimrodlf.s1");
            s2 = props.getProperty("nimrodlf.s2");
            s3 = props.getProperty("nimrodlf.s3");
            w = props.getProperty("nimrodlf.w");
            b = props.getProperty("nimrodlf.b");
            op = props.getProperty("nimrodlf.opacity");
            nt = this.iniCustomColors(nt, selection, background, p1, p2, p3, s1, s2, s3, w, b, op);
            this.fichTheme = nomFich;
        }
        catch (Exception ex) {
            nt = new NimRODTheme();
        }
        try {
            selection = System.getProperty("nimrodlf.selection");
            background = System.getProperty("nimrodlf.background");
            p1 = System.getProperty("nimrodlf.p1");
            p2 = System.getProperty("nimrodlf.p2");
            p3 = System.getProperty("nimrodlf.p3");
            s1 = System.getProperty("nimrodlf.s1");
            s2 = System.getProperty("nimrodlf.s2");
            s3 = System.getProperty("nimrodlf.s3");
            w = System.getProperty("nimrodlf.w");
            b = System.getProperty("nimrodlf.b");
            op = System.getProperty("nimrodlf.opacity");
            nt = this.iniCustomColors(nt, selection, background, p1, p2, p3, s1, s2, s3, w, b, op);
        }
        catch (Exception ex) {
            nt = new NimRODTheme();
        }
        NimRODLookAndFeel.setCurrentTheme(nt);
    }

    protected NimRODTheme iniCustomColors(NimRODTheme nt, String selection, String background, String p1, String p2, String p3, String s1, String s2, String s3, String w, String b, String op) {
        if (selection != null) {
            nt.setPrimary(Color.decode(selection));
        }
        if (background != null) {
            nt.setSecondary(Color.decode(background));
        }
        if (p1 != null) {
            nt.setPrimary1(Color.decode(p1));
        }
        if (p2 != null) {
            nt.setPrimary2(Color.decode(p2));
        }
        if (p3 != null) {
            nt.setPrimary3(Color.decode(p3));
        }
        if (s1 != null) {
            nt.setSecondary1(Color.decode(s1));
        }
        if (s2 != null) {
            nt.setSecondary2(Color.decode(s2));
        }
        if (s3 != null) {
            nt.setSecondary3(Color.decode(s3));
        }
        if (w != null) {
            nt.setWhite(Color.decode(w));
        }
        if (b != null) {
            nt.setBlack(Color.decode(b));
        }
        if (op != null) {
            nt.setOpacity(Integer.parseInt(op));
        }
        return nt;
    }

    public String getID() {
        return "NimROD";
    }

    public String getName() {
        return "NimROD";
    }

    public String getDescription() {
        return "Look and Feel NimROD, 2006";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public static void setCurrentTheme(MetalTheme t) {
        MetalLookAndFeel.setCurrentTheme(t);
        theme = t;
        rollColor = null;
    }

    public static int getOpacity() {
        try {
            NimRODTheme th = (NimRODTheme)theme;
            return th.getOpacity();
        }
        catch (Throwable ex) {
            return 220;
        }
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        table.put("ButtonUI", "com.nilo.plaf.nimrod.NimRODButtonUI");
        table.put("ToggleButtonUI", "com.nilo.plaf.nimrod.NimRODToggleButtonUI");
        table.put("TextFieldUI", "com.nilo.plaf.nimrod.NimRODTextFieldUI");
        table.put("PasswordFieldUI", "com.nilo.plaf.nimrod.NimRODPasswordFieldUI");
        table.put("CheckBoxUI", "com.nilo.plaf.nimrod.NimRODCheckBoxUI");
        table.put("RadioButtonUI", "com.nilo.plaf.nimrod.NimRODRadioButtonUI");
        table.put("FormattedTextFieldUI", "com.nilo.plaf.nimrod.NimRODFormattedTextFieldUI");
        table.put("SliderUI", "com.nilo.plaf.nimrod.NimRODSliderUI");
        table.put("ListUI", "com.nilo.plaf.nimrod.NimRODListUI");
        table.put("ScrollBarUI", "com.nilo.plaf.nimrod.NimRODScrollBarUI");
        table.put("ToolBarUI", "com.nilo.plaf.nimrod.NimRODToolBarUI");
        table.put("ProgressBarUI", "com.nilo.plaf.nimrod.NimRODProgressBarUI");
        table.put("TabbedPaneUI", "com.nilo.plaf.nimrod.NimRODTabbedPaneUI");
        table.put("TableHeaderUI", "com.nilo.plaf.nimrod.NimRODTableHeaderUI");
        table.put("SplitPaneUI", "com.nilo.plaf.nimrod.NimRODSplitPaneUI");
        table.put("MenuBarUI", "com.nilo.plaf.nimrod.NimRODMenuBarUI");
        table.put("MenuUI", "com.nilo.plaf.nimrod.NimRODMenuUI");
        table.put("PopupMenuUI", "com.nilo.plaf.nimrod.NimRODPopupMenuUI");
        table.put("PopupMenuSeparatorUI", "com.nilo.plaf.nimrod.NimRODPopupMenuSeparatorUI");
        table.put("MenuItemUI", "com.nilo.plaf.nimrod.NimRODMenuItemUI");
        table.put("CheckBoxMenuItemUI", "com.nilo.plaf.nimrod.NimRODCheckBoxMenuItemUI");
        table.put("RadioButtonMenuItemUI", "com.nilo.plaf.nimrod.NimRODRadioButtonMenuItemUI");
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", NimRODLookAndFeel.getMenuSelectedBackground());
        table.put("textInactiveText", NimRODLookAndFeel.getInactiveSystemTextColor().darker());
    }

    private int tercio(int a, int b) {
        return b + 2 * ((a - b) / 3);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        try {
            Color cFore = (Color)table.get("MenuItem.disabledForeground");
            Color cBack = (Color)table.get("MenuItem.foreground");
            Color col = new Color(this.tercio(cFore.getRed(), cBack.getRed()), this.tercio(cFore.getGreen(), cBack.getGreen()), this.tercio(cFore.getBlue(), cBack.getBlue()));
            table.put("MenuItem.disabledForeground", col);
            table.put("Label.disabledForeground", col);
            table.put("CheckBoxMenuItem.disabledForeground", col);
            table.put("Menu.disabledForeground", col);
            table.put("RadioButtonMenuItem.disabledForeground", col);
            table.put("ComboBox.disabledForeground", col);
            table.put("Button.disabledText", col);
            table.put("ToggleButton.disabledText", col);
            table.put("CheckBox.disabledText", col);
            table.put("RadioButton.disabledText", col);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        table.put("BorderPopupMenu.SombraBajIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuBajo.png"));
        table.put("BorderPopupMenu.SombraDerIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuDer.png"));
        table.put("BorderPopupMenu.SombraEsqIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuEsq.png"));
        table.put("BorderPopupMenu.SombraUpIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuUp.png"));
        table.put("BorderPopupMenu.SombraIzqIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/SombraMenuIzq.png"));
        table.put("Tree.collapsedIcon", NimRODIconFactory.getTreeCollapsedIcon());
        table.put("Tree.expandedIcon", NimRODIconFactory.getTreeExpandedIcon());
        table.put("Tree.closedIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeDirCerrado.png"));
        table.put("Tree.openIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeDirAbierto.png"));
        table.put("Tree.leafIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeFicheroIcon.png"));
        table.put("Tree.EstructuraCollapsedIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeCollapsedIcon.png"));
        table.put("Tree.EstructuraExpandedIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeExpandedIcon.png"));
        table.put("FileView.directoryIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogDirCerrado.png"));
        table.put("FileView.fileIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogFicheroIcon.png"));
        table.put("FileView.floppyDriveIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogFloppyIcon.png"));
        table.put("FileView.hardDriveIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogHDIcon.png"));
        table.put("FileChooser.newFolderIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogNewDir.png"));
        table.put("FileChooser.homeFolderIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogHome.png"));
        table.put("FileChooser.upFolderIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogDirParriba.png"));
        table.put("FileChooser.detailsViewIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogDetails.png"));
        table.put("FileChooser.listViewIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogList.png"));
        table.put("CheckBoxMenuItem.checkIcon", NimRODIconFactory.getCheckBoxMenuItemIcon());
        table.put("RadioButtonMenuItem.checkIcon", NimRODIconFactory.getRadioButtonMenuItemIcon());
        table.put("Menu.checkIcon", NimRODIconFactory.getBandaMenuItemIcon());
        table.put("MenuItem.checkIcon", NimRODIconFactory.getBandaMenuItemIcon());
        table.put("MenuCheckBox.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuCheckBoxBase.png"));
        table.put("MenuCheckBox.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuCheckBoxTick.png"));
        table.put("MenuRadioButton.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuRadioBase.png"));
        table.put("MenuRadioButton.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuRadioTick.png"));
        table.put("CheckBox.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/CheckBoxBase.png"));
        table.put("CheckBox.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/CheckBoxTick.png"));
        table.put("RadioButton.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/RadioButtonBase.png"));
        table.put("RadioButton.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/RadioButtonTick.png"));
        table.put("OptionPane.errorIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Error.png"));
        table.put("OptionPane.informationIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Inform.png"));
        table.put("OptionPane.warningIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Warn.png"));
        table.put("OptionPane.questionIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Question.png"));
        table.put("Slider.horizontalThumbIcon", NimRODIconFactory.getSliderHorizontalIcon());
        table.put("Slider.verticalThumbIcon", NimRODIconFactory.getSliderVerticalIcon());
        table.put("Slider.horizontalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/HorizontalThumbIconImage.png"));
        table.put("Slider.verticalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/VerticalThumbIconImage.png"));
        table.put("ScrollBar.horizontalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/HorizontalScrollIconImage.png"));
        table.put("ScrollBar.verticalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/VerticalScrollIconImage.png"));
        table.put("Button.margin", new InsetsUIResource(5, 14, 5, 14));
        table.put("ToggleButton.margin", new InsetsUIResource(5, 14, 5, 14));
        table.put("ScrollPane.border", NimRODBorders.getScrollPaneBorder());
        table.put("InternalFrame.activeTitleBackground", NimRODLookAndFeel.getMenuSelectedBackground());
        table.put("InternalFrame.activeTitleGradient", NimRODLookAndFeel.getMenuSelectedBackground().darker());
        table.put("InternalFrame.inactiveTitleBackground", NimRODLookAndFeel.getMenuBackground().brighter());
        table.put("InternalFrame.inactiveTitleGradient", NimRODLookAndFeel.getMenuBackground().darker());
    }

    private ImageIcon loadRes(String fich) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.readStream(this.getClass().getResourceAsStream(fich))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("No se puede cargar el recurso " + fich);
            return null;
        }
    }

    private byte[] readStream(InputStream input) throws IOException {
        int read;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, 256)) != -1) {
            bytes.write(buffer, 0, read);
        }
        return bytes.toByteArray();
    }

    public static void pintaBarraMenu(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        if (model.isArmed() || menuItem instanceof JMenu && !((JMenu)menuItem).isTopLevelMenu() && model.isSelected()) {
            RoundRectangle2D.Float boton = new RoundRectangle2D.Float();
            boton.x = 1.0f;
            boton.y = 0.0f;
            boton.width = menuWidth - 3;
            boton.height = menuHeight - 1;
            boton.arcwidth = 8.0f;
            boton.archeight = 8.0f;
            GradientPaint grad = new GradientPaint(1.0f, 1.0f, brillo, 0.0f, menuHeight, sombra);
            Graphics2D g2D = (Graphics2D)g;
            g.setColor(bgColor);
            g2D.fill(boton);
            g.setColor(bgColor.darker());
            g2D.draw(boton);
            g2D.setPaint(grad);
            g2D.fill(boton);
        }
        g.setColor(oldColor);
    }

    public static Color getRolloverColor() {
        if (rollColor == null) {
            rollColor = new Color(UIManager.getColor("Button.focus").getRed(), UIManager.getColor("Button.focus").getGreen(), UIManager.getColor("Button.focus").getBlue(), 40);
        }
        return rollColor;
    }
}

