/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.Position;

public class NimRODPasswordView
extends PasswordView {
    protected static int ancho = 9;
    protected static int hueco = 3;

    public NimRODPasswordView(Element elem) {
        super(elem);
    }

    protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
        int w = this.getFontMetrics().charWidth(c);
        w = w < ancho ? ancho : w;
        int h = this.getContainer().getHeight() / 2;
        g.fillRect(x + 1, y - h, w - 2, w);
        g.fillRect(x, y - h + 1, w, w - 2);
        return x + w + hueco;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Container c = this.getContainer();
        if (c instanceof JPasswordField) {
            JPasswordField f = (JPasswordField)c;
            if (!f.echoCharIsSet()) {
                return super.modelToView(pos, a, b);
            }
            char echoChar = f.getEchoChar();
            int w = f.getFontMetrics(f.getFont()).charWidth(echoChar);
            w = (w < ancho ? ancho : w) + hueco;
            Rectangle alloc = this.adjustAllocation(a).getBounds();
            int dx = (pos - this.getStartOffset()) * w;
            alloc.x += dx - 2;
            if (alloc.x <= 1) {
                alloc.x = 2;
            }
            alloc.width = 1;
            return alloc;
        }
        return null;
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        bias[0] = Position.Bias.Forward;
        int n = 0;
        Container c = this.getContainer();
        if (c instanceof JPasswordField) {
            JPasswordField f = (JPasswordField)c;
            if (!f.echoCharIsSet()) {
                return super.viewToModel(fx, fy, a, bias);
            }
            char echoChar = f.getEchoChar();
            int w = f.getFontMetrics(f.getFont()).charWidth(echoChar);
            w = (w < ancho ? ancho : w) + hueco;
            a = this.adjustAllocation(a);
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            n = ((int)fx - alloc.x) / w;
            if (n < 0) {
                n = 0;
            } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                n = this.getDocument().getLength() - this.getStartOffset();
            }
        }
        return this.getStartOffset() + n;
    }
}

