/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class NimRODTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color selectColor;
    private int inclTab = 12;
    private int anchoFocoH = 4;
    private int anchoCarpetas = 18;
    private int rollover = -1;
    private int antRollover = -1;
    private MiML miml;
    private Polygon shape;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.rollover = -1;
        this.selectColor = NimRODLookAndFeel.getFocusColor();
        this.tabAreaInsets.right = this.anchoCarpetas;
    }

    protected void installListeners() {
        super.installListeners();
        this.miml = new MiML();
        this.tabPane.addMouseMotionListener(this.miml);
        this.tabPane.addMouseListener(this.miml);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseMotionListener(this.miml);
        this.tabPane.removeMouseListener(this.miml);
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRectPeq = new Rectangle(tabRect);
        tabRectPeq.width -= this.inclTab;
        super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRectPeq, iconRect, textRect, isSelected);
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.runCount > 1) {
            int fila;
            int[] lines = new int[this.runCount];
            int i = 0;
            while (i < this.runCount) {
                lines[i] = this.rects[this.tabRuns[i]].y + (tabPlacement == 1 ? this.maxTabHeight : 0);
                ++i;
            }
            Arrays.sort(lines);
            if (tabPlacement == 1) {
                fila = this.runCount;
                int i2 = 0;
                while (i2 < lines.length - 1) {
                    Polygon carp = new Polygon();
                    carp.addPoint(0, lines[i2]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 2, lines[i2]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila, lines[i2] + 3);
                    if (i2 < lines.length - 2) {
                        carp.addPoint(this.tabPane.getWidth() - 2 * fila, lines[i2 + 1]);
                        carp.addPoint(0, lines[i2 + 1]);
                    } else {
                        carp.addPoint(this.tabPane.getWidth() - 2 * fila, lines[i2] + this.rects[selectedIndex].height);
                        carp.addPoint(0, lines[i2] + this.rects[selectedIndex].height);
                    }
                    carp.addPoint(0, lines[i2]);
                    g.setColor(this.hazAlfa(fila));
                    g.fillPolygon(carp);
                    g.setColor(this.darkShadow.darker());
                    g.drawPolygon(carp);
                    ++i2;
                    --fila;
                }
            } else {
                fila = 0;
                int i3 = 0;
                while (i3 < lines.length - 1) {
                    Polygon carp = new Polygon();
                    carp.addPoint(0, lines[i3]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 1, lines[i3]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 1, lines[i3 + 1] - 3);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 3, lines[i3 + 1]);
                    carp.addPoint(0, lines[i3 + 1]);
                    carp.addPoint(0, lines[i3]);
                    g.setColor(this.hazAlfa(fila + 2));
                    g.fillPolygon(carp);
                    g.setColor(this.darkShadow.darker());
                    g.drawPolygon(carp);
                    ++i3;
                    ++fila;
                }
            }
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        GradientPaint gradientShadow;
        Graphics2D g2D = (Graphics2D)g;
        int[] xp = null;
        int[] yp = null;
        switch (tabPlacement) {
            case 2: {
                xp = new int[]{x, x, x + w, x + w, x};
                yp = new int[]{y, y + h - 3, y + h - 3, y, y};
                gradientShadow = new GradientPaint(x, y, NimRODLookAndFeel.brillo, x, y + h, NimRODLookAndFeel.sombra);
                break;
            }
            case 4: {
                xp = new int[]{x, x, x + w - 2, x + w - 2, x};
                yp = new int[]{y, y + h - 3, y + h - 3, y, y};
                gradientShadow = new GradientPaint(x, y, NimRODLookAndFeel.brillo, x, y + h, NimRODLookAndFeel.sombra);
                break;
            }
            case 3: {
                xp = new int[]{x, x, x + 3, x + w - this.inclTab - 6, x + w - this.inclTab - 2, x + w - this.inclTab, x + w - 3, x};
                yp = new int[]{y, y + h - 3, y + h, y + h, y + h - 1, y + h - 3, y, y};
                gradientShadow = new GradientPaint(x, y, NimRODLookAndFeel.brillo, x, y + h, NimRODLookAndFeel.sombra);
                break;
            }
            default: {
                xp = new int[]{x, x, x + 3, x + w - this.inclTab - 6, x + w - this.inclTab - 2, x + w - this.inclTab, x + w, x};
                yp = new int[]{y + h, y + 3, y, y, y + 1, y + 3, y + h, y + h};
                gradientShadow = new GradientPaint(x, y, NimRODLookAndFeel.brillo, x, y + h, NimRODLookAndFeel.sombra);
            }
        }
        this.shape = new Polygon(xp, yp, xp.length);
        if (isSelected) {
            g2D.setColor(this.selectColor);
        } else {
            g2D.setColor(this.tabPane.getBackgroundAt(tabIndex));
        }
        g2D.fill(this.shape);
        if (this.runCount > 1) {
            g2D.setColor(this.hazAlfa(this.getRunForTab(this.tabPane.getTabCount(), tabIndex) - 1));
            g2D.fill(this.shape);
        }
        if (tabIndex == this.rollover) {
            g2D.setColor(NimRODLookAndFeel.getRolloverColor());
            g2D.fill(this.shape);
        }
        g2D.setPaint(gradientShadow);
        g2D.fill(this.shape);
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return 8 + this.inclTab + super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        }
        return this.anchoFocoH + super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.hasFocus() && isSelected) {
            g.setColor(UIManager.getColor("ScrollBar.thumbShadow"));
            g.drawPolygon(this.shape);
        }
    }

    protected Color hazAlfa(int fila) {
        int alfa = 0;
        if (fila >= 0) {
            alfa = 50 + (fila > 7 ? 70 : 10 * fila);
        }
        return new Color(0, 0, 0, alfa);
    }

    public class MiML
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseExited(MouseEvent e) {
            NimRODTabbedPaneUI.this.rollover = -1;
            NimRODTabbedPaneUI.this.tabPane.repaint();
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            NimRODTabbedPaneUI.this.rollover = NimRODTabbedPaneUI.this.tabForCoordinate(NimRODTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (NimRODTabbedPaneUI.this.rollover == -1 && NimRODTabbedPaneUI.this.antRollover == NimRODTabbedPaneUI.this.rollover) {
                return;
            }
            NimRODTabbedPaneUI.this.tabPane.repaint();
            NimRODTabbedPaneUI.this.antRollover = NimRODTabbedPaneUI.this.rollover;
        }
    }
}

