/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import net.beeger.squareness.SquarenessLookAndFeel;
import net.beeger.squareness.util.SquarenessBorderFactory;

public class SquarenessScrollBarUI
extends BasicScrollBarUI {
    private ScrollBarMouseMotionListener _scrollBarMouseMotionListener;
    private ScrollBarMouseListener _scrollBarMouseListener;

    public static ComponentUI createUI(JComponent component) {
        return new SquarenessScrollBarUI();
    }

    public void installUI(JComponent component) {
        component.putClientProperty("SquarenessRollover", Boolean.FALSE);
        component.putClientProperty("SquarenessScrollBarThumbPressed", Boolean.FALSE);
        component.putClientProperty("SquarenessScrollBarTrackPressed", Boolean.FALSE);
        this._scrollBarMouseMotionListener = new ScrollBarMouseMotionListener();
        this._scrollBarMouseListener = new ScrollBarMouseListener();
        component.addMouseMotionListener(this._scrollBarMouseMotionListener);
        component.addMouseListener(this._scrollBarMouseListener);
        super.installUI(component);
    }

    public void uninstallUI(JComponent component) {
        component.removeMouseMotionListener(this._scrollBarMouseMotionListener);
        component.removeMouseListener(this._scrollBarMouseListener);
        super.uninstallUI(component);
    }

    protected void paintThumb(Graphics graphics, JComponent component, Rectangle thumbBounds) {
        Color oldColor = graphics.getColor();
        boolean isRollover = this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.TRUE);
        boolean isPressed = this.scrollbar.getClientProperty("SquarenessScrollBarThumbPressed").equals(Boolean.TRUE);
        ColorUIResource thumbFillColor = isRollover || isPressed ? SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor();
        graphics.setColor(thumbFillColor);
        graphics.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width - 1, thumbBounds.height - 1);
        if (isPressed) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
            graphics.fillRect(thumbBounds.x + 1, thumbBounds.y + 1, thumbBounds.width - 2, 2);
            graphics.fillRect(thumbBounds.x + 1, thumbBounds.y + 1, 2, thumbBounds.height - 2);
        }
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        graphics.drawRect(thumbBounds.x, thumbBounds.y, thumbBounds.width - 1, thumbBounds.height - 1);
        this.paintGripper(graphics, thumbBounds, thumbFillColor, isPressed, isRollover);
        graphics.setColor(oldColor);
    }

    private void paintGripper(Graphics graphics, Rectangle thumbBounds, Color thumbFillColor, boolean isThumbPressed, boolean isThumbRollover) {
        boolean isHorizontal;
        boolean bl = isHorizontal = this.scrollbar.getOrientation() == 0;
        if (isHorizontal && thumbBounds.getWidth() > 16.0 || !isHorizontal && thumbBounds.getHeight() > 16.0) {
            int translatedX = 0;
            int translatedY = 0;
            Color shadow = thumbFillColor.darker();
            Color highlight = thumbFillColor.brighter();
            translatedX = thumbBounds.x + (thumbBounds.width >> 1) - 3;
            translatedY = thumbBounds.y + (thumbBounds.height >> 1) - 3;
            graphics.translate(translatedX, translatedY);
            if (isHorizontal) {
                if (isThumbPressed || isThumbRollover) {
                    graphics.translate(0, 1);
                    graphics.setColor(shadow);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.setColor(highlight);
                    graphics.translate(1, 1);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.translate(-1, -1);
                    graphics.translate(0, -1);
                } else {
                    graphics.setColor(highlight);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.setColor(shadow);
                    graphics.translate(1, 1);
                    this.paintHorizontalGripperPart(graphics);
                    graphics.translate(-1, -1);
                }
            } else if (isThumbPressed || isThumbRollover) {
                graphics.translate(1, 0);
                graphics.setColor(shadow);
                this.paintVerticalGripperPart(graphics);
                graphics.setColor(highlight);
                graphics.translate(1, 1);
                this.paintVerticalGripperPart(graphics);
                graphics.translate(-1, -1);
                graphics.translate(-1, 0);
            } else {
                graphics.setColor(highlight);
                this.paintVerticalGripperPart(graphics);
                graphics.setColor(shadow);
                graphics.translate(1, 1);
                this.paintVerticalGripperPart(graphics);
                graphics.translate(-1, -1);
            }
            graphics.translate(-translatedX, -translatedY);
        }
    }

    protected void paintVerticalGripperPart(Graphics graphics) {
        this.paintVerticalGripperPartColumn(graphics);
        graphics.translate(4, 0);
        this.paintVerticalGripperPartColumn(graphics);
        graphics.translate(-4, 0);
    }

    protected void paintVerticalGripperPartColumn(Graphics graphics) {
        graphics.drawLine(0, 0, 1, 0);
        graphics.drawLine(0, 2, 1, 2);
        graphics.drawLine(0, 4, 1, 4);
        graphics.drawLine(0, 6, 1, 6);
    }

    protected void paintHorizontalGripperPart(Graphics graphics) {
        this.paintHorizontalGripperPartRow(graphics);
        graphics.translate(0, 4);
        this.paintHorizontalGripperPartRow(graphics);
        graphics.translate(0, -4);
    }

    protected void paintHorizontalGripperPartRow(Graphics graphics) {
        graphics.drawLine(0, 0, 0, 1);
        graphics.drawLine(2, 0, 2, 1);
        graphics.drawLine(4, 0, 4, 1);
        graphics.drawLine(6, 0, 6, 1);
    }

    protected void paintTrack(Graphics graphics, JComponent component, Rectangle trackBounds) {
        Color oldColor = graphics.getColor();
        if (Boolean.TRUE.equals(this.scrollbar.getClientProperty("SquarenessScrollBarTrackPressed"))) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getPressedScrollBarTrackBackgroundColor());
        } else {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        }
        graphics.fillRect(trackBounds.x, trackBounds.y, trackBounds.width - 1, trackBounds.height - 1);
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        if (this.scrollbar.getOrientation() == 1) {
            graphics.drawLine(trackBounds.x, 0, trackBounds.x, this.scrollbar.getHeight() - 1);
            graphics.drawLine(trackBounds.width - 1, 0, trackBounds.width - 1, this.scrollbar.getHeight() - 1);
        } else {
            graphics.drawLine(0, trackBounds.y, this.scrollbar.getWidth() - 1, trackBounds.y);
            graphics.drawLine(0, trackBounds.height - 1, this.scrollbar.getWidth() - 1, trackBounds.height - 1);
        }
        graphics.setColor(oldColor);
    }

    protected JButton createIncreaseButton(int orientation) {
        UIDefaults defaults = UIManager.getDefaults();
        int scrollbarWidth = defaults.getInt("ScrollBar.width");
        SquarenessScrollBarButton button = new SquarenessScrollBarButton();
        Dimension dimension = new Dimension(scrollbarWidth, scrollbarWidth);
        button.setPreferredSize(dimension);
        button.setMinimumSize(dimension);
        if (this.scrollbar.getOrientation() == 0) {
            button.setIcon(defaults.getIcon("scrollArrowRight"));
        } else {
            button.setIcon(defaults.getIcon("scrollArrowDown"));
        }
        button.setHorizontalAlignment(0);
        button.setVerticalAlignment(0);
        return button;
    }

    protected JButton createDecreaseButton(int orientation) {
        UIDefaults defaults = UIManager.getDefaults();
        int scrollbarWidth = defaults.getInt("ScrollBar.width");
        SquarenessScrollBarButton button = new SquarenessScrollBarButton();
        Dimension dimension = new Dimension(scrollbarWidth, scrollbarWidth);
        button.setPreferredSize(dimension);
        button.setMinimumSize(dimension);
        if (this.scrollbar.getOrientation() == 0) {
            button.setIcon(defaults.getIcon("scrollArrowLeft"));
        } else {
            button.setIcon(defaults.getIcon("scrollArrowUp"));
        }
        button.setHorizontalAlignment(0);
        button.setVerticalAlignment(0);
        return button;
    }

    private class ScrollBarMouseListener
    extends MouseAdapter {
        private ScrollBarMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle thumbBounds = SquarenessScrollBarUI.this.getThumbBounds();
            Rectangle trackBounds = SquarenessScrollBarUI.this.getTrackBounds();
            if (thumbBounds.contains(mouseEvent.getPoint()) && SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarThumbPressed").equals(Boolean.FALSE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarThumbPressed", Boolean.TRUE);
                SquarenessScrollBarUI.this.scrollbar.repaint(thumbBounds);
            } else if (trackBounds.contains(mouseEvent.getPoint()) && SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarTrackPressed").equals(Boolean.FALSE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarTrackPressed", Boolean.TRUE);
                SquarenessScrollBarUI.this.scrollbar.repaint(trackBounds);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Rectangle thumbBounds = SquarenessScrollBarUI.this.getThumbBounds();
            Rectangle trackBounds = SquarenessScrollBarUI.this.getTrackBounds();
            if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarThumbPressed").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarThumbPressed", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(thumbBounds);
            } else if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessScrollBarTrackPressed").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessScrollBarTrackPressed", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(trackBounds);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessRollover", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(SquarenessScrollBarUI.this.getThumbBounds());
            }
        }
    }

    private class ScrollBarMouseMotionListener
    extends MouseMotionAdapter {
        private ScrollBarMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Rectangle thumbBounds = SquarenessScrollBarUI.this.getThumbBounds();
            if (thumbBounds.contains(mouseEvent.getPoint())) {
                if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.FALSE)) {
                    SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessRollover", Boolean.TRUE);
                    SquarenessScrollBarUI.this.scrollbar.repaint(thumbBounds);
                }
            } else if (SquarenessScrollBarUI.this.scrollbar.getClientProperty("SquarenessRollover").equals(Boolean.TRUE)) {
                SquarenessScrollBarUI.this.scrollbar.putClientProperty("SquarenessRollover", Boolean.FALSE);
                SquarenessScrollBarUI.this.scrollbar.repaint(thumbBounds);
            }
        }
    }

    private static class SquarenessScrollBarButton
    extends JButton {
        private Border _border = SquarenessBorderFactory.getNonSpacingControlBorderWithMargin();

        private SquarenessScrollBarButton() {
        }

        public Border getBorder() {
            return this._border;
        }
    }
}

