/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceRadioButtonUI;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    private static Map<ComponentState, Icon> icons;
    private static final int DIMENSION = 15;

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceCheckBoxUI((JToggleButton)b);
    }

    private SubstanceCheckBoxUI(JToggleButton button) {
        super(button);
        button.setRolloverEnabled(true);
    }

    static synchronized void reset() {
        icons = new HashMap<ComponentState, Icon>();
        for (ComponentState state : ComponentState.values()) {
            icons.put(state, new ImageIcon(SubstanceImageCreator.getCheckBox(15, state)));
        }
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        return icons.get((Object)ComponentState.getState(model, this.button));
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceCheckBox: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }

    static {
        SubstanceCheckBoxUI.reset();
    }
}

