/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceComboBoxButton;
import org.jvnet.substance.SubstanceComboBoxRenderer;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    public static final Map<ColorSchemeEnum, Icon> COMBO_ARROWS = new HashMap<ColorSchemeEnum, Icon>();
    protected ComboBoxPropertyChangeHandler changeHandler;

    public static void updateArrows() {
        COMBO_ARROWS.put(ColorSchemeEnum.USER_DEFINED, SubstanceImageCreator.getArrowIcon(9, 6, 5, ColorSchemeEnum.USER_DEFINED));
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceComboBoxUI();
    }

    protected JButton createArrowButton() {
        ColorSchemeEnum colorSchemeEnum = this.comboBox.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : ColorSchemeEnum.METALLIC;
        return new SubstanceComboBoxButton(this.comboBox, COMBO_ARROWS.get((Object)colorSchemeEnum));
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    protected void installListeners() {
        super.installListeners();
        this.changeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.changeHandler);
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.changeHandler);
        this.changeHandler = null;
        super.uninstallListeners();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension superRes = super.getPreferredSize(c);
        Dimension res = new Dimension((int)superRes.getWidth() + 4, (int)superRes.getHeight() + 4);
        return res;
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceComboBoxUI: \n");
        sb.append("\t" + COMBO_ARROWS.size() + " arrows");
        return sb.toString();
    }

    static {
        for (ColorSchemeEnum colorSchemeEnum : ColorSchemeEnum.values()) {
            COMBO_ARROWS.put(colorSchemeEnum, SubstanceImageCreator.getArrowIcon(9, 6, 5, colorSchemeEnum));
        }
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("enabled") && SubstanceComboBoxUI.this.arrowButton != null) {
                ColorSchemeEnum colorSchemeEnum = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : ColorSchemeEnum.METALLIC;
                SubstanceComboBoxUI.this.arrowButton.setIcon(COMBO_ARROWS.get((Object)colorSchemeEnum));
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            cb.setBorder(new SubstanceBorder());
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width") - 1;
            int buttonHeight = height - (insets.top + insets.bottom);
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

