/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.MemoryAnalyzer;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.ColorSchemeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubstanceImageCreator {
    public static final int ICON_DIMENSION = 16;
    public static final int ARROW_WIDTH = 9;
    public static final int ARROW_HEIGHT = 6;
    public static final int DRAG_BUMP_DIAMETER = 2;
    private static final int[] crayonColors = new int[]{0x800000, 0x808000, 32768, 32896, 128, 0x800080, 0x7F7F7F, 0x808080, 0x804000, 0x408000, 32832, 16512, 0x400080, 0x800040, 0x666666, 0x999999, 0xFF0000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF, 0x4C4C4C, 0xB3B3B3, 0xFF8000, 0x80FF00, 65408, 33023, 0x8000FF, 0xFF0080, 0x333333, 0xCCCCCC, 0xFF6666, 0xFFFF66, 0x66FF66, 0x66FFFF, 0x6666FF, 0xFF66FF, 0x191919, 0xE6E6E6, 0xFFCC66, 0xCCFF66, 0x66FFCC, 0x66CCFF, 0xCC66FF, 0xFF6FCF, 0, 0xFFFFFF};

    public static BufferedImage getBlankImage(int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            try {
                throw new Exception();
            }
            catch (Exception exc) {
                StringBuffer sb = new StringBuffer();
                StackTraceElement[] stack = exc.getStackTrace();
                int count = 0;
                for (StackTraceElement stackEntry : stack) {
                    if (count++ > 8) break;
                    sb.append(stackEntry.getClassName() + ".");
                    sb.append(stackEntry.getMethodName() + " [");
                    sb.append(stackEntry.getLineNumber() + "]");
                    sb.append("\n");
                }
                MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.setComposite(AlphaComposite.Src);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return image;
    }

    private static Color getInterpolatedColor(Color color1, Color color2, double color1Likeness) {
        int lr = color1.getRed();
        int lg = color1.getGreen();
        int lb = color1.getBlue();
        int dr = color2.getRed();
        int dg = color2.getGreen();
        int db = color2.getBlue();
        int r = (int)(color1Likeness * (double)lr + (1.0 - color1Likeness) * (double)dr);
        int g = (int)(color1Likeness * (double)lg + (1.0 - color1Likeness) * (double)dg);
        int b = (int)(color1Likeness * (double)lb + (1.0 - color1Likeness) * (double)db);
        r = Math.min(255, r);
        g = Math.min(255, g);
        b = Math.min(255, b);
        r = Math.max(0, r);
        g = Math.max(0, g);
        b = Math.max(0, b);
        return new Color(r, g, b);
    }

    public static void paintBorder(Graphics g, int x, int y, int width, int height, ColorSchemeEnum borderSchemeEnum) {
        ColorScheme borderScheme = borderSchemeEnum.getColorScheme();
        Color topBorderColor = borderSchemeEnum.isDark() ? borderScheme.getExtraLightColor().brighter().brighter() : borderScheme.getDarkColor();
        Color bottomBorderColor = borderSchemeEnum.isDark() ? borderScheme.getUltraLightColor() : borderScheme.getMidColor();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(x, y, topBorderColor, x, y + height - 1, bottomBorderColor);
        graphics.setPaint(gradient);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics.drawLine(x, y, x + width - 1, y);
        graphics.drawLine(x, y, x, y + height - 1);
        graphics.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        graphics.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        graphics.dispose();
    }

    private static BufferedImage getCheckMark(int dimension, boolean isEnabled, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage result = new BufferedImage(dimension, dimension, 2);
        for (int col = 0; col < dimension; ++col) {
            for (int row = 0; row < dimension; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
        BasicStroke stroke = new BasicStroke(0.15f * (float)dimension, 1, 1);
        graphics.setStroke(stroke);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.25f * (float)dimension, 0.5f * (float)dimension);
        path.quadTo(0.4f * (float)dimension, 0.6f * (float)dimension, 0.5f * (float)dimension, 0.8f * (float)dimension);
        path.quadTo(0.55f * (float)dimension, 0.5f * (float)dimension, 0.85f * (float)dimension, 0.0f);
        graphics.draw(path);
        return result;
    }

    public static Icon getArrowIcon(int width, int height, int direction, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage downArrowImage = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)downArrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
        BasicStroke stroke = new BasicStroke(2.0f, 0, 0);
        graphics.setStroke(stroke);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(0.5f * (float)(width - 1), height - 2);
        gp.lineTo(width - 1, 0.0f);
        graphics.draw(gp);
        int quadrantCounterClockwise = 0;
        switch (direction) {
            case 1: {
                quadrantCounterClockwise = 2;
                break;
            }
            case 7: {
                quadrantCounterClockwise = 1;
                break;
            }
            case 5: {
                quadrantCounterClockwise = 0;
                break;
            }
            case 3: {
                quadrantCounterClockwise = 3;
            }
        }
        BufferedImage arrowImage = SubstanceImageCreator.getRotated(downArrowImage, quadrantCounterClockwise);
        return new ImageIcon(arrowImage);
    }

    public static Icon getDoubleArrowIcon(int width, int height, int direction, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage downArrowImage = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)downArrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
        BasicStroke stroke = new BasicStroke(1.5f, 0, 0);
        graphics.setStroke(stroke);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.lineTo(0.5f * (float)(width - 1), height - 4);
        gp.lineTo(width - 1, 0.0f);
        graphics.draw(gp);
        GeneralPath gp2 = new GeneralPath();
        gp2.moveTo(0.0f, 3.0f);
        gp2.lineTo(0.5f * (float)(width - 1), height - 1);
        gp2.lineTo(width - 1, 3.0f);
        graphics.draw(gp2);
        int quadrantCounterClockwise = 0;
        switch (direction) {
            case 1: {
                quadrantCounterClockwise = 2;
                break;
            }
            case 7: {
                quadrantCounterClockwise = 1;
                break;
            }
            case 5: {
                quadrantCounterClockwise = 0;
                break;
            }
            case 3: {
                quadrantCounterClockwise = 3;
            }
        }
        BufferedImage arrowImage = SubstanceImageCreator.getRotated(downArrowImage, quadrantCounterClockwise);
        return new ImageIcon(arrowImage);
    }

    public static BufferedImage getRotated(BufferedImage bi, int quadrantClockwise) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        if ((quadrantClockwise %= 4) == 1 || quadrantClockwise == 3) {
            width = bi.getHeight();
            height = bi.getWidth();
        }
        BufferedImage biRot = SubstanceImageCreator.getBlankImage(width, height);
        switch (quadrantClockwise) {
            case 0: {
                return bi;
            }
            case 1: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(row, width - col - 1));
                    }
                }
                return biRot;
            }
            case 2: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(width - col - 1, height - row - 1));
                    }
                }
                return biRot;
            }
            case 3: {
                for (int col = 0; col < width; ++col) {
                    for (int row = 0; row < height; ++row) {
                        biRot.setRGB(col, row, bi.getRGB(height - row - 1, col));
                    }
                }
                return biRot;
            }
        }
        return null;
    }

    public static Icon toGreyscale(Icon icon) {
        int row;
        int col;
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        icon.paintIcon(null, result.getGraphics(), 0, 0);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int color = result.getRGB(col, row);
                int transp = color >>> 24 & 0xFF;
                int oldR = color >>> 16 & 0xFF;
                int oldG = color >>> 8 & 0xFF;
                int oldB = color >>> 0 & 0xFF;
                int newComp = (222 * oldR + 707 * oldG + 71 * oldB) / 1000;
                int newColor = transp << 24 | newComp << 16 | newComp << 8 | newComp;
                result.setRGB(col, row, newColor);
            }
        }
        return new ImageIcon(result);
    }

    public static Icon makeTransparent(Icon icon, double alpha) {
        int row;
        int col;
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                result.setRGB(col, row, 0);
            }
        }
        icon.paintIcon(null, result.getGraphics(), 0, 0);
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int color = result.getRGB(col, row);
                int transp = (int)(alpha * (double)(color >>> 24 & 0xFF));
                int r = color >>> 16 & 0xFF;
                int g = color >>> 8 & 0xFF;
                int b = color >>> 0 & 0xFF;
                int newColor = transp << 24 | r << 16 | g << 8 | b;
                result.setRGB(col, row, newColor);
            }
        }
        return new ImageIcon(result);
    }

    private static int[][] getFuzzyOvalOpacity(BufferedImage origImage, int cornerRadius, Side side) {
        boolean cornerBR;
        int width = origImage.getWidth();
        int height = origImage.getHeight();
        int[][] result = new int[width][height];
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                result[col][row] = 0;
            }
        }
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.black);
        double ellipseHeight = (double)height / 2.0 - 1.0;
        double ellipseMidY = 1.0 + ellipseHeight / 1.8;
        double ellipseWidth = 0.9 * (double)width;
        if (width >= height) {
            if (ellipseMidY < (double)cornerRadius) {
                double dx = Math.sqrt(2.0 * (double)cornerRadius * ellipseMidY - ellipseMidY * ellipseMidY);
                double delta = (double)cornerRadius - dx;
                if (side != Side.LEFT) {
                    ellipseWidth -= delta;
                }
                if (side != Side.RIGHT) {
                    ellipseWidth -= delta;
                }
            }
            double ellipseTopWidth = 0.9 * (double)width;
            if (ellipseMidY < (double)cornerRadius) {
                double ellipseTopY = ellipseMidY - ellipseHeight / 2.0;
                double dx = Math.sqrt(2.0 * (double)cornerRadius * ellipseTopY - ellipseTopY * ellipseTopY);
                double delta = (double)cornerRadius - dx;
                if (side != Side.LEFT) {
                    ellipseTopWidth -= delta;
                }
                if (side != Side.RIGHT) {
                    ellipseTopWidth -= delta;
                }
            }
            double ellipseMidTopWidth = 0.9 * (double)width;
            if (ellipseMidY < (double)cornerRadius) {
                double ellipseMidTopY = ellipseMidY - ellipseHeight / 4.0;
                double dx = Math.sqrt(2.0 * (double)cornerRadius * ellipseMidTopY - ellipseMidTopY * ellipseMidTopY);
                double delta = (double)cornerRadius - dx;
                if (side != Side.LEFT) {
                    ellipseMidTopWidth -= delta;
                }
                if (side != Side.RIGHT) {
                    ellipseMidTopWidth -= delta;
                }
            }
            if (side == Side.LEFT || side == Side.RIGHT) {
                ellipseMidTopWidth = Math.min(ellipseMidTopWidth, 0.9 * ellipseTopWidth);
                ellipseTopWidth = Math.min(ellipseTopWidth, 0.8 * ellipseTopWidth);
            }
            double ellipseMidX = (double)width / 2.0;
            GeneralPath shinePath = new GeneralPath();
            shinePath.moveTo((float)(ellipseMidX - ellipseTopWidth / 2.0), (float)(ellipseMidY - ellipseHeight / 2.0));
            shinePath.lineTo((float)(ellipseMidX + ellipseTopWidth / 2.0), (float)(ellipseMidY - ellipseHeight / 2.0));
            shinePath.quadTo((float)(ellipseMidX + ellipseMidTopWidth / 1.6), (float)(ellipseMidY - ellipseHeight / 4.0), (float)(ellipseMidX + ellipseWidth / 2.0), (float)ellipseMidY);
            shinePath.quadTo((float)(ellipseMidX + ellipseMidTopWidth / 1.6), (float)(ellipseMidY + ellipseHeight / 4.0), (float)(ellipseMidX + ellipseTopWidth / 2.0), (float)(ellipseMidY + ellipseHeight / 2.0));
            shinePath.lineTo((float)(ellipseMidX - ellipseTopWidth / 2.0), (float)(ellipseMidY + ellipseHeight / 2.0));
            shinePath.quadTo((float)(ellipseMidX - ellipseMidTopWidth / 1.6), (float)(ellipseMidY + ellipseHeight / 4.0), (float)(ellipseMidX - ellipseWidth / 2.0), (float)ellipseMidY);
            shinePath.quadTo((float)(ellipseMidX - ellipseMidTopWidth / 1.6), (float)(ellipseMidY - ellipseHeight / 4.0), (float)(ellipseMidX - ellipseTopWidth / 2.0), (float)(ellipseMidY - ellipseHeight / 2.0));
            graphics.fill(shinePath);
        } else {
            double ellipseSideHeight = ellipseHeight / 2.0;
            double ellipseLeftX = (double)width / 2.0 - ellipseWidth / 2.0;
            if (ellipseLeftX < (double)cornerRadius) {
                double dy = Math.sqrt(2.0 * (double)cornerRadius * ellipseLeftX - ellipseLeftX * ellipseLeftX);
                double delta = (double)cornerRadius - dy;
                if (side != Side.TOP) {
                    ellipseSideHeight -= delta;
                }
            }
            double ellipseMidSideHeight = ellipseHeight / 2.0;
            double ellipseMidLeftX = (double)width / 2.0 - ellipseWidth / 2.5;
            if (ellipseMidLeftX < (double)cornerRadius) {
                double dy = Math.sqrt(2.0 * (double)cornerRadius * ellipseMidLeftX - ellipseMidLeftX * ellipseMidLeftX);
                double delta = (double)cornerRadius - dy;
                if (side != Side.TOP) {
                    ellipseMidSideHeight -= delta;
                }
            }
            if (side == Side.TOP) {
                ellipseMidSideHeight = Math.min(ellipseMidSideHeight, 0.45 * ellipseHeight);
                ellipseSideHeight = Math.min(ellipseSideHeight, 0.4 * ellipseHeight);
            }
            double ellipseMidX = (double)width / 2.0;
            GeneralPath shinePath = new GeneralPath();
            shinePath.moveTo((float)(ellipseMidX - ellipseWidth / 2.0), (float)(ellipseMidY + ellipseSideHeight / 2.0));
            shinePath.lineTo((float)(ellipseMidX - ellipseWidth / 2.0), (float)(ellipseMidY - ellipseSideHeight / 2.0));
            shinePath.quadTo((float)(ellipseMidX - ellipseWidth / 2.5), (float)(ellipseMidY - ellipseMidSideHeight / 0.8), (float)ellipseMidX, (float)(ellipseMidY - ellipseHeight / 2.0));
            shinePath.quadTo((float)(ellipseMidX + ellipseWidth / 2.5), (float)(ellipseMidY - ellipseMidSideHeight / 0.8), (float)(ellipseMidX + ellipseWidth / 2.0), (float)(ellipseMidY - ellipseSideHeight / 2.0));
            shinePath.lineTo((float)(ellipseMidX + ellipseWidth / 2.0), (float)(ellipseMidY + ellipseSideHeight / 2.0));
            shinePath.quadTo((float)(ellipseMidX + ellipseWidth / 2.5), (float)(ellipseMidY + ellipseMidSideHeight / 0.8), (float)ellipseMidX, (float)(ellipseMidY + ellipseHeight / 2.0));
            shinePath.quadTo((float)(ellipseMidX + ellipseWidth / 2.5), (float)(ellipseMidY + ellipseMidSideHeight / 0.8), (float)(ellipseMidX + ellipseWidth / 2.0), (float)(ellipseMidY + ellipseSideHeight / 2.0));
            graphics.fill(shinePath);
        }
        int[][] temporary = new int[width][height];
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                int transp;
                int color = image.getRGB(col, row);
                temporary[col][row] = transp = color >>> 24 & 0xFF;
            }
        }
        int minFuzziness = 1 + height / 50;
        int maxFuzziness = width >= height ? height / 5 : height / 20;
        for (int row = 0; row < height; ++row) {
            int fuzziness = minFuzziness + (maxFuzziness - minFuzziness) * row / height;
            int sy = Math.max(0, row - fuzziness);
            int ey = Math.min(height - 1, row + fuzziness);
            for (int col = 0; col < width; ++col) {
                int pixCount = 0;
                int transpSum = 0;
                int sx = Math.max(0, col - fuzziness);
                int ex = Math.min(width - 1, col + fuzziness);
                for (int colPix = sx; colPix <= ex; ++colPix) {
                    for (int rowPix = sy; rowPix <= ey; ++rowPix) {
                        ++pixCount;
                        transpSum += temporary[colPix][rowPix];
                    }
                }
                int origColor = origImage.getRGB(col, row);
                int origTransp = origColor >>> 24 & 0xFF;
                result[col][row] = transpSum * origTransp / (255 * pixCount);
            }
        }
        GeneralPath perim = new GeneralPath();
        boolean cornerTL = side == Side.LEFT || side == Side.TOP;
        boolean cornerTR = side == Side.RIGHT || side == Side.TOP;
        boolean cornerBL = side == Side.LEFT || side == Side.BOTTOM;
        boolean bl = cornerBR = side == Side.RIGHT || side == Side.BOTTOM;
        if (cornerTL) {
            perim.moveTo(0.0f, 0.0f);
        } else {
            perim.moveTo(0.0f, cornerRadius);
            perim.quadTo(0.0f, 0.0f, cornerRadius, 0.0f);
        }
        if (cornerTR) {
            perim.lineTo(width - 1, 0.0f);
        } else {
            perim.lineTo(width - 1 - cornerRadius, 0.0f);
            perim.quadTo(width - 1, 0.0f, width - 1, cornerRadius);
        }
        if (cornerBR) {
            perim.lineTo(width - 1, height - 1);
        } else {
            perim.lineTo(width - 1, height - 1 - cornerRadius);
            perim.quadTo(width - 1, height - 1, width - 1 - cornerRadius, height - 1);
        }
        if (cornerBL) {
            perim.lineTo(0.0f, height - 1);
        } else {
            perim.lineTo(cornerRadius, height - 1);
            perim.quadTo(0.0f, height - 1, 0.0f, height - 1 - cornerRadius);
        }
        if (cornerTR) {
            perim.lineTo(0.0f, 0.0f);
        } else {
            perim.lineTo(0.0f, cornerRadius);
        }
        BufferedImage tempImage = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D tempGraphics = (Graphics2D)tempImage.getGraphics().create();
        tempGraphics.setColor(Color.black);
        tempGraphics.fill(perim);
        tempGraphics.draw(perim);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int transp = tempImage.getRGB(col, row) >>> 24 & 0xFF;
                result[col][row] = transp * result[col][row] / 255;
            }
        }
        tempGraphics.dispose();
        graphics.dispose();
        return result;
    }

    public static BufferedImage getRoundedBackground(int width, int height, int cornerRadius, ColorSchemeEnum colorSchemeEnum, int cyclePos, Side side) {
        return SubstanceImageCreator.getRoundedBackground(width, height, cornerRadius, colorSchemeEnum, colorSchemeEnum, cyclePos, side, false, true);
    }

    public static BufferedImage getRadioButton(int dimension, ComponentState componentState) {
        return SubstanceImageCreator.getRadioButton(dimension, componentState, 0);
    }

    public static BufferedImage getRadioButton(int dimension, ComponentState componentState, int offsetX) {
        return SubstanceImageCreator.getRadioButton(dimension, componentState, offsetX, SubstanceLookAndFeel.getColorScheme());
    }

    public static BufferedImage getRadioButton(int dimension, ComponentState componentState, int offsetX, ColorSchemeEnum mainColorSchemeEnum) {
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        int cyclePos = componentState.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = mainColorSchemeEnum;
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        BufferedImage background = SubstanceImageCreator.getRoundedBackground(dimension, dimension, dimension / 2, colorSchemeEnum, colorSchemeEnum, cyclePos, null, false, true);
        BufferedImage offBackground = SubstanceImageCreator.getBlankImage(dimension + offsetX, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.drawImage((Image)background, offsetX, 0, null);
        if (componentState.isSelected()) {
            int rc = dimension / 2;
            Color markColor = colorSchemeEnum.getColorScheme().getForegroundColor();
            graphics.translate(offsetX, 0);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(markColor);
            graphics.fillOval(rc - dimension / 5, rc - dimension / 5, 2 * dimension / 5, 2 * dimension / 5);
            graphics.translate(-offsetX, 0);
        }
        return offBackground;
    }

    public static BufferedImage getCheckBox(int dimension, ComponentState componentState) {
        return SubstanceImageCreator.getCheckBox(dimension, componentState, SubstanceLookAndFeel.getColorScheme());
    }

    public static BufferedImage getCheckBox(int dimension, ComponentState componentState, ColorSchemeEnum mainColorSchemeEnum) {
        int offset = 2;
        int cornerRadius = 2;
        if (dimension <= 10) {
            offset = 1;
            cornerRadius = 2;
        }
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        int cyclePos = componentState.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = mainColorSchemeEnum;
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        BufferedImage background = SubstanceImageCreator.getRoundedBackground(dimension - offset, dimension - offset, cornerRadius, colorSchemeEnum, colorSchemeEnum, cyclePos, null, false, true);
        BufferedImage offBackground = SubstanceImageCreator.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.drawImage((Image)background, offset, offset, null);
        if (componentState.isSelected()) {
            BufferedImage checkMark = SubstanceImageCreator.getCheckMark(dimension - offset, componentState.isEnabled(), colorSchemeEnum);
            graphics.drawImage((Image)checkMark, offset, 0, null);
        }
        return offBackground;
    }

    public static BufferedImage getRoundedBackground(int width, int height, int cornerRadius, ColorSchemeEnum colorSchemeEnum, int cyclePos, Side side, boolean isSideOpen) {
        return SubstanceImageCreator.getRoundedBackground(width, height, cornerRadius, colorSchemeEnum, colorSchemeEnum, cyclePos, side, isSideOpen, true);
    }

    public static BufferedImage getFlipRoundedButton(int width, int height, int cornerRadius, ColorSchemeEnum colorSchemeEnum, int cyclePos, Side side, boolean isSideOpen) {
        BufferedImage bi = SubstanceImageCreator.getRoundedBackground(height, width, cornerRadius, colorSchemeEnum, cyclePos, side.getAdjacentSide(), isSideOpen);
        return SubstanceImageCreator.getRotated(bi, 3);
    }

    public static BufferedImage getCompositeRoundedBackground(int width, int height, int cornerRadius, ComponentState compDecrState, ComponentState compIncrState, boolean flipSides) {
        return SubstanceImageCreator.getCompositeRoundedBackground(SubstanceLookAndFeel.getColorScheme(), width, height, cornerRadius, compDecrState, compIncrState, flipSides);
    }

    public static BufferedImage getCompositeRoundedBackground(ColorSchemeEnum colorSchemeEnum, int width, int height, int cornerRadius, ComponentState compDecrState, ComponentState compIncrState, boolean flipSides) {
        ComponentState.ColorSchemeKind decrKind = compDecrState.getColorSchemeKind();
        int decrCyclePos = compDecrState.getCycleCount();
        ColorSchemeEnum decrColorSchemeEnum = null;
        switch (decrKind) {
            case CURRENT: {
                decrColorSchemeEnum = colorSchemeEnum;
                break;
            }
            case REGULAR: {
                decrColorSchemeEnum = colorSchemeEnum.getMetallic();
                break;
            }
            case DISABLED: {
                decrColorSchemeEnum = colorSchemeEnum.getGray();
            }
        }
        BufferedImage decrLayer = SubstanceImageCreator.getRoundedBackground(width, height, 0, decrColorSchemeEnum, decrColorSchemeEnum, decrCyclePos, flipSides ? Side.RIGHT : Side.LEFT, true, false);
        ComponentState.ColorSchemeKind incrKind = compIncrState.getColorSchemeKind();
        int incrCyclePos = compIncrState.getCycleCount();
        ColorSchemeEnum incrColorSchemeEnum = null;
        switch (incrKind) {
            case CURRENT: {
                incrColorSchemeEnum = colorSchemeEnum;
                break;
            }
            case REGULAR: {
                incrColorSchemeEnum = colorSchemeEnum.getMetallic();
                break;
            }
            case DISABLED: {
                incrColorSchemeEnum = colorSchemeEnum.getGray();
            }
        }
        BufferedImage incrLayer = SubstanceImageCreator.getRoundedBackground(width, height, 0, incrColorSchemeEnum, incrColorSchemeEnum, incrCyclePos, flipSides ? Side.LEFT : Side.RIGHT, true, false);
        BufferedImage mainLayer = SubstanceImageCreator.getRoundedBackground(width, height, cornerRadius, colorSchemeEnum.getGray(), colorSchemeEnum.getGray(), 0, null, false, true);
        BufferedImage result = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        if (!flipSides) {
            graphics.drawImage(decrLayer, 0, 0, width / 2, height, 0, 0, width / 2, height, null);
            graphics.drawImage(incrLayer, width / 2, 0, width, height, width / 2, 0, width, height, null);
        } else {
            graphics.drawImage(incrLayer, 0, 0, width / 2, height, 0, 0, width / 2, height, null);
            graphics.drawImage(decrLayer, width / 2, 0, width, height, width / 2, 0, width, height, null);
        }
        graphics.drawImage((Image)mainLayer, 0, 0, null);
        return result;
    }

    public static BufferedImage getRoundedBackground(int width, int height, int cornerRadius, ColorSchemeEnum borderSchemeEnum, ColorSchemeEnum fillSchemeEnum, int cyclePos, Side side, boolean isSideOpen, boolean hasShine) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean hasBorder = borderSchemeEnum != null;
        ColorScheme borderScheme = hasBorder ? borderSchemeEnum.getColorScheme() : null;
        ColorScheme fillScheme = fillSchemeEnum.getColorScheme();
        Color topBorderColor = hasBorder ? borderScheme.getUltraDarkColor() : null;
        Color midBorderColor = hasBorder ? borderScheme.getDarkColor() : null;
        Color bottomBorderColor = hasBorder ? borderScheme.getMidColor() : null;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getDarkColor(), fillScheme.getLightColor(), cycleCoef);
        Color midFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getMidColor(), fillScheme.getLightColor(), cycleCoef);
        Color bottomFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), fillScheme.getExtraLightColor(), cycleCoef);
        Color topShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), fillScheme.getExtraLightColor(), cycleCoef);
        Color bottomShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getLightColor(), fillScheme.getUltraLightColor(), cycleCoef);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, topFillColor, 0.0f, height / 2, midFillColor);
        graphics.setPaint(gradient);
        int vStripeLeft = side == Side.LEFT ? 0 : cornerRadius;
        int vStripeRight = side == Side.RIGHT ? width : width - 1 - cornerRadius;
        int vStripeWidth = vStripeRight - vStripeLeft + 1;
        int hStripeTop = side == Side.TOP ? 0 : cornerRadius;
        int hStripeBottom = side == Side.BOTTOM ? height : height - cornerRadius;
        int hStripeHeight = hStripeBottom - hStripeTop;
        graphics.fillRect(0, hStripeTop, width, height / 2 - hStripeTop);
        graphics.fillRect(vStripeLeft, 0, vStripeWidth, height / 2);
        if (side != Side.TOP && side != Side.LEFT) {
            graphics.fillArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
        }
        if (side != Side.TOP && side != Side.RIGHT) {
            graphics.fillArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
        }
        GradientPaint gradient2 = new GradientPaint(0.0f, height / 2, midFillColor, 0.0f, height - 2, bottomFillColor);
        graphics.setPaint(gradient2);
        graphics.fillRect(0, height / 2, width, hStripeBottom - height / 2);
        graphics.fillRect(vStripeLeft, height / 2, vStripeWidth, 1 + height / 2);
        if (side != Side.BOTTOM && side != Side.LEFT) {
            graphics.fillArc(0, height - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 180, 90);
        }
        if (side != Side.BOTTOM && side != Side.RIGHT) {
            graphics.fillArc(width - 1 - 2 * cornerRadius, height - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 270, 90);
        }
        if (hasShine) {
            int tsr = topShineColor.getRed();
            int tsg = topShineColor.getGreen();
            int tsb = topShineColor.getBlue();
            int bsr = bottomShineColor.getRed();
            int bsg = bottomShineColor.getGreen();
            int bsb = bottomShineColor.getBlue();
            int[][] fuzzyOval = SubstanceImageCreator.getFuzzyOvalOpacity(image, cornerRadius, side);
            int row = 0;
            while ((double)row < (double)height / 2.4) {
                double coef = Math.min(1.0, (double)row / ((double)height / 2.4));
                int sr = (int)((double)tsr + coef * (double)(bsr - tsr));
                int sg = (int)((double)tsg + coef * (double)(bsg - tsg));
                int sb = (int)((double)tsb + coef * (double)(bsb - tsb));
                for (int col = 0; col < width; ++col) {
                    int transp = fuzzyOval[col][row];
                    if (transp == 0) continue;
                    graphics.setColor(new Color(sr, sg, sb, transp));
                    graphics.drawLine(col, row, col, row);
                }
                ++row;
            }
        }
        if (hasBorder) {
            boolean toDrawBottomSideFull;
            boolean toDrawTopSideFull;
            boolean toDrawRightSideFull;
            boolean toDrawLeftSideFull;
            GradientPaint gradient3 = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradient3);
            boolean toDrawLeftSide = side != Side.LEFT || side == Side.LEFT && !isSideOpen;
            boolean bl = toDrawLeftSideFull = side == Side.LEFT && !isSideOpen;
            if (toDrawLeftSide) {
                if (toDrawLeftSideFull) {
                    graphics.drawLine(0, 0, 0, height / 2);
                } else {
                    graphics.drawLine(0, hStripeTop, 0, hStripeTop + hStripeHeight / 2);
                }
            }
            boolean toDrawRightSide = side != Side.RIGHT || side == Side.RIGHT && !isSideOpen;
            boolean bl2 = toDrawRightSideFull = side == Side.RIGHT && !isSideOpen;
            if (toDrawRightSide) {
                if (toDrawRightSideFull) {
                    graphics.drawLine(width - 1, 0, width - 1, height / 2);
                } else {
                    graphics.drawLine(width - 1, hStripeTop, width - 1, hStripeTop + hStripeHeight / 2);
                }
            }
            boolean toDrawTopSide = side != Side.TOP || side == Side.TOP && !isSideOpen;
            boolean bl3 = toDrawTopSideFull = side == Side.TOP && !isSideOpen;
            if (toDrawTopSide) {
                if (toDrawTopSideFull) {
                    graphics.drawLine(0, 0, width, 0);
                } else {
                    graphics.drawLine(vStripeLeft, 0, vStripeRight, 0);
                }
            }
            if (side != Side.TOP && side != Side.LEFT) {
                graphics.drawArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
            }
            if (side != Side.TOP && side != Side.RIGHT) {
                graphics.drawArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
            }
            GradientPaint gradient4 = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
            graphics.setPaint(gradient4);
            if (toDrawLeftSide) {
                if (toDrawLeftSideFull) {
                    graphics.drawLine(0, height / 2, 0, height);
                } else {
                    graphics.drawLine(0, hStripeTop + hStripeHeight / 2, 0, hStripeBottom);
                }
            }
            if (toDrawRightSide) {
                if (toDrawRightSideFull) {
                    graphics.drawLine(width - 1, height / 2, width - 1, height);
                } else {
                    graphics.drawLine(width - 1, hStripeTop + hStripeHeight / 2, width - 1, hStripeBottom);
                }
            }
            boolean toDrawBottomSide = side != Side.BOTTOM || side == Side.BOTTOM && !isSideOpen;
            boolean bl4 = toDrawBottomSideFull = side == Side.BOTTOM && !isSideOpen;
            if (toDrawBottomSide) {
                if (toDrawBottomSideFull) {
                    graphics.drawLine(0, height - 1, width, height - 1);
                } else {
                    graphics.drawLine(vStripeLeft, height - 1, vStripeRight, height - 1);
                }
            }
            if (side != Side.BOTTOM && side != Side.LEFT) {
                graphics.drawArc(0, height - 1 - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 180, 90);
            }
            if (side != Side.BOTTOM && side != Side.RIGHT) {
                graphics.drawArc(width - 1 - 2 * cornerRadius, height - 1 - 2 * cornerRadius, 2 * cornerRadius, 2 * cornerRadius, 270, 90);
            }
        }
        return image;
    }

    public static BufferedImage getRoundedTriangleBackground(int width, int height, int cornerRadius, ComponentState componentState, ColorSchemeEnum mainColorSchemeEnum) {
        ComponentState.ColorSchemeKind kind = componentState.getColorSchemeKind();
        int cyclePos = componentState.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = mainColorSchemeEnum;
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean hasBorder = colorSchemeEnum != null;
        ColorScheme borderScheme = hasBorder ? colorSchemeEnum.getColorScheme() : null;
        ColorScheme fillScheme = colorSchemeEnum.getColorScheme();
        Color topBorderColor = hasBorder ? borderScheme.getUltraDarkColor() : null;
        Color midBorderColor = hasBorder ? borderScheme.getDarkColor() : null;
        Color bottomBorderColor = hasBorder ? borderScheme.getMidColor() : null;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getDarkColor(), fillScheme.getLightColor(), cycleCoef);
        Color midFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getMidColor(), fillScheme.getLightColor(), cycleCoef);
        Color bottomFillColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), Color.white, cycleCoef);
        Color topShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getUltraLightColor(), Color.white, cycleCoef);
        Color bottomShineColor = SubstanceImageCreator.getInterpolatedColor(fillScheme.getLightColor(), fillScheme.getUltraLightColor(), cycleCoef);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, topFillColor, 0.0f, height / 2, midFillColor);
        graphics.setPaint(gradient);
        int vStripeLeft = cornerRadius;
        int vStripeRight = width - 1 - cornerRadius;
        int vStripeWidth = vStripeRight - vStripeLeft + 1;
        int hStripeTop = cornerRadius;
        int hStripeBottom = height / 2;
        int hStripeHeight = hStripeBottom - hStripeTop;
        graphics.fillRect(0, hStripeTop, width, hStripeHeight);
        graphics.fillRect(vStripeLeft, 0, vStripeWidth, height / 2);
        graphics.fillArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
        graphics.fillArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
        GradientPaint gradient2 = new GradientPaint(0.0f, height / 2, midFillColor, 0.0f, height - 2, bottomFillColor);
        graphics.setPaint(gradient2);
        Polygon triangle = new Polygon();
        triangle.addPoint(0, hStripeBottom);
        triangle.addPoint(width - 1, hStripeBottom);
        triangle.addPoint((width - 1) / 2, height - 1);
        graphics.fillPolygon(triangle);
        int tsr = topShineColor.getRed();
        int tsg = topShineColor.getGreen();
        int tsb = topShineColor.getBlue();
        int bsr = bottomShineColor.getRed();
        int bsg = bottomShineColor.getGreen();
        int bsb = bottomShineColor.getBlue();
        int[][] fuzzyOval = SubstanceImageCreator.getFuzzyOvalOpacity(image, cornerRadius, null);
        int row = 0;
        while ((double)row < (double)height / 2.4) {
            double coef = Math.min(1.0, (double)row / ((double)height / 2.4));
            int sr = (int)((double)tsr + coef * (double)(bsr - tsr));
            int sg = (int)((double)tsg + coef * (double)(bsg - tsg));
            int sb = (int)((double)tsb + coef * (double)(bsb - tsb));
            for (int col = 0; col < width; ++col) {
                int transp = fuzzyOval[col][row];
                graphics.setColor(new Color(sr, sg, sb, transp));
                graphics.drawLine(col, row, col, row);
            }
            ++row;
        }
        if (hasBorder) {
            GradientPaint gradient3 = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
            graphics.setPaint(gradient3);
            graphics.drawLine(0, hStripeTop, 0, hStripeBottom - 1);
            graphics.drawLine(width - 1, hStripeTop, width - 1, hStripeBottom - 1);
            graphics.drawLine(vStripeLeft, 0, vStripeRight, 0);
            graphics.drawArc(0, 0, 2 * cornerRadius, 2 * cornerRadius, 90, 90);
            graphics.drawArc(width - 1 - 2 * cornerRadius, 0, 2 * cornerRadius, 2 * cornerRadius, 0, 90);
            GradientPaint gradient4 = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
            graphics.setPaint(gradient4);
            graphics.drawLine(0, hStripeBottom, (width - 1) / 2, height - 1);
            graphics.drawLine(width - 1, hStripeBottom, (width - 1) / 2, height - 1);
        }
        return image;
    }

    private static BufferedImage getOneLineGradient(int width, Color colorLeft, Color colorRight, Map<Integer, Color> waypoints) {
        BufferedImage image = new BufferedImage(width, 1, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        ArrayList<Integer> waypointMarkers = new ArrayList<Integer>();
        if (waypoints != null) {
            for (Integer marker : waypoints.keySet()) {
                waypointMarkers.add(marker);
            }
        }
        Collections.sort(waypointMarkers);
        int[] markers = new int[waypointMarkers.size() + 2];
        Color[] colors = new Color[waypointMarkers.size() + 2];
        markers[0] = 0;
        colors[0] = colorLeft;
        int index = 1;
        for (Integer marker : waypointMarkers) {
            markers[index] = marker;
            colors[index] = waypoints.get(marker);
            ++index;
        }
        markers[index] = width - 1;
        colors[index] = colorRight;
        for (int i = 0; i < markers.length - 1; ++i) {
            GradientPaint gradient = new GradientPaint(markers[i], 0.0f, colors[i], markers[i + 1], 0.0f, colors[i + 1]);
            graphics.setPaint(gradient);
            graphics.fillRect(markers[i], 0, markers[i + 1] - markers[i], 1);
        }
        return image;
    }

    private static void paintOneLineGradient(Graphics2D graphics, int x, int y, int dimension, boolean isVertical, Color colorLeft, Color colorRight, Map<Integer, Color> waypoints) {
        GradientPaint gradient;
        graphics.translate(x, y);
        ArrayList<Integer> waypointMarkers = new ArrayList<Integer>();
        if (waypoints != null) {
            for (Integer marker : waypoints.keySet()) {
                waypointMarkers.add(marker);
            }
        }
        Collections.sort(waypointMarkers);
        int[] markers = new int[waypointMarkers.size() + 2];
        Color[] colors = new Color[waypointMarkers.size() + 2];
        markers[0] = 0;
        colors[0] = colorLeft;
        int index = 1;
        for (Integer marker : waypointMarkers) {
            markers[index] = marker;
            colors[index] = waypoints.get(marker);
            ++index;
        }
        markers[index] = dimension - 1;
        colors[index] = colorRight;
        if (!isVertical) {
            for (int i = 0; i < markers.length - 1; ++i) {
                gradient = new GradientPaint(markers[i], 0.0f, colors[i], markers[i + 1], 0.0f, colors[i + 1]);
                graphics.setPaint(gradient);
                graphics.fillRect(markers[i], 0, markers[i + 1] - markers[i], 1);
            }
        } else {
            for (int i = 0; i < markers.length - 1; ++i) {
                gradient = new GradientPaint(0.0f, markers[i], colors[i], 0.0f, markers[i + 1], colors[i + 1]);
                graphics.setPaint(gradient);
                graphics.fillRect(0, markers[i], 1, markers[i + 1] - markers[i]);
            }
        }
        graphics.translate(-x, -y);
    }

    private static void overlayEcho(BufferedImage image, ColorSchemeEnum colorSchemeEnum, int offsetX, int offsetY) {
        int transp;
        int color;
        int row;
        int col;
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage echo = SubstanceImageCreator.getBlankImage(width, height);
        int echoColor = colorSchemeEnum.getColorScheme().getUltraLightColor().getRGB();
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                int newY;
                int newX;
                color = image.getRGB(col, row);
                transp = color >>> 24 & 0xFF;
                if (transp != 255 || (newX = col + offsetX) < 0 || newX >= width || (newY = row + offsetY) < 0 || newY >= height) continue;
                echo.setRGB(newX, newY, echoColor);
            }
        }
        for (col = 0; col < width; ++col) {
            for (row = 0; row < height; ++row) {
                color = image.getRGB(col, row);
                transp = color >>> 24 & 0xFF;
                if (transp == 255) continue;
                image.setRGB(col, row, echo.getRGB(col, row));
            }
        }
    }

    public static Icon getMinimizeIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 2;
        int end = 11;
        int size = end - start - 3;
        graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
        graphics.fillRect(start + 2, end - 2, size, 3);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static Icon getRestoreIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 2;
        int end = 11;
        int size = end - start - 3;
        graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
        graphics.drawRect(start, end - size + 1, size, size);
        graphics.drawLine(start, end - size + 2, start + size, end - size + 2);
        graphics.fillRect(end - size, start + 1, size + 1, 2);
        graphics.drawLine(end, start + 1, end, start + size + 1);
        graphics.drawLine(start + size + 2, start + size + 1, end, start + size + 1);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static Icon getMaximizeIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int start = 3;
        int end = 12;
        graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
        graphics.drawRect(start, start, end - start, end - start);
        graphics.drawLine(start, start + 1, end - start + 2, start + 1);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static Icon getCloseIcon(ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(16, 16);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int start = 4;
        int end = 15;
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        graphics.setStroke(stroke);
        graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
        graphics.drawLine(start, start, end - start, end - start);
        graphics.drawLine(start, end - start, end - start, start);
        SubstanceImageCreator.overlayEcho(image, colorSchemeEnum, 1, 1);
        return new ImageIcon(image);
    }

    public static BufferedImage getRectangularBackground(int width, int height, ColorSchemeEnum colorSchemeEnum, boolean hasDarkBorder) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
        gradColors.put((int)(0.4 * (double)height), colorScheme.getLightColor());
        gradColors.put((int)(0.5 * (double)height), colorScheme.getMidColor());
        BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorScheme.getUltraLightColor(), colorScheme.getUltraLightColor(), gradColors);
        BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
        for (int col = 0; col < width; ++col) {
            graphics.drawImage((Image)verLine, col, 0, null);
        }
        if (hasDarkBorder) {
            graphics.setColor(colorScheme.getMidColor());
            graphics.drawLine(0, 0, width, 0);
            graphics.drawLine(0, 0, 0, height);
            graphics.drawLine(0, height - 1, width, height - 1);
            graphics.drawLine(width - 1, 0, width - 1, height);
        }
        return image;
    }

    public static void paintRectangularBackground(Graphics g, int startX, int startY, int width, int height, ColorSchemeEnum colorSchemeEnum, boolean hasDarkBorder, boolean isVertical) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(startX, startY);
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        if (!isVertical) {
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.4 * (double)height), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)height), colorScheme.getMidColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorScheme.getUltraLightColor(), colorScheme.getUltraLightColor(), gradColors);
            BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
            for (int col = 0; col < width; ++col) {
                graphics.drawImage((Image)verLine, col, 0, null);
            }
        } else {
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.4 * (double)width), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)width), colorScheme.getMidColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(width, colorScheme.getUltraLightColor(), colorScheme.getUltraLightColor(), gradColors);
            for (int row = 1; row < height; ++row) {
                graphics.drawImage((Image)horLine, 0, row, null);
            }
        }
        if (hasDarkBorder) {
            graphics.setColor(colorScheme.getMidColor());
            graphics.drawLine(0, 0, width - 1, 0);
            graphics.drawLine(0, 0, 0, height - 1);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
            graphics.drawLine(width - 1, 0, width - 1, height - 1);
        }
        graphics.dispose();
    }

    public static BufferedImage getSimpleBackground(int width, int height, Color colorTop, Color colorBottom) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorTop, colorBottom, null);
        BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
        for (int col = 0; col < width; ++col) {
            graphics.drawImage((Image)verLine, col, 0, null);
        }
        return image;
    }

    public static BufferedImage getBorderedBackground(int width, int height, Color colorTop, Color colorBottom) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int offset = 3;
        BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(1 + height - 2 * offset, colorTop, colorBottom, null);
        BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
        for (int col = offset; col < width - offset; ++col) {
            graphics.drawImage((Image)verLine, col, offset, null);
        }
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorTop, 0.0f, height, colorBottom));
        graphics.drawRect(0, 0, width - 1, height - 1);
        graphics.drawRect(1, 1, width - 3, height - 3);
        return image;
    }

    public static void paintRectangularStripedBackground(Graphics g, int startX, int startY, int width, int height, ColorSchemeEnum colorSchemeEnum, BufferedImage stripeImage, int stripeOffset, boolean isVertical) {
        Graphics2D graphics = (Graphics2D)g.create(startX, startY, width, height);
        if (!isVertical) {
            ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.2 * (double)height), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)height), colorScheme.getMidColor());
            gradColors.put((int)(0.8 * (double)height), colorScheme.getLightColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(height, colorScheme.getDarkColor(), colorScheme.getDarkColor(), gradColors);
            BufferedImage verLine = SubstanceImageCreator.getRotated(horLine, 1);
            for (int col = 0; col < width; ++col) {
                graphics.drawImage((Image)verLine, col, 0, null);
            }
            if (stripeImage != null) {
                int stripeSize = stripeImage.getHeight();
                int stripeCount = width / stripeSize;
                stripeOffset %= 2 * stripeSize;
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = stripe * stripeSize + stripeOffset;
                    graphics.drawImage((Image)stripeImage, stripePos, 0, null);
                }
            }
        } else {
            ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
            HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
            gradColors.put((int)(0.2 * (double)width), colorScheme.getLightColor());
            gradColors.put((int)(0.5 * (double)width), colorScheme.getMidColor());
            gradColors.put((int)(0.8 * (double)width), colorScheme.getLightColor());
            BufferedImage horLine = SubstanceImageCreator.getOneLineGradient(width, colorScheme.getDarkColor(), colorScheme.getDarkColor(), gradColors);
            for (int row = 0; row < height; ++row) {
                graphics.drawImage((Image)horLine, 0, row, null);
            }
            if (stripeImage != null) {
                int stripeSize = stripeImage.getWidth();
                int stripeCount = height / stripeSize;
                stripeOffset %= 2 * stripeSize;
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = stripe * stripeSize + stripeOffset;
                    graphics.drawImage((Image)stripeImage, 0, stripePos, null);
                }
            }
        }
        graphics.dispose();
    }

    public static BufferedImage getStripe(int baseSize) {
        int width = (int)(1.8 * (double)baseSize);
        int height = baseSize;
        BufferedImage result = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(width - 1 - baseSize, 0);
        polygon.addPoint(width - 1, height - 1);
        polygon.addPoint(baseSize, height - 1);
        graphics.setColor(Color.white);
        graphics.fillPolygon(polygon);
        graphics.drawPolygon(polygon);
        float[] BLUR = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.3f, 0.1f, 0.1f, 0.1f, 0.1f};
        ConvolveOp vBlurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurred = vBlurOp.filter(result, null);
        return blurred;
    }

    public static BufferedImage getDragImage(int width, int height) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        int bumpCellSize = 4;
        int bumpRows = height / bumpCellSize;
        int bumpColumns = (width - 2) / bumpCellSize;
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            boolean isEvenCol = col % 2 == 0;
            int offsetY = isEvenCol ? 0 : 2;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = offsetY + bumpRowOffset + row * bumpCellSize;
                graphics.setColor(colorScheme.getLightColor());
                graphics.fillOval(cx + 1, cy + 1, 2, 2);
                graphics.setColor(colorScheme.getDarkColor());
                graphics.fillOval(cx, cy, 2, 2);
            }
        }
        return result;
    }

    public static BufferedImage getTreeIcon(ColorSchemeEnum colorSchemeEnum, boolean isCollapsed) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(10, 10);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Polygon pol = new Polygon();
        pol.addPoint(2, 1);
        pol.addPoint(8, 1);
        pol.addPoint(9, 2);
        pol.addPoint(9, 8);
        pol.addPoint(8, 9);
        pol.addPoint(2, 9);
        pol.addPoint(1, 8);
        pol.addPoint(1, 2);
        Color tlFillColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getMidColor().brighter() : Color.white;
        Color brFillColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getDarkColor().brighter() : colorSchemeEnum.getColorScheme().getLightColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, tlFillColor, 9.0f, 9.0f, brFillColor));
        graphics.fillPolygon(pol);
        Color borderColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getUltraLightColor() : colorSchemeEnum.getColorScheme().getMidColor();
        Color signColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getUltraLightColor().brighter().brighter() : colorSchemeEnum.getColorScheme().getUltraDarkColor();
        graphics.setColor(borderColor);
        graphics.drawPolygon(pol);
        graphics.setColor(signColor);
        graphics.drawLine(3, 5, 7, 5);
        if (isCollapsed) {
            graphics.drawLine(5, 3, 5, 7);
        }
        return result;
    }

    public static BufferedImage getTreeNodeIcon(TreeIcon treeIconKind) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorSchemeEnum colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        Polygon backFolder = new Polygon();
        backFolder.addPoint(2, 3);
        backFolder.addPoint(7, 3);
        backFolder.addPoint(8, 4);
        backFolder.addPoint(14, 4);
        backFolder.addPoint(15, 5);
        backFolder.addPoint(15, 13);
        backFolder.addPoint(14, 14);
        backFolder.addPoint(2, 14);
        backFolder.addPoint(1, 13);
        backFolder.addPoint(1, 4);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color gradColor1 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(backFolder);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor3 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = colorSchemeEnum.isDark() ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(backFolder);
        switch (treeIconKind) {
            case CLOSED: {
                Polygon closedFolder = new Polygon();
                closedFolder.addPoint(1, 8);
                closedFolder.addPoint(9, 8);
                closedFolder.addPoint(10, 7);
                closedFolder.addPoint(15, 7);
                closedFolder.addPoint(15, 13);
                closedFolder.addPoint(14, 14);
                closedFolder.addPoint(2, 14);
                closedFolder.addPoint(1, 13);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
                graphics.fillPolygon(closedFolder);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
                graphics.drawPolygon(closedFolder);
                break;
            }
            case OPENED: {
                Polygon openedFolder = new Polygon();
                openedFolder.addPoint(2, 13);
                openedFolder.addPoint(5, 7);
                openedFolder.addPoint(11, 7);
                openedFolder.addPoint(12, 8);
                openedFolder.addPoint(17, 8);
                openedFolder.addPoint(14, 14);
                openedFolder.addPoint(2, 14);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
                graphics.fillPolygon(openedFolder);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
                graphics.drawPolygon(openedFolder);
                break;
            }
            case UP: {
                Polygon arrow = new Polygon();
                arrow.addPoint(6, 14);
                arrow.addPoint(6, 10);
                arrow.addPoint(5, 10);
                arrow.addPoint(8, 7);
                arrow.addPoint(11, 10);
                arrow.addPoint(10, 10);
                arrow.addPoint(10, 14);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
                graphics.fillPolygon(arrow);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
                graphics.drawPolygon(arrow);
                break;
            }
            case NONE: {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setStroke(new BasicStroke(1.2f));
                graphics.drawLine(5, 9, 11, 9);
                graphics.drawLine(8, 6, 8, 12);
                graphics.drawLine(6, 7, 10, 11);
                graphics.drawLine(6, 11, 10, 7);
            }
        }
        return result;
    }

    public static BufferedImage getTreeLeafIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(16, 20);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorSchemeEnum colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        Polygon polygon = new Polygon();
        polygon.addPoint(13, 8);
        polygon.addPoint(13, 16);
        polygon.addPoint(12, 17);
        polygon.addPoint(3, 17);
        polygon.addPoint(2, 16);
        polygon.addPoint(2, 3);
        polygon.addPoint(3, 2);
        polygon.addPoint(9, 2);
        polygon.addPoint(13, 8);
        polygon.addPoint(6, 5);
        polygon.addPoint(9, 2);
        graphics.setClip(2, 2, 12, 16);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color gradColor1 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(polygon);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor3 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = colorSchemeEnum.isDark() ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(polygon);
        return result;
    }

    public static BufferedImage getHomeIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorSchemeEnum colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        Polygon outline = new Polygon();
        outline.addPoint(4, 16);
        outline.addPoint(4, 8);
        outline.addPoint(9, 2);
        outline.addPoint(12, 6);
        outline.addPoint(12, 2);
        outline.addPoint(14, 2);
        outline.addPoint(14, 16);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color gradColor1 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(outline);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor3 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = colorSchemeEnum.isDark() ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(outline);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(colorScheme.getUltraDarkColor());
        graphics.drawLine(3, 9, 9, 2);
        graphics.drawLine(9, 2, 15, 9);
        graphics.setStroke(new BasicStroke(1.2f));
        graphics.drawLine(7, 16, 7, 10);
        graphics.drawLine(7, 10, 11, 10);
        graphics.drawLine(11, 16, 11, 10);
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.drawRect(8, 6, 2, 2);
        return result;
    }

    public static BufferedImage getComputerIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorScheme colorScheme = SubstanceLookAndFeel.getColorScheme().getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillRect(1, 4, 4, 11);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawRect(1, 4, 4, 11);
        graphics.drawLine(2, 6, 4, 6);
        graphics.drawLine(2, 8, 4, 8);
        graphics.drawLine(3, 12, 3, 12);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getUltraLightColor(), 17.0f, 17.0f, colorScheme.getMidColor()));
        graphics.fillRoundRect(8, 4, 9, 8, 2, 2);
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, colorScheme.getDarkColor(), 17.0f, 17.0f, colorScheme.getUltraDarkColor()));
        graphics.drawRoundRect(7, 4, 9, 8, 2, 2);
        graphics.drawRoundRect(9, 6, 5, 4, 2, 2);
        graphics.fillRect(11, 12, 2, 3);
        graphics.drawLine(9, 15, 14, 15);
        float[] BLUR = new float[]{0.03f, 0.03f, 0.03f, 0.03f, 0.86f, 0.03f, 0.03f, 0.03f, 0.03f};
        ConvolveOp vBlurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
        BufferedImage blurred = vBlurOp.filter(result, null);
        return blurred;
    }

    public static BufferedImage getDiskIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorSchemeEnum colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color gradColor1 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillRect(3, 4, 10, 10);
        graphics.fillArc(3, 2, 10, 4, 0, 180);
        graphics.fillArc(3, 12, 10, 4, 180, 180);
        Color gradColor3 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = colorSchemeEnum.isDark() ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawOval(3, 2, 10, 4);
        graphics.drawArc(3, 12, 10, 4, 180, 180);
        graphics.drawArc(3, 9, 10, 4, 180, 180);
        graphics.drawArc(3, 6, 10, 4, 180, 180);
        graphics.drawLine(3, 4, 3, 14);
        graphics.drawLine(13, 4, 13, 14);
        return result;
    }

    public static BufferedImage getFloppyIcon() {
        BufferedImage result = SubstanceImageCreator.getBlankImage(18, 18);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        ColorSchemeEnum colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon outline = new Polygon();
        outline.addPoint(3, 3);
        outline.addPoint(13, 3);
        outline.addPoint(14, 4);
        outline.addPoint(14, 15);
        outline.addPoint(2, 15);
        outline.addPoint(2, 4);
        Color gradColor1 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor().brighter() : colorScheme.getUltraLightColor();
        Color gradColor2 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getMidColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor1, 17.0f, 17.0f, gradColor2));
        graphics.fillPolygon(outline);
        Color gradColor3 = colorSchemeEnum.isDark() ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color gradColor4 = colorSchemeEnum.isDark() ? colorScheme.getLightColor() : colorScheme.getUltraDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, gradColor3, 17.0f, 17.0f, gradColor4));
        graphics.drawPolygon(outline);
        graphics.drawRect(5, 3, 6, 3);
        graphics.fillRect(9, 3, 3, 3);
        graphics.drawRect(4, 9, 8, 6);
        graphics.drawLine(6, 11, 10, 11);
        graphics.drawLine(6, 13, 10, 13);
        return result;
    }

    public static void paintLonghornProgressBar(Graphics g, int startX, int startY, int width, int height, ColorSchemeEnum colorSchemeEnum, boolean isVertical) {
        SubstanceImageCreator.paintRectangularBackground(g, startX, startY, width, height, colorSchemeEnum, true, isVertical);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(startX, startY);
        ColorScheme colorScheme = colorSchemeEnum.getColorScheme();
        if (!isVertical) {
            int topY = (int)Math.floor(0.45 * (double)height);
            int endY = (int)Math.ceil(0.67 * (double)height);
            Color ud = colorScheme.getMidColor();
            int rUd = ud.getRed();
            int gUd = ud.getGreen();
            int bUd = ud.getBlue();
            int tUd = 255;
            int xs = (int)(0.1 * (double)(width - 2));
            int xe = (int)(0.9 * (double)(width - 2));
            int fx = (width - 2) / 2 - xs + 1;
            int dfx = fx / 4;
            for (int y = topY; y < endY; ++y) {
                HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
                gradColors.put(xs, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                gradColors.put(xe, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                int dx = dfx + (y - startY) * (fx - dfx) / (endY - startY);
                gradColors.put(xs + dx, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                gradColors.put(xe - dx, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                SubstanceImageCreator.paintOneLineGradient(graphics, 0, y, width, isVertical, new Color(rUd, gUd, bUd, tUd), new Color(rUd, gUd, bUd, tUd), gradColors);
            }
        } else {
            int leftX = (int)Math.floor(0.45 * (double)width);
            int rightX = (int)Math.ceil(0.67 * (double)width);
            Color ud = colorScheme.getMidColor();
            int rUd = ud.getRed();
            int gUd = ud.getGreen();
            int bUd = ud.getBlue();
            int tUd = 255;
            int ys = (int)(0.1 * (double)(height - 2));
            int ye = (int)(0.9 * (double)(height - 2));
            int fy = (height - 2) / 2 - ys + 1;
            int dfy = fy / 4;
            for (int x = leftX; x < rightX; ++x) {
                HashMap<Integer, Color> gradColors = new HashMap<Integer, Color>();
                gradColors.put(ys, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                gradColors.put(ye, new Color(rUd, gUd, bUd, (int)(0.8 * (double)tUd)));
                int dy = dfy + (x - startX) * (fy - dfy) / (rightX - startX);
                gradColors.put(ys + dy, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                gradColors.put(ye - dy, new Color(rUd, gUd, bUd, (int)(0.05 * (double)tUd)));
                SubstanceImageCreator.paintOneLineGradient(graphics, x, 0, height - 1, isVertical, new Color(rUd, gUd, bUd, tUd), new Color(rUd, gUd, bUd, tUd), gradColors);
            }
        }
        graphics.dispose();
    }

    public static BufferedImage getSingleCrayon(Color mainColor, int width, int height) {
        BufferedImage image = SubstanceImageCreator.getBlankImage(width, height);
        int baseTop = (int)(0.2 * (double)height);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int r = mainColor.getRed();
        int g = mainColor.getGreen();
        int b = mainColor.getBlue();
        double lc = 0.8;
        int lr = (int)((double)r + (double)(255 - r) * lc);
        int lg = (int)((double)g + (double)(255 - g) * lc);
        int lb = (int)((double)b + (double)(255 - b) * lc);
        double dc = 0.05;
        int dr = (int)((1.0 - dc) * (double)r);
        int dg = (int)((1.0 - dc) * (double)g);
        int db = (int)((1.0 - dc) * (double)b);
        Color lightColor = new Color(lr, lg, lb);
        Color darkColor = new Color(dr, dg, db);
        HashMap<Integer, Color> fillColorsColor = new HashMap<Integer, Color>();
        fillColorsColor.put((int)(0.3 * (double)width), darkColor);
        fillColorsColor.put((int)(0.5 * (double)width), darkColor);
        fillColorsColor.put((int)(0.9 * (double)width), lightColor);
        BufferedImage fillLineColor = SubstanceImageCreator.getOneLineGradient(width, lightColor, lightColor, fillColorsColor);
        for (int y = baseTop; y < height; ++y) {
            graphics.drawImage((Image)fillLineColor, 0, y, null);
        }
        int dbwr = lr;
        int dbwg = lg;
        int dbwb = lb;
        int lbwr = 128 + dr / 4;
        int lbwg = 128 + dg / 4;
        int lbwb = 128 + db / 4;
        HashMap<Integer, Color> fillColorsBW = new HashMap<Integer, Color>();
        fillColorsBW.put((int)(0.3 * (double)width), new Color(dbwr, dbwg, dbwb));
        fillColorsBW.put((int)(0.5 * (double)width), new Color(dbwr, dbwg, dbwb));
        fillColorsBW.put((int)(0.9 * (double)width), new Color(lbwr, lbwg, lbwb));
        BufferedImage fillLineBW = SubstanceImageCreator.getOneLineGradient(width, new Color(lbwr, lbwg, lbwb), new Color(lbwr, lbwg, lbwb), fillColorsBW);
        int stripeTop = (int)(0.35 * (double)height);
        int stripeHeight = (int)(0.04 * (double)height);
        for (int y = stripeTop; y < stripeTop + stripeHeight; ++y) {
            graphics.drawImage((Image)fillLineBW, 0, y, null);
        }
        graphics.setColor(new Color(lbwr, lbwg, lbwb));
        graphics.drawRect(0, stripeTop, width - 1, stripeHeight);
        GeneralPath capPath = new GeneralPath();
        capPath.moveTo(0.5f * (float)width - 3.0f, 4.0f);
        capPath.quadTo(0.5f * (float)width, 0.0f, 0.5f * (float)width + 3.0f, 4.0f);
        capPath.lineTo(width - 3, baseTop);
        capPath.lineTo(2.0f, baseTop);
        capPath.lineTo(0.5f * (float)width - 3.0f, 4.0f);
        graphics.setClip(capPath);
        graphics.setPaint(new GradientPaint(0.0f, baseTop / 2, lightColor, (int)(0.6 * (double)width), baseTop, mainColor));
        graphics.fillRect(0, 0, width / 2, baseTop);
        graphics.setPaint(new GradientPaint(width, baseTop / 2, lightColor, (int)(0.4 * (double)width), baseTop, mainColor));
        graphics.fillRect(width / 2, 0, width / 2, baseTop);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics.setClip(null);
        graphics.setColor(new Color(64 + dr / 2, 64 + dg / 2, 64 + db / 2, 200));
        graphics.drawRect(0, baseTop, width - 1, height - baseTop - 1);
        graphics.draw(capPath);
        graphics.dispose();
        return image;
    }

    private static int crayonX(int i) {
        return i % 8 * 22 + 4 + i / 8 % 2 * 11;
    }

    private static int crayonY(int i) {
        return i / 8 * 20 + 23;
    }

    public static Image getCrayonsImage() {
        int iw = 195;
        int ih = 208;
        BufferedImage image = SubstanceImageCreator.getBlankImage(iw, ih);
        Graphics2D graphics = (Graphics2D)((Image)image).getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, iw, ih);
        for (int i = 0; i < crayonColors.length; ++i) {
            Color crayonColor = new Color(0xFF000000 | crayonColors[i]);
            BufferedImage crayonImage = SubstanceImageCreator.getSingleCrayon(crayonColor, 22, 120);
            graphics.drawImage((Image)crayonImage, SubstanceImageCreator.crayonX(i), SubstanceImageCreator.crayonY(i), null);
        }
        graphics.setColor(new Color(190, 190, 190));
        graphics.drawRoundRect(0, 1, iw - 1, ih - 2, 4, 4);
        graphics.dispose();
        return image;
    }

    public static BufferedImage getErrorMarker(int dimension, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorSchemeEnum.getColorScheme().getMidColor());
        graphics.fillOval(0, 0, dimension - 1, dimension - 1);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(new Ellipse2D.Double(0.0, 0.0, dimension - 1, dimension - 1));
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.drawOval(0, 0, dimension - 1, dimension - 1);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        float ds = 0.28f * (float)(dimension - 1);
        float de = 0.72f * (float)(dimension - 1);
        GeneralPath gp1 = new GeneralPath();
        gp1.moveTo(ds, ds);
        gp1.lineTo(de, de);
        GeneralPath gp2 = new GeneralPath();
        gp2.moveTo(de, ds);
        gp2.lineTo(ds, de);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.draw(gp1);
        graphics.draw(gp2);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraLightColor().brighter());
        graphics.draw(gp1);
        graphics.draw(gp2);
        graphics.dispose();
        return image;
    }

    public static Icon getErrorMarkerIcon(int dimension, ColorSchemeEnum colorSchemeEnum) {
        return new ImageIcon(SubstanceImageCreator.getErrorMarker(dimension, colorSchemeEnum));
    }

    public static BufferedImage getWarningMarker(int dimension, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath iconOutlinePath = new GeneralPath();
        float d = dimension - 1;
        float d32 = (float)(0.1 * (double)d * Math.sqrt(3.0) / 2.0);
        float height = (float)(1.1 * (double)d * Math.sqrt(3.0) / 2.0);
        iconOutlinePath.moveTo(0.45f * d, d32);
        iconOutlinePath.quadTo(0.5f * d, 0.0f, 0.55f * d, d32);
        iconOutlinePath.lineTo(0.95f * d, height - d32);
        iconOutlinePath.quadTo(d, height, 0.9f * d, height);
        iconOutlinePath.lineTo(0.1f * d, height);
        iconOutlinePath.quadTo(0.0f, height, 0.05f * d, height - d32);
        iconOutlinePath.lineTo(0.45f * d, d32);
        graphics.setColor(colorSchemeEnum.getColorScheme().getMidColor());
        graphics.fill(iconOutlinePath);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(iconOutlinePath);
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.draw(iconOutlinePath);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.5f * d, 0.3f * height);
        markerPath.lineTo(0.5f * d, 0.6f * height);
        markerPath.moveTo(0.5f * d, 0.85f * height);
        markerPath.lineTo(0.5f * d, 0.85f * height);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraLightColor().brighter());
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static BufferedImage getInfoMarker(int dimension, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath iconOutlinePath = new GeneralPath();
        float d = dimension - 1;
        float d32 = (float)(0.1 * (double)d * Math.sqrt(3.0) / 2.0);
        float height = (float)(1.1 * (double)d * Math.sqrt(3.0) / 2.0);
        iconOutlinePath.moveTo(0.45f * d, d32);
        iconOutlinePath.quadTo(0.5f * d, 0.0f, 0.55f * d, d32);
        iconOutlinePath.lineTo(0.95f * d, height - d32);
        iconOutlinePath.quadTo(d, height, 0.9f * d, height);
        iconOutlinePath.lineTo(0.1f * d, height);
        iconOutlinePath.quadTo(0.0f, height, 0.05f * d, height - d32);
        iconOutlinePath.lineTo(0.45f * d, d32);
        graphics.setColor(colorSchemeEnum.getColorScheme().getMidColor());
        graphics.fill(iconOutlinePath);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(iconOutlinePath);
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.draw(iconOutlinePath);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.5f * d, 0.3f * height);
        markerPath.lineTo(0.5f * d, 0.3f * height);
        markerPath.moveTo(0.5f * d, 0.55f * height);
        markerPath.lineTo(0.5f * d, 0.8f * height);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraLightColor().brighter());
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static Icon getInfoMarkerIcon(int dimension, ColorSchemeEnum colorSchemeEnum) {
        return new ImageIcon(SubstanceImageCreator.getInfoMarker(dimension, colorSchemeEnum));
    }

    public static Icon getWarningMarkerIcon(int dimension, ColorSchemeEnum colorSchemeEnum) {
        return new ImageIcon(SubstanceImageCreator.getWarningMarker(dimension, colorSchemeEnum));
    }

    public static BufferedImage getQuestionMarker(int dimension, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(colorSchemeEnum.getColorScheme().getMidColor());
        graphics.fillOval(0, 0, dimension - 1, dimension - 1);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(new Ellipse2D.Double(0.0, 0.0, dimension - 1, dimension - 1));
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.drawOval(0, 0, dimension - 1, dimension - 1);
        float d = dimension - 1;
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.3f * d, 0.32f * d);
        markerPath.quadTo(0.3f * d, 0.18f * d, 0.5f * d, 0.18f * d);
        markerPath.quadTo(0.7f * d, 0.18f * d, 0.7f * d, 0.32f * d);
        markerPath.quadTo(0.7f * d, 0.45f * d, 0.6f * d, 0.45f * d);
        markerPath.quadTo(0.5f * d, 0.45f * d, 0.5f * d, 0.6f * d);
        markerPath.moveTo(0.5f * d, 0.85f * d);
        markerPath.lineTo(0.5f * d, 0.85f * d);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(colorSchemeEnum.getColorScheme().getUltraLightColor().brighter());
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static Icon getQuestionMarkerIcon(int dimension, ColorSchemeEnum colorSchemeEnum) {
        return new ImageIcon(SubstanceImageCreator.getQuestionMarker(dimension, colorSchemeEnum));
    }

    public static Icon getHexaMarker(int value, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(9, 9);
        Color offColor = null;
        Color onColor = null;
        offColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getMidColor() : colorSchemeEnum.getColorScheme().getMidColor().darker();
        onColor = colorSchemeEnum.isDark() ? SubstanceImageCreator.getInterpolatedColor(colorSchemeEnum.getColorScheme().getUltraLightColor(), Color.white, 0.2) : colorSchemeEnum.getColorScheme().getUltraDarkColor().darker();
        boolean bit1 = ((value %= 16) & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(5, 5, 4, 4);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(5, 0, 4, 4);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(0, 5, 4, 4);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(0, 0, 4, 4);
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static Image getIconHexaMarker(int value, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(16, 16);
        Color offColor = null;
        Color onColor = null;
        offColor = colorSchemeEnum.isDark() ? colorSchemeEnum.getColorScheme().getMidColor() : colorSchemeEnum.getColorScheme().getMidColor().darker();
        onColor = colorSchemeEnum.isDark() ? SubstanceImageCreator.getInterpolatedColor(colorSchemeEnum.getColorScheme().getUltraLightColor(), Color.white, 0.2) : colorSchemeEnum.getColorScheme().getUltraDarkColor().darker();
        boolean bit1 = ((value %= 16) & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(9, 9, 6, 6);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(9, 0, 6, 6);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(0, 9, 6, 6);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(0, 0, 6, 6);
        graphics.dispose();
        return result;
    }

    public static Icon getSearchIcon(int dimension, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = colorSchemeEnum.getColorScheme().getForegroundColor();
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(1.5f));
        int xc = (int)(0.6 * (double)dimension);
        int yc = (int)(0.45 * (double)dimension);
        int r = (int)(0.3 * (double)dimension);
        graphics.drawOval(xc - r, yc - r, 2 * r, 2 * r);
        graphics.setStroke(new BasicStroke(3.0f));
        GeneralPath handle = new GeneralPath();
        handle.moveTo((float)((double)xc - (double)r / Math.sqrt(2.0)), (float)((double)yc + (double)r / Math.sqrt(2.0)));
        handle.lineTo(1.8f, (float)dimension - 2.2f);
        graphics.draw(handle);
        graphics.dispose();
        return new ImageIcon(result);
    }

    public static Icon getRibbonBandExpandIcon(int dimension, ColorSchemeEnum colorSchemeEnum) {
        BufferedImage result = SubstanceImageCreator.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = colorSchemeEnum.getColorScheme().getForegroundColor();
        graphics.setColor(color);
        graphics.setStroke(new BasicStroke(1.8f));
        float dim = dimension;
        GeneralPath plus = new GeneralPath();
        plus.moveTo(0.28f * dim, 0.5f * dim);
        plus.lineTo(0.72f * dim, 0.5f * dim);
        plus.moveTo(0.5f * dim, 0.28f * dim);
        plus.lineTo(0.5f * dim, 0.72f * dim);
        graphics.draw(plus);
        graphics.dispose();
        return new ImageIcon(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TreeIcon {
        CLOSED,
        OPENED,
        UP,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        LEFT{

            public Side getAdjacentSide() {
                return TOP;
            }
        }
        ,
        RIGHT{

            public Side getAdjacentSide() {
                return BOTTOM;
            }
        }
        ,
        TOP{

            public Side getAdjacentSide() {
                return RIGHT;
            }
        }
        ,
        BOTTOM{

            public Side getAdjacentSide() {
                return LEFT;
            }
        };


        public abstract Side getAdjacentSide();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

