/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import org.jvnet.substance.SubstanceBackgroundDelegate;
import org.jvnet.substance.SubstanceButtonUI;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.Utilities;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private static WeakHashMap<JInternalFrame, BufferedImage> snapshots = new WeakHashMap();

    public SubstanceInternalFrameTitlePane(JInternalFrame f) {
        super(f);
        this.setToolTipText(f.getTitle());
    }

    public void paintComponent(Graphics g) {
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight() + 2;
        ColorSchemeEnum colorSchemeEnum = isSelected ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getColorScheme().getMetallic();
        g.drawImage(SubstanceImageCreator.getRectangularBackground(width, height, colorSchemeEnum, false), 0, 0, null);
        int xOffset = 5;
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += icon.getIconWidth() + 5;
        }
        String theTitle = this.frame.getTitle();
        int leftTransitionStart = this.menuBar == null ? 0 : this.menuBar.getWidth() + 10;
        int leftTransitionEnd = this.menuBar == null ? 0 : leftTransitionStart + 20;
        xOffset += leftTransitionEnd;
        int rightTransitionStart = (int)(0.7 * (double)width);
        int rightTransitionEnd = Math.min(rightTransitionStart + 20, (int)(0.8 * (double)width));
        JButton leftmostButton = null;
        if (this.frame.isIconifiable()) {
            leftmostButton = this.iconButton;
        } else if (this.frame.isMaximizable()) {
            leftmostButton = this.maxButton;
        } else if (this.frame.isClosable()) {
            leftmostButton = this.closeButton;
        }
        if (leftmostButton != null) {
            Rectangle rect = leftmostButton.getBounds();
            rightTransitionEnd = rect.getBounds().x - 5;
            rightTransitionStart = Math.max(0 * width, rightTransitionEnd - 20);
        }
        if (theTitle != null) {
            FontMetrics fm = this.frame.getFontMetrics(g.getFont());
            int titleWidth = rightTransitionStart - leftTransitionEnd - 30;
            theTitle = Utilities.clipString(fm, titleWidth, theTitle);
        }
        if (theTitle != null) {
            Graphics2D graphics = (Graphics2D)g;
            FontMetrics fm = this.frame.getFontMetrics(g.getFont());
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Object oldAAValue = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            if (colorSchemeEnum.isDark()) {
                graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
            } else {
                graphics.setColor(colorSchemeEnum.getColorScheme().getUltraLightColor());
            }
            graphics.drawString(theTitle, xOffset + 1, yOffset + 1);
            if (colorSchemeEnum.isDark()) {
                graphics.setColor(colorSchemeEnum.getColorScheme().getForegroundColor());
            } else {
                graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
            }
            graphics.drawString(theTitle, xOffset, yOffset);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    protected void setButtonIcons() {
        super.setButtonIcons();
        Icon minIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.RESTORE, SubstanceLookAndFeel.getColorScheme());
        Icon maxIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MAXIMIZE, SubstanceLookAndFeel.getColorScheme());
        Icon iconIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.MINIMIZE, SubstanceLookAndFeel.getColorScheme());
        Icon closeIcon = SubstanceIconFactory.getTitlePaneIcon(SubstanceIconFactory.IconKind.CLOSE, SubstanceLookAndFeel.getColorScheme());
        if (this.frame.isIcon()) {
            if (minIcon != null) {
                this.iconButton.setIcon(minIcon);
            }
            if (maxIcon != null) {
                this.maxButton.setIcon(maxIcon);
            }
        } else if (this.frame.isMaximum()) {
            if (iconIcon != null) {
                this.iconButton.setIcon(iconIcon);
            }
            if (minIcon != null) {
                this.maxButton.setIcon(minIcon);
            }
        } else {
            if (iconIcon != null) {
                this.iconButton.setIcon(iconIcon);
            }
            if (maxIcon != null) {
                this.maxButton.setIcon(maxIcon);
            }
        }
        if (closeIcon != null) {
            this.closeButton.setIcon(closeIcon);
        }
    }

    protected void createButtons() {
        super.createButtons();
        for (ActionListener listener : this.iconButton.getActionListeners()) {
            if (!(listener instanceof ClickListener)) continue;
            return;
        }
        this.iconButton.addActionListener(new ClickListener());
        SubstanceBackgroundDelegate.trackTitleButton(this.iconButton, SubstanceButtonUI.ButtonTitleKind.REGULAR);
        SubstanceBackgroundDelegate.trackTitleButton(this.maxButton, SubstanceButtonUI.ButtonTitleKind.REGULAR);
        SubstanceBackgroundDelegate.trackTitleButton(this.closeButton, SubstanceButtonUI.ButtonTitleKind.CLOSE);
        this.frame.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("ancestor".equals(evt.getPropertyName())) {
                    SubstanceInternalFrameTitlePane.updateSnapshot(SubstanceInternalFrameTitlePane.this.frame);
                }
            }
        });
    }

    public static synchronized BufferedImage getSnapshot(JInternalFrame frame) {
        BufferedImage result = snapshots.get(frame);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static void updateSnapshot(JInternalFrame frame) {
        int maxWidth;
        if (!frame.isShowing()) {
            return;
        }
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        int dx = 0;
        int dy = 0;
        Border internalFrameBorder = UIManager.getBorder("InternalFrame.border");
        Insets borderInsets = internalFrameBorder.getBorderInsets(frame);
        dx += borderInsets.left;
        dy += borderInsets.top;
        frameHeight -= borderInsets.top + borderInsets.bottom;
        BasicInternalFrameUI frameUI = (BasicInternalFrameUI)frame.getUI();
        JComponent frameTitlePane = frameUI.getNorthPane();
        BufferedImage tempCanvas = new BufferedImage(frameWidth -= borderInsets.left + borderInsets.right, frameHeight -= frameTitlePane.getHeight(), 2);
        Graphics tempCanvasGraphics = tempCanvas.getGraphics();
        tempCanvasGraphics.translate(-dx, -(dy += frameTitlePane.getHeight()));
        frame.paint(tempCanvasGraphics);
        int maxHeight = maxWidth = UIManager.getInt("DesktopIcon.width");
        double coef = Math.min((double)maxWidth / (double)frameWidth, (double)maxHeight / (double)frameHeight);
        if (coef < 1.0) {
            int sdWidth = (int)(coef * (double)frameWidth);
            int sdHeight = (int)(coef * (double)frameHeight);
            BufferedImage scaledDown = new BufferedImage(sdWidth, sdHeight, 2);
            Graphics g = scaledDown.getGraphics();
            g.drawImage(tempCanvas, 0, 0, sdWidth, sdHeight, 0, 0, frameWidth, frameHeight, null);
            snapshots.put(frame, scaledDown);
        } else {
            snapshots.put(frame, tempCanvas);
        }
    }

    public static class ClickListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AbstractButton src = (AbstractButton)e.getSource();
            ButtonModel model = src.getModel();
            model.setArmed(false);
            model.setPressed(false);
            model.setRollover(false);
            model.setSelected(false);
        }
    }
}

