/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceMenuBackgroundDelegate {
    private static SubstanceGradientBackgroundDelegate activeBackgroundDelegate = new SubstanceGradientBackgroundDelegate();
    private static SubstanceFillBackgroundDelegate fillBackgroundDelegate = new SubstanceFillBackgroundDelegate();

    private void paintBackground(Graphics g, Component component, int width, int height, ColorSchemeEnum colorSchemeEnum, boolean hasDarkBorder) {
        activeBackgroundDelegate.update(g, component, width, height, colorSchemeEnum, hasDarkBorder);
    }

    public void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor, boolean hasDarkBorder) {
        if (!menuItem.isShowing()) {
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                this.paintBackground(g, menuItem, menuWidth, menuHeight, SubstanceLookAndFeel.getColorScheme(), hasDarkBorder);
            } else {
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
                fillBackgroundDelegate.update(g, menuItem);
            }
            g.setColor(oldColor);
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            this.paintBackground(g, menuItem, menuWidth, menuHeight, SubstanceLookAndFeel.getColorScheme(), hasDarkBorder);
            g.setColor(oldColor);
        }
    }
}

