/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.RolloverControlListener;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.Trackable;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceScrollBarUI
extends MetalScrollBarUI
implements Trackable {
    protected JButton myDecreaseButton;
    protected JButton myIncreaseButton;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private static Map<String, BufferedImage> trackVerticalMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> thumbVerticalMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> trackHorizontalMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> thumbHorizontalMap = new HashMap<String, BufferedImage>();

    static synchronized void reset() {
        trackHorizontalMap.clear();
        trackVerticalMap.clear();
        thumbHorizontalMap.clear();
        thumbVerticalMap.clear();
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceScrollBarUI(b);
    }

    private SubstanceScrollBarUI(JComponent b) {
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
    }

    protected JButton createDecreaseButton(int orientation) {
        int width = this.scrollBarWidth / 2;
        if (width % 2 == 0) {
            ++width;
        }
        int height = (int)(0.4 * (double)this.scrollBarWidth);
        Icon icon = SubstanceImageCreator.getArrowIcon(width, height, orientation, SubstanceLookAndFeel.getColorScheme());
        this.myDecreaseButton = new SubstanceScrollButton(icon, orientation);
        this.myDecreaseButton.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        return this.myDecreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        int width = this.scrollBarWidth / 2;
        if (width % 2 == 0) {
            ++width;
        }
        int height = (int)(0.4 * (double)this.scrollBarWidth);
        Icon icon = SubstanceImageCreator.getArrowIcon(width, height, orientation, SubstanceLookAndFeel.getColorScheme());
        this.myIncreaseButton = new SubstanceScrollButton(icon, orientation);
        this.myIncreaseButton.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        return this.myIncreaseButton;
    }

    private static synchronized BufferedImage getTrackVertical(Rectangle trackBounds, ComponentState compDecrState, ComponentState compIncrState) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        String key = width + "*" + height + ":" + compDecrState.name() + ":" + compIncrState.name();
        BufferedImage result = trackVerticalMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getCompositeRoundedBackground(height, width, width / 2, compDecrState, compIncrState, true);
            result = SubstanceImageCreator.getRotated(result, 3);
            trackVerticalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getTrackHorizontal(Rectangle trackBounds, ComponentState compDecrState, ComponentState compIncrState) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        String key = width + "*" + height + ":" + compDecrState.name() + ":" + compIncrState.name();
        BufferedImage result = trackHorizontalMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getCompositeRoundedBackground(width, height, height / 2, compDecrState, compIncrState, false);
            trackHorizontalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getThumbVertical(JScrollBar scrollBar, Rectangle thumbBounds, ButtonModel buttonModel) {
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        ComponentState state = ComponentState.getState(buttonModel, null);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        String key = width + ":" + height + ":" + kind.name() + ":" + cyclePos;
        BufferedImage result = thumbVerticalMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getRoundedBackground(height, width, width / 2, colorSchemeEnum, cyclePos, null);
            result = SubstanceImageCreator.getRotated(result, 3);
            thumbVerticalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getThumbHorizontal(JScrollBar scrollBar, Rectangle thumbBounds, ButtonModel buttonModel) {
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        ComponentState state = ComponentState.getState(buttonModel, null);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorSchemeEnum colorSchemeEnum = null;
        switch (kind) {
            case CURRENT: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme();
                break;
            }
            case REGULAR: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getMetallic();
                break;
            }
            case DISABLED: {
                colorSchemeEnum = SubstanceLookAndFeel.getColorScheme().getGray();
            }
        }
        String key = width + ":" + height + ":" + kind.name() + ":" + cyclePos;
        BufferedImage result = thumbHorizontalMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getRoundedBackground(width, height, height / 2, colorSchemeEnum, cyclePos, null);
            thumbHorizontalMap.put(key, result);
        }
        return result;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (!c.isEnabled()) {
            return;
        }
        ComponentState compDecrState = ComponentState.DEFAULT;
        ComponentState compIncrState = ComponentState.DEFAULT;
        if (this.myDecreaseButton.isShowing() && this.myIncreaseButton.isShowing()) {
            ButtonModel decrModel = this.myDecreaseButton.getModel();
            ButtonModel incrModel = this.myIncreaseButton.getModel();
            compDecrState = ComponentState.getState(decrModel, this.decreaseButton);
            compIncrState = ComponentState.getState(incrModel, this.increaseButton);
        }
        BufferedImage trackImage = this.scrollbar.getOrientation() == 1 ? SubstanceScrollBarUI.getTrackVertical(trackBounds, compDecrState, compIncrState) : SubstanceScrollBarUI.getTrackHorizontal(trackBounds, compDecrState, compIncrState);
        g.drawImage(trackImage, trackBounds.x, trackBounds.y, null);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        JScrollBar scrollBar = (JScrollBar)c;
        this.thumbModel.setSelected(this.thumbModel.isSelected() || this.isDragging);
        BufferedImage thumbImage = this.scrollbar.getOrientation() == 1 ? SubstanceScrollBarUI.getThumbVertical(scrollBar, thumbBounds, this.thumbModel) : SubstanceScrollBarUI.getThumbHorizontal(scrollBar, thumbBounds, this.thumbModel);
        g.drawImage(thumbImage, thumbBounds.x, thumbBounds.y, null);
    }

    protected void installListeners() {
        super.installListeners();
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mouseExited(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mousePressed(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }
        };
        this.incrButton.addMouseListener(mouseListener);
        this.decrButton.addMouseListener(mouseListener);
        RolloverControlListener listener = new RolloverControlListener(this, this.thumbModel);
        this.scrollbar.addMouseListener(listener);
        this.scrollbar.addMouseMotionListener(listener);
    }

    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.getThumbBounds();
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceScrollBarUI: \n");
        sb.append("\t" + trackHorizontalMap.size() + " track horizontal, " + trackVerticalMap.size() + " track vertical, " + thumbHorizontalMap.size() + " thumb horizontal, " + thumbVerticalMap.size() + " thumb vertical");
        return sb.toString();
    }
}

