/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jvnet.substance.comp.JRibbonBand;
import org.jvnet.substance.comp.RibbonBandUI;

public class BasicRibbonBandUI
extends RibbonBandUI {
    public static final int BAND_HEADER_HEIGHT = 18;
    public static final int BAND_CONTROL_PANEL_HEIGHT = 68;
    protected JRibbonBand ribbonBand;
    protected boolean isUnderMouse;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonBandUI();
    }

    public void installUI(JComponent c) {
        this.ribbonBand = (JRibbonBand)c;
        this.ribbonBand.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                BasicRibbonBandUI.this.isUnderMouse = true;
                BasicRibbonBandUI.this.ribbonBand.repaint();
            }

            public void mouseExited(MouseEvent e) {
                if (BasicRibbonBandUI.this.ribbonBand.contains(e.getPoint())) {
                    return;
                }
                BasicRibbonBandUI.this.isUnderMouse = false;
                BasicRibbonBandUI.this.ribbonBand.repaint();
            }
        });
        if (this.ribbonBand.expandButton != null) {
            this.ribbonBand.expandButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BasicRibbonBandUI.this.isUnderMouse = false;
                            BasicRibbonBandUI.this.ribbonBand.repaint();
                        }
                    });
                }
            });
        }
        this.installDefaults(this.ribbonBand);
        c.setLayout(this.createLayoutManager());
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallDefaults((JRibbonBand)c);
        this.ribbonBand = null;
    }

    protected void installDefaults(JRibbonBand rb) {
        LookAndFeel.installColorsAndFont(rb, "RibbonBand.background", "RibbonBand.foreground", "RibbonBand.font");
        LookAndFeel.installBorder(rb, "RibbonBand.border");
    }

    protected void uninstallDefaults(JRibbonBand rb) {
        LookAndFeel.uninstallBorder(rb);
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonBandLayout();
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        String title = this.ribbonBand.getTitle();
        this.paintBandTitle(graphics, new Rectangle(0, 0, c.getWidth(), 18), title);
        this.paintBandBackground(graphics, new Rectangle(0, 18, c.getWidth(), 68));
        graphics.dispose();
    }

    protected void paintBandTitle(Graphics g, Rectangle titleRectangle, String title) {
        Graphics2D graphics = (Graphics2D)g.create();
        Color ribbonBandBackground = this.ribbonBand.getBackground();
        double topCoef = this.isUnderMouse ? 0.4 : 0.28;
        double bottomCoef = this.isUnderMouse ? 0.6 : 0.4;
        Color topColor = new Color((int)(topCoef * (double)ribbonBandBackground.getRed()), (int)(topCoef * (double)ribbonBandBackground.getGreen()), (int)(topCoef * (double)ribbonBandBackground.getBlue()));
        Color bottomColor = new Color((int)(bottomCoef * (double)ribbonBandBackground.getRed()), (int)(bottomCoef * (double)ribbonBandBackground.getGreen()), (int)(bottomCoef * (double)ribbonBandBackground.getBlue()));
        graphics.setPaint(new GradientPaint(titleRectangle.x, titleRectangle.y, topColor, titleRectangle.x, titleRectangle.y + titleRectangle.height, bottomColor));
        graphics.fillRect(titleRectangle.x, titleRectangle.y, titleRectangle.width, titleRectangle.height);
        graphics.setFont(new Font("Tahoma", 1, 11));
        int y = titleRectangle.y + (titleRectangle.height + graphics.getFontMetrics().getAscent()) / 2;
        graphics.setColor(topColor);
        graphics.drawString(title, titleRectangle.x + 3, y);
        graphics.setColor(ribbonBandBackground);
        graphics.drawString(title, titleRectangle.x + 2, y - 1);
        graphics.dispose();
    }

    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        graphics.setColor(this.ribbonBand.getBackground());
        graphics.fillRect(toFill.x, toFill.y, toFill.width, toFill.height);
    }

    private class RibbonBandLayout
    implements LayoutManager {
        private RibbonBandLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            JRibbonBand jrb = (JRibbonBand)c;
            return new Dimension(jrb.getControlPanel().getPreferredSize().width, 86);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            BasicRibbonBandUI.this.ribbonBand.getControlPanel().setBounds(1, 18, c.getWidth() - 2, 67);
        }
    }
}

