/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.comp;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jvnet.substance.comp.JRibbonBand;
import org.jvnet.substance.comp.RibbonTask;
import org.jvnet.substance.comp.RibbonUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRibbon
extends JComponent {
    private ArrayList<RibbonTask> tasks = new ArrayList();
    private ArrayList<Component> regularComponents = new ArrayList();
    private ArrayList<JToggleButton> taskToggleButtons = new ArrayList();
    private ArrayList<JRibbonBand> bands = new ArrayList();
    private RibbonTask currentlySelectedTask = new RibbonTask();
    private ButtonGroup taskToggleButtonGroup = new ButtonGroup();
    private static final String uiClassID = "RibbonUI";

    public JRibbon() {
        this.updateUI();
    }

    @Override
    public Component add(Component comp, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Component add(Component comp) {
        this.regularComponents.add(comp);
        return super.add(comp);
    }

    private Component addInternal(Component comp) {
        return super.add(comp);
    }

    @Override
    public void remove(Component comp) {
        this.regularComponents.remove(comp);
        super.remove(comp);
    }

    public void addTask(String name, final RibbonTask task) {
        this.tasks.add(task);
        JToggleButton taskToggleButton = new JToggleButton(name);
        taskToggleButton.setFont(new Font("Tahoma", 1, 12));
        this.taskToggleButtonGroup.add(taskToggleButton);
        this.taskToggleButtons.add(taskToggleButton);
        this.addInternal(taskToggleButton);
        if (this.tasks.size() == 1) {
            this.setSelectedTask(task);
            taskToggleButton.setSelected(true);
        }
        taskToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JRibbon.this.setSelectedTask(task);
                    }
                });
            }
        });
    }

    public void removeTask(RibbonTask task) {
        int index = this.tasks.indexOf(task);
        this.removeTask(index);
    }

    public void removeTask(int index) {
        if (index >= 0) {
            RibbonTask toRemove = this.tasks.get(index);
            this.tasks.remove(toRemove);
            if (this.currentlySelectedTask == toRemove) {
                if (--index < 0) {
                    ++index;
                }
                if (index < this.tasks.size()) {
                    this.setSelectedTask(this.tasks.get(index));
                }
            }
        }
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public RibbonTask getTask(int index) {
        return this.tasks.get(index);
    }

    protected void setSelectedTask(RibbonTask task) {
        for (JRibbonBand panel : this.bands) {
            this.remove(panel);
        }
        this.bands.clear();
        for (int i = 0; i < task.getBandCount(); ++i) {
            JRibbonBand panel;
            panel = task.getBand(i);
            this.addInternal(panel);
            this.bands.add(panel);
        }
        this.currentlySelectedTask = task;
        this.revalidate();
        this.repaint();
    }

    public void setUI(RibbonUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((RibbonUI)UIManager.getUI(this));
    }

    @Override
    public RibbonUI getUI() {
        return (RibbonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public ArrayList<Component> getRegularComponents() {
        return this.regularComponents;
    }

    public ArrayList<JRibbonBand> getBands() {
        return this.bands;
    }

    public ArrayList<JToggleButton> getTaskToggleButtons() {
        return this.taskToggleButtons;
    }
}

