/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceBubblesWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenDim.width;
        int screenHeight = screenDim.height;
        watermarkImage = SubstanceImageCreator.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        Color stampColor = SubstanceLookAndFeel.getColorScheme().isDark() ? new Color(255, 255, 255, 25) : new Color(0, 0, 0, 15);
        int minBubbleRadius = 10;
        int maxBubbleRadius = 20;
        int cellSize = minBubbleRadius + maxBubbleRadius;
        int rowCount = screenHeight / cellSize;
        int columnCount = screenWidth / cellSize;
        graphics.setColor(stampColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int col = 0; col <= columnCount; ++col) {
            for (int row = 0; row <= rowCount; ++row) {
                int xc = (int)((double)(col * cellSize) + (double)cellSize * Math.random());
                int yc = (int)((double)(row * cellSize) + (double)cellSize * Math.random());
                int r = minBubbleRadius + (int)(Math.random() * (double)(maxBubbleRadius - minBubbleRadius));
                graphics.drawOval(xc - r, yc - r, 2 * r, 2 * r);
                GeneralPath shine = new GeneralPath();
                shine.moveTo((float)xc - 0.2f * (float)r, (float)yc - 0.8f * (float)r);
                shine.quadTo((float)xc - 0.7f * (float)r, (float)yc - 0.6f * (float)r, (float)xc - 0.8f * (float)r, (float)yc - 0.1f * (float)r);
                shine.lineTo((float)xc - 0.3f * (float)r, (float)yc + 0.2f * (float)r);
                shine.quadTo((float)xc - 0.3f * (float)r, (float)yc - 0.4f * (float)r, xc, (float)yc - 0.6f * (float)r);
                shine.lineTo((float)xc - 0.2f * (float)r, (float)yc - 0.8f * (float)r);
                graphics.draw(shine);
            }
        }
        graphics.dispose();
        return true;
    }

    public String getDisplayName() {
        return SubstanceBubblesWatermark.getName();
    }

    public static String getName() {
        return "Bubbles";
    }

    public boolean isDependingOnTheme() {
        return true;
    }
}

