/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceCrosshatchWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = screenDim.width;
        int screenHeight = screenDim.height;
        watermarkImage = SubstanceImageCreator.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        Color stampColorDark = SubstanceLookAndFeel.getColorScheme().isDark() ? new Color(0, 0, 0, 35) : new Color(0, 0, 0, 20);
        Color stampColorAll = SubstanceLookAndFeel.getColorScheme().isDark() ? new Color(255, 255, 255, 10) : new Color(0, 0, 0, 10);
        Color stampColorLight = SubstanceLookAndFeel.getColorScheme().isDark() ? new Color(255, 255, 255, 20) : new Color(255, 255, 255, 128);
        graphics.setColor(stampColorAll);
        graphics.fillRect(0, 0, screenWidth, screenHeight);
        BufferedImage tile = SubstanceImageCreator.getBlankImage(4, 4);
        tile.setRGB(0, 0, stampColorDark.getRGB());
        tile.setRGB(2, 2, stampColorDark.getRGB());
        tile.setRGB(0, 1, stampColorLight.getRGB());
        tile.setRGB(2, 3, stampColorLight.getRGB());
        for (int row = 0; row < screenHeight; row += 4) {
            for (int col = 0; col < screenWidth; col += 4) {
                graphics.drawImage((Image)tile, col, row, null);
            }
        }
        graphics.dispose();
        return true;
    }

    public String getDisplayName() {
        return SubstanceCrosshatchWatermark.getName();
    }

    public static String getName() {
        return "Crosshatch";
    }

    public boolean isDependingOnTheme() {
        return true;
    }
}

