/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.event.MouseEvent;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JScrollBar;
import org.jvnet.substance.RolloverButtonListener;

public class RolloverScrollBarButtonListener
extends RolloverButtonListener {
    private boolean isMouseInside = false;
    private JScrollBar scrollBar;
    private static WeakHashMap<AbstractButton, RolloverScrollBarButtonListener> listeners = new WeakHashMap();

    public static RolloverScrollBarButtonListener getListener(JScrollBar scrollBar, AbstractButton b) {
        if (listeners.containsKey(b) && listeners.get(b) != null) {
            return listeners.get(b);
        }
        RolloverScrollBarButtonListener rlb = new RolloverScrollBarButtonListener(scrollBar, b);
        b.setRolloverEnabled(true);
        listeners.put(b, rlb);
        return rlb;
    }

    private RolloverScrollBarButtonListener(JScrollBar scrollBar, AbstractButton b) {
        super(b);
        this.scrollBar = scrollBar;
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        AbstractButton button = (AbstractButton)e.getSource();
        this.isMouseInside = true;
        button.getModel().setRollover(true);
        this.scrollBar.repaint();
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        AbstractButton button = (AbstractButton)e.getSource();
        this.isMouseInside = false;
        button.getModel().setRollover(false);
        this.scrollBar.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        AbstractButton button = (AbstractButton)e.getSource();
        button.getModel().setRollover(this.isMouseInside);
        this.scrollBar.repaint();
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.scrollBar.repaint();
    }
}

