/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Font;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jvnet.substance.MemoryAnalyzer;
import org.jvnet.substance.SubstanceBackgroundDelegate;
import org.jvnet.substance.SubstanceCheckBoxUI;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceMenuBarUI;
import org.jvnet.substance.SubstanceProgressBarUI;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.color.ColorSchemeEnum;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceBarbyPinkTheme;
import org.jvnet.substance.theme.SubstanceBottleGreenTheme;
import org.jvnet.substance.theme.SubstanceBrownTheme;
import org.jvnet.substance.theme.SubstanceCharcoalTheme;
import org.jvnet.substance.theme.SubstanceDarkVioletTheme;
import org.jvnet.substance.theme.SubstanceEbonyTheme;
import org.jvnet.substance.theme.SubstanceLightAquaTheme;
import org.jvnet.substance.theme.SubstanceLimeGreenTheme;
import org.jvnet.substance.theme.SubstanceOliveTheme;
import org.jvnet.substance.theme.SubstanceOrangeTheme;
import org.jvnet.substance.theme.SubstancePurpleTheme;
import org.jvnet.substance.theme.SubstanceRaspberryTheme;
import org.jvnet.substance.theme.SubstanceSepiaTheme;
import org.jvnet.substance.theme.SubstanceSteelBlueTheme;
import org.jvnet.substance.theme.SubstanceSunGlareTheme;
import org.jvnet.substance.theme.SubstanceSunsetTheme;
import org.jvnet.substance.theme.SubstanceTerracottaTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.watermark.SubstanceBinaryWatermark;
import org.jvnet.substance.watermark.SubstanceBubblesWatermark;
import org.jvnet.substance.watermark.SubstanceCrosshatchWatermark;
import org.jvnet.substance.watermark.SubstanceKatakanaWatermark;
import org.jvnet.substance.watermark.SubstanceLatchWatermark;
import org.jvnet.substance.watermark.SubstanceMetalWallWatermark;
import org.jvnet.substance.watermark.SubstanceMosaicWatermark;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;
import org.jvnet.substance.watermark.SubstanceWatermark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceLookAndFeel
extends MetalLookAndFeel {
    private static SubstanceWatermark currentWatermark = null;

    public SubstanceLookAndFeel() {
        String paramTheme = null;
        try {
            paramTheme = System.getProperty("substancelaf.theme");
        }
        catch (Exception exc) {
            // empty catch block
        }
        boolean isSetTheme = false;
        if (paramTheme != null) {
            isSetTheme = SubstanceLookAndFeel.setCurrentTheme(paramTheme);
        }
        if (!isSetTheme) {
            try {
                SubstanceLookAndFeel.setCurrentTheme(new SubstanceAquaTheme());
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        String paramWatermark = null;
        try {
            paramWatermark = System.getProperty("substancelaf.watermark");
        }
        catch (Exception exc) {
            // empty catch block
        }
        boolean isSetWatermark = false;
        if (paramWatermark != null) {
            isSetWatermark = SubstanceLookAndFeel.setCurrentWatermark(paramWatermark);
        }
        if (!isSetWatermark) {
            try {
                SubstanceLookAndFeel.setCurrentWatermark(new SubstanceStripeWatermark());
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        try {
            if (System.getProperty("substancelaf.useDecorations") != null) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        try {
            String paramTraceFile = System.getProperty("substancelaf.traceFile");
            if (paramTraceFile != null) {
                MemoryAnalyzer.commence(5000L, paramTraceFile);
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
    }

    public static ColorSchemeEnum getColorScheme() {
        MetalTheme theme = MetalLookAndFeel.getCurrentTheme();
        if (!(theme instanceof SubstanceTheme)) {
            return ColorSchemeEnum.AQUA;
        }
        return ((SubstanceTheme)theme).getColorSchemeEnum();
    }

    public static boolean setCurrentTheme(String themeClassName) {
        try {
            Class<?> themeClass = Class.forName(themeClassName);
            if (themeClass == null) {
                return false;
            }
            Object obj = themeClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceTheme)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)obj);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentTheme(SubstanceTheme theme) {
        MetalLookAndFeel.setCurrentTheme(theme);
        SubstanceIconFactory.reset();
        SubstanceBackgroundDelegate.reset();
        SubstanceCheckBoxUI.reset();
        SubstanceGradientBackgroundDelegate.reset();
        SubstanceProgressBarUI.reset();
        SubstanceRadioButtonUI.reset();
        SubstanceScrollBarUI.reset();
        SubstanceTabbedPaneUI.reset();
        SubstanceMenuBarUI.reset();
        theme.addCustomEntriesToTable(UIManager.getLookAndFeelDefaults());
        if (currentWatermark != null && currentWatermark.isDependingOnTheme()) {
            currentWatermark.updateWatermarkImage();
        }
        return true;
    }

    public static String getCurrentThemeName() {
        return SubstanceLookAndFeel.getColorScheme().getDisplayName();
    }

    public static Map<String, String> enumerateThemes() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put(ColorSchemeEnum.AQUA.getDisplayName(), SubstanceAquaTheme.class.getName());
        result.put(ColorSchemeEnum.LIGHT_AQUA.getDisplayName(), SubstanceLightAquaTheme.class.getName());
        result.put(ColorSchemeEnum.LIME_GREEN.getDisplayName(), SubstanceLimeGreenTheme.class.getName());
        result.put(ColorSchemeEnum.BROWN.getDisplayName(), SubstanceBrownTheme.class.getName());
        result.put(ColorSchemeEnum.ORANGE.getDisplayName(), SubstanceOrangeTheme.class.getName());
        result.put(ColorSchemeEnum.PURPLE.getDisplayName(), SubstancePurpleTheme.class.getName());
        result.put(ColorSchemeEnum.SUN_GLARE.getDisplayName(), SubstanceSunGlareTheme.class.getName());
        result.put(ColorSchemeEnum.SUNSET.getDisplayName(), SubstanceSunsetTheme.class.getName());
        result.put(ColorSchemeEnum.OLIVE.getDisplayName(), SubstanceOliveTheme.class.getName());
        result.put(ColorSchemeEnum.TERRACOTTA.getDisplayName(), SubstanceTerracottaTheme.class.getName());
        result.put(ColorSchemeEnum.SEPIA.getDisplayName(), SubstanceSepiaTheme.class.getName());
        result.put(ColorSchemeEnum.STEEL_BLUE.getDisplayName(), SubstanceSteelBlueTheme.class.getName());
        result.put(ColorSchemeEnum.EBONY.getDisplayName(), SubstanceEbonyTheme.class.getName());
        result.put(ColorSchemeEnum.CHARCOAL.getDisplayName(), SubstanceCharcoalTheme.class.getName());
        result.put(ColorSchemeEnum.DARK_VIOLET.getDisplayName(), SubstanceDarkVioletTheme.class.getName());
        result.put(ColorSchemeEnum.BOTTLE_GREEN.getDisplayName(), SubstanceBottleGreenTheme.class.getName());
        result.put(ColorSchemeEnum.RASPBERRY.getDisplayName(), SubstanceRaspberryTheme.class.getName());
        result.put(ColorSchemeEnum.BARBY_PINK.getDisplayName(), SubstanceBarbyPinkTheme.class.getName());
        return result;
    }

    public static String getCurrentWatermarkName() {
        if (currentWatermark == null) {
            return null;
        }
        return currentWatermark.getDisplayName();
    }

    public static Map<String, String> enumerateWatermarks() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put(SubstanceStripeWatermark.getName(), SubstanceStripeWatermark.class.getName());
        result.put(SubstanceKatakanaWatermark.getName(), SubstanceKatakanaWatermark.class.getName());
        result.put(SubstanceBubblesWatermark.getName(), SubstanceBubblesWatermark.class.getName());
        result.put(SubstanceCrosshatchWatermark.getName(), SubstanceCrosshatchWatermark.class.getName());
        result.put(SubstanceBinaryWatermark.getName(), SubstanceBinaryWatermark.class.getName());
        result.put(SubstanceMosaicWatermark.getName(), SubstanceMosaicWatermark.class.getName());
        result.put(SubstanceMetalWallWatermark.getName(), SubstanceMetalWallWatermark.class.getName());
        result.put(SubstanceLatchWatermark.getName(), SubstanceLatchWatermark.class.getName());
        return result;
    }

    public static SubstanceWatermark getCurrentWatermark() {
        return currentWatermark;
    }

    public static boolean setCurrentWatermark(String watermarkClassName) {
        try {
            Class<?> watermarkClass = Class.forName(watermarkClassName);
            if (watermarkClass == null) {
                return false;
            }
            Object obj = watermarkClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceWatermark)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentWatermark((SubstanceWatermark)obj);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentWatermark(SubstanceWatermark currentWatermark) {
        SubstanceLookAndFeel.currentWatermark = currentWatermark;
        return currentWatermark.updateWatermarkImage();
    }

    @Override
    public String getDescription() {
        return "Substance look and feel by Kirill Grouchnikov";
    }

    @Override
    public String getID() {
        return "Substance";
    }

    @Override
    public String getName() {
        return "Substance";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String UI_CLASSNAME_PREFIX = "org.jvnet.substance.Substance";
        Object[] uiDefaults = new Object[]{"ColorChooserUI", "ch.randelshofer.quaqua.Quaqua14ColorChooserUI", "ButtonUI", UI_CLASSNAME_PREFIX + "ButtonUI", "ButtonStripUI", UI_CLASSNAME_PREFIX + "ButtonStripUI", "CheckBoxUI", UI_CLASSNAME_PREFIX + "CheckBoxUI", "ComboBoxUI", UI_CLASSNAME_PREFIX + "ComboBoxUI", "CheckBoxMenuItemUI", UI_CLASSNAME_PREFIX + "CheckBoxMenuItemUI", "DesktopIconUI", UI_CLASSNAME_PREFIX + "DesktopIconUI", "DesktopPaneUI", UI_CLASSNAME_PREFIX + "DesktopPaneUI", "EditorPaneUI", UI_CLASSNAME_PREFIX + "EditorPaneUI", "FileChooserUI", UI_CLASSNAME_PREFIX + "FileChooserUI", "FormattedTextFieldUI", UI_CLASSNAME_PREFIX + "FormattedTextFieldUI", "InternalFrameUI", UI_CLASSNAME_PREFIX + "InternalFrameUI", "ListUI", UI_CLASSNAME_PREFIX + "ListUI", "MenuUI", UI_CLASSNAME_PREFIX + "MenuUI", "MenuItemUI", UI_CLASSNAME_PREFIX + "MenuItemUI", "OptionPaneUI", UI_CLASSNAME_PREFIX + "OptionPaneUI", "PanelUI", UI_CLASSNAME_PREFIX + "PanelUI", "PasswordFieldUI", UI_CLASSNAME_PREFIX + "PasswordFieldUI", "ProgressBarUI", UI_CLASSNAME_PREFIX + "ProgressBarUI", "RadioButtonUI", UI_CLASSNAME_PREFIX + "RadioButtonUI", "RadioButtonMenuItemUI", UI_CLASSNAME_PREFIX + "RadioButtonMenuItemUI", "RibbonUI", UI_CLASSNAME_PREFIX + "RibbonUI", "RibbonBandUI", UI_CLASSNAME_PREFIX + "RibbonBandUI", "RootPaneUI", UI_CLASSNAME_PREFIX + "RootPaneUI", "ScrollBarUI", UI_CLASSNAME_PREFIX + "ScrollBarUI", "SliderUI", UI_CLASSNAME_PREFIX + "SliderUI", "SpinnerUI", UI_CLASSNAME_PREFIX + "SpinnerUI", "SplitPaneUI", UI_CLASSNAME_PREFIX + "SplitPaneUI", "TabbedPaneUI", UI_CLASSNAME_PREFIX + "TabbedPaneUI", "TableUI", UI_CLASSNAME_PREFIX + "TableUI", "TableHeaderUI", UI_CLASSNAME_PREFIX + "TableHeaderUI", "TextAreaUI", UI_CLASSNAME_PREFIX + "TextAreaUI", "TextFieldUI", UI_CLASSNAME_PREFIX + "TextFieldUI", "TextPaneUI", UI_CLASSNAME_PREFIX + "TextPaneUI", "ToggleButtonUI", UI_CLASSNAME_PREFIX + "ToggleButtonUI", "ToolTipUI", UI_CLASSNAME_PREFIX + "ToolTipUI", "ToolBarUI", UI_CLASSNAME_PREFIX + "ToolBarUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        Font tahomaPlain11 = new Font("Tahoma", 0, 11);
        Font tahomaPlain12 = new Font("Tahoma", 0, 12);
        Font tahomaBold11 = new Font("Tahoma", 1, 11);
        Font tahomaBold12 = new Font("Tahoma", 1, 12);
        if (tahomaPlain11 != null) {
            Object[] fontDefaults = new Object[]{"Button.font", tahomaPlain11, "CheckBox.font", tahomaPlain11, "CheckBoxMenuItem.font", tahomaPlain11, "CheckBoxMenuItem.acceleratorFont", tahomaPlain11, "ColorChooser.font", tahomaPlain11, "ColorChooser.crayonsFont", tahomaBold12, "ComboBox.font", tahomaPlain11, "DesktopIcon.font", tahomaBold12, "EditorPane.font", tahomaPlain11, "FormattedTextField.font", tahomaPlain11, "InternalFrame.titleFont", tahomaBold12, "Label.font", tahomaPlain11, "List.font", tahomaPlain11, "Menu.font", tahomaPlain11, "Menu.acceleratorFont", tahomaPlain11, "MenuBar.font", tahomaPlain11, "MenuItem.font", tahomaPlain11, "MenuItem.acceleratorFont", tahomaPlain11, "OptionPane.font", tahomaPlain11, "OptionPane.messageFont", tahomaPlain11, "OptionPane.buttonFont", tahomaPlain11, "Panel.font", tahomaPlain11, "PasswordField.font", tahomaPlain11, "PopupMenu.font", tahomaPlain11, "ProgressBar.font", tahomaPlain11, "RadioButton.font", tahomaPlain11, "RadioButtonMenuItem.font", tahomaPlain11, "RadioButtonMenuItem.acceleratorFont", tahomaPlain11, "ScrollPane.font", tahomaPlain11, "Spinner.font", tahomaPlain11, "TabbedPane.font", tahomaPlain11, "Table.font", tahomaPlain11, "TableHeader.font", tahomaPlain11, "TextField.font", tahomaPlain11, "TextPane.font", tahomaPlain11, "ToolBar.font", tahomaPlain11, "ToggleButton.font", tahomaPlain11, "Tree.font", tahomaPlain11, "Viewport.font", tahomaPlain11, "Spinner.font", tahomaPlain11, "TextArea.font", tahomaPlain11, "TitledBorder.font", tahomaBold11, "ToolTip.font", tahomaPlain11};
            table.putDefaults(fontDefaults);
        }
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        Icon disIcon = super.getDisabledIcon(component, icon);
        return SubstanceImageCreator.toGreyscale(disIcon);
    }

    @Override
    public Icon getDisabledSelectedIcon(JComponent component, Icon icon) {
        Icon disIcon = super.getDisabledSelectedIcon(component, icon);
        return SubstanceImageCreator.toGreyscale(disIcon);
    }

    @Override
    protected void createDefaultTheme() {
    }
}

