/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import net.wordrider.area.ColorStyles;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderStyles;
import net.wordrider.utilities.LogUtils;

final class CurrentLineHighlighter {
    private static final String LINE_HIGHLIGHT = "linehighlight";
    private static final String PREVIOUS_CARET = "previousCaret";
    private static final String UNDO_KEY = "makingundo";
    private static final Logger logger = Logger.getLogger(CurrentLineHighlighter.class.getName());
    private static final CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent caretEvent) {
            final JTextComponent jTextComponent = (JTextComponent)caretEvent.getSource();
            Object object = jTextComponent.getClientProperty(CurrentLineHighlighter.UNDO_KEY);
            if (object != null) {
                return;
            }
            RiderArea riderArea = (RiderArea)jTextComponent;
            if (riderArea.isBusy()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CurrentLineHighlighter.caretUpdate(jTextComponent);
                }
            });
        }
    };
    private static final MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            CurrentLineHighlighter.caretUpdate(jTextComponent);
        }
    };
    private static final MouseListener mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            CurrentLineHighlighter.caretUpdate(jTextComponent);
        }
    };
    private static final Highlighter.HighlightPainter painter = new Highlighter.HighlightPainter(){

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            int n3;
            Document document = jTextComponent.getDocument();
            Element element = document.getDefaultRootElement();
            if (RiderStyles.isReadonlySection(element.getElement(element.getElementIndex(n3 = jTextComponent.getCaretPosition())))) {
                return;
            }
            try {
                Rectangle rectangle = jTextComponent.modelToView(n3);
                if (rectangle == null) {
                    return;
                }
                graphics.setColor(ColorStyles.getColor(5));
                graphics.fillRect(30, rectangle.y, jTextComponent.getWidth(), rectangle.height);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    };

    private CurrentLineHighlighter() {
    }

    public static void install(JTextComponent jTextComponent) {
        if (jTextComponent.getClientProperty(LINE_HIGHLIGHT) != null) {
            return;
        }
        try {
            Object object = jTextComponent.getHighlighter().addHighlight(0, 0, painter);
            jTextComponent.putClientProperty(LINE_HIGHLIGHT, object);
            jTextComponent.putClientProperty(PREVIOUS_CARET, jTextComponent.getCaretPosition());
            jTextComponent.addCaretListener(caretListener);
            jTextComponent.addMouseListener(mouseListener);
            jTextComponent.addMouseMotionListener(mouseMotionListener);
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
    }

    public static void uninstall(JTextComponent jTextComponent) {
        Object object = jTextComponent.getClientProperty(LINE_HIGHLIGHT);
        if (object != null) {
            jTextComponent.getHighlighter().removeHighlight(object);
            jTextComponent.putClientProperty(LINE_HIGHLIGHT, null);
            jTextComponent.putClientProperty(PREVIOUS_CARET, null);
            jTextComponent.removeCaretListener(caretListener);
            jTextComponent.removeMouseListener(mouseListener);
            jTextComponent.removeMouseMotionListener(mouseMotionListener);
        }
    }

    public static void updateDnD(JTextComponent jTextComponent) {
        if (jTextComponent.getClientProperty(LINE_HIGHLIGHT) != null) {
            CurrentLineHighlighter.caretUpdate(jTextComponent);
        }
    }

    private static void caretUpdate(JTextComponent jTextComponent) {
        try {
            int n = (Integer)jTextComponent.getClientProperty(PREVIOUS_CARET);
            int n2 = jTextComponent.getCaretPosition();
            jTextComponent.putClientProperty(PREVIOUS_CARET, n2);
            if (n <= jTextComponent.getDocument().getLength()) {
                Rectangle rectangle = jTextComponent.modelToView(n);
                Rectangle rectangle2 = jTextComponent.modelToView(n2);
                if (rectangle.y != rectangle2.y) {
                    jTextComponent.repaint(0, rectangle.y, jTextComponent.getWidth(), rectangle2.height + 4);
                    jTextComponent.repaint(0, rectangle2.y, jTextComponent.getWidth(), rectangle2.height);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

