/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.text.Element;
import javax.swing.text.Style;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.actions.StyledAreaAction;

public final class RotateMarginStyleAction
extends StyledAreaAction {
    private static final RotateMarginStyleAction instance = new RotateMarginStyleAction();
    private static final String CODE = "RotateMarginStyleAction";

    private RotateMarginStyleAction() {
        super(CODE, KeyStroke.getKeyStroke("F3"), null);
    }

    public static RotateMarginStyleAction getInstance() {
        return instance;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea == null) {
            return;
        }
        Element element = riderArea.getStyledDocument().getParagraphElement(riderArea.getCaretPosition());
        if (!RiderStyles.isReadonlySection(element) && !RiderStyles.isMath(element)) {
            Style style;
            switch (RiderStyles.getMargin(riderArea.getParagraphAttributes())) {
                case 0: {
                    style = RiderStyles.margin10Style;
                    break;
                }
                case 10: {
                    style = RiderStyles.margin20Style;
                    break;
                }
                case 20: {
                    style = RiderStyles.margin30Style;
                    break;
                }
                default: {
                    style = RiderStyles.alignmentLeftStyle;
                }
            }
            this.setParagraphAttributes(riderArea, style, false);
        }
    }
}

