/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.utilities.LogUtils;

final class OneInstanceServer
extends Thread {
    private static final Logger logger = Logger.getLogger(OneInstanceServer.class.getName());

    public OneInstanceServer() {
        this.setPriority(1);
    }

    public final void run() {
        Socket socket = null;
        try {
            logger.info("Creating a local socket server");
            ServerSocket serverSocket = new ServerSocket(35139, 1);
            while (!this.isInterrupted()) {
                String string;
                logger.info("Waiting for connection");
                socket = serverSocket.accept();
                logger.info("Got a connection");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.length() == 0 || string.startsWith("-") || string.equals("\n")) continue;
                    final String string2 = string;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OpenFileAction.open(new File(string2));
                        }
                    });
                }
                bufferedReader.close();
                socket.close();
            }
        }
        catch (IOException iOException) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    LogUtils.processException(logger, iOException);
                }
            }
            LogUtils.processException(logger, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isWordRiderInUse() {
        if (!AppPrefs.getProperty("settings.oneinstance", false)) {
            return false;
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(35139, 1);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
    }
}

