/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import net.wordrider.area.AreaImage;
import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.SaveAsFileAction;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.files.ti68kformat.TIFileInfo;
import net.wordrider.files.ti68kformat.TIImageUpdater;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class ChangeImagePropertiesAction
extends CoreAction {
    private static final ChangeImagePropertiesAction instance = new ChangeImagePropertiesAction();
    private static final String CODE = "ChangeImagePropertiesAction";
    private static final Logger logger = Logger.getLogger(ChangeImagePropertiesAction.class.getName());

    public static ChangeImagePropertiesAction getInstance() {
        return instance;
    }

    private ChangeImagePropertiesAction() {
        super(CODE, KeyStroke.getKeyStroke(10, 8), "ins_pic_v1.gif");
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = ChangeImagePropertiesAction.getMainFrame();
        IFileInstance iFileInstance = (IFileInstance)AreaManager.getInstance().getActiveInstance();
        if (iFileInstance == null) {
            return;
        }
        RiderArea riderArea = (RiderArea)iFileInstance.getRiderArea();
        AreaImage areaImage = riderArea.getSelectedImage();
        if (areaImage == null) {
            return;
        }
        TIFileInfo tIFileInfo = SaveAsFileAction.getSaveSettings(jFrame, areaImage.getTIFileInfo(), 2);
        if (tIFileInfo == null) {
            return;
        }
        File file = areaImage.getOriginalFile();
        if (file == null) {
            areaImage.setTIFileInfo(tIFileInfo);
            return;
        }
        String string = areaImage.getTIFileInfo().getVarName();
        boolean bl = false;
        if (!(string.equals(tIFileInfo.getVarName()) || Utils.isWindows() && string.equalsIgnoreCase(tIFileInfo.getVarName()))) {
            if (!AppPrefs.getProperty("settings.renameImageDialog", false)) {
                int n = Swinger.getChoiceCancel(jFrame, Lng.getLabel("message.confirm.variable"));
                switch (n) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            } else {
                bl = true;
            }
        }
        try {
            TIImageUpdater tIImageUpdater = new TIImageUpdater(tIFileInfo, file);
            File file2 = tIImageUpdater.doUpdate(bl);
            areaImage.setOriginalFile(file2);
            areaImage.setTIFileInfo(tIFileInfo);
            iFileInstance.setModified(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warning("Image properties. File was not found : " + file);
            Swinger.showErrorDialog(jFrame, Lng.getLabel("message.error.FNF", file));
        }
        catch (IOException iOException) {
            logger.warning("Image properties. Error working with a file : " + file + "\n" + iOException.getMessage());
            Swinger.showErrorDialog(jFrame, iOException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            Swinger.showErrorDialog(jFrame, Lng.getLabel("message.error.corruptedFile", file));
            logger.warning("Image properties. Corrupted file." + file);
        }
    }

    public void updateEnabled() {
        IFileInstance iFileInstance = (IFileInstance)AreaManager.getInstance().getActiveInstance();
        if (iFileInstance != null) {
            this.updateEnabled((RiderArea)iFileInstance.getRiderArea());
        }
    }

    public void updateEnabled(RiderArea riderArea) {
        this.setEnabled(riderArea.getSelectedImage() != null);
    }
}

