/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import net.wordrider.core.Lng;
import net.wordrider.dialogs.ImageFileView;
import net.wordrider.dialogs.ImagePreview;
import net.wordrider.dialogs.RiderFileFilter;
import net.wordrider.utilities.Utils;

public final class PictureDialog
extends JFileChooser {
    private final ImagePreview imagePreview = new ImagePreview(this);

    public PictureDialog() {
        this.init();
    }

    public PictureDialog(File file) {
        super(file);
        this.init();
    }

    public final int showInsertDialog(Component component) {
        return super.showDialog(component, Lng.getLabel("picturedialog.insertBtn"));
    }

    private void addFilter(String[] stringArray, String string) {
        this.addChoosableFileFilter(new RiderFileFilter(stringArray, string));
    }

    private void init() {
        this.setAcceptAllFileFilterUsed(false);
        this.addFilter(new String[]{"89i"}, "picturedialog.ti89files");
        this.addFilter(new String[]{"9xi"}, "picturedialog.ti9xfiles");
        this.addFilter(new String[]{"92i"}, "picturedialog.ti92files");
        this.addFilter(new String[]{"bmp"}, "picturedialog.files");
        this.addFilter(new String[]{"jpeg", "jpg"}, "picturedialog.files");
        this.addFilter(new String[]{"gif"}, "picturedialog.files");
        this.addFilter(new String[]{"png"}, "picturedialog.files");
        if (Utils.isJVMVersion(1.5)) {
            this.addFilter(new String[]{"wbmp"}, "picturedialog.files");
            this.addFilter(new String[]{"89i", "9xi", "92i", "bmp", "jpeg", "jpg", "gif", "png", "wbmp"}, "picturedialog.allsupported");
        } else {
            this.addFilter(new String[]{"89i", "9xi", "92i", "bmp", "jpeg", "jpg", "gif", "png"}, "picturedialog.allsupported");
        }
        this.setDialogTitle(Lng.getLabel("picturedialog.title"));
        this.setFileView(new ImageFileView());
        this.setAccessory(this.imagePreview);
    }

    public void freeResources() {
        this.imagePreview.freeResources();
    }
}

