/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.wordrider.dialogs.layouts.EqualsLayout;
import net.wordrider.dialogs.settings.SettingsDialog;
import net.wordrider.utilities.Swinger;

final class ButtonPanel
extends JPanel {
    private JButton btnSave;
    private JButton btnApply;
    private JButton btnCancel;
    private final SettingsDialog dialog;

    public ButtonPanel(SettingsDialog settingsDialog) {
        this.dialog = settingsDialog;
        this.init();
    }

    private void init() {
        this.setLayout(new EqualsLayout(5));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 8), this.getBorder()));
        Dimension dimension = new Dimension(85, 25);
        this.btnSave = Swinger.getButton("settings.btn.save", new SaveAction());
        this.btnApply = Swinger.getButton("settings.btn.apply", new ApplyAction());
        this.btnApply.getAction().setEnabled(false);
        this.btnCancel = Swinger.getButton("settings.btn.cancel", new CancelAction());
        this.btnSave.setMinimumSize(dimension);
        this.btnCancel.setMinimumSize(dimension);
        this.btnApply.setMinimumSize(dimension);
        this.add(this.btnSave);
        this.add(this.btnApply);
        this.add(this.btnCancel);
    }

    private void applyChanges() {
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        this.dialog.getActiveSettingsPanel().getOptionsManager().applyChanges();
        this.dialog.setCursor(Cursor.getDefaultCursor());
    }

    public final AbstractButton getApplyButton() {
        return this.btnApply;
    }

    public final AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    public final AbstractButton getOkButton() {
        return this.btnSave;
    }

    private final class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("");
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ButtonPanel.this.dialog.doClose();
        }
    }

    private final class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("");
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ButtonPanel.this.applyChanges();
            ButtonPanel.this.dialog.doClose();
        }
    }

    private final class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super("");
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ButtonPanel.this.applyChanges();
        }
    }
}

