/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.utilities;

import java.io.File;
import java.util.logging.Logger;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Utils;

public final class BrowserControl {
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private static final Logger logger = Logger.getLogger(BrowserControl.class.getName());

    private BrowserControl() {
    }

    public static void showURL(String string) {
        boolean bl = Utils.isWindows();
        String string2 = "";
        try {
            if (bl) {
                string2 = "rundll32 url.dll,FileProtocolHandler " + string;
                Runtime.getRuntime().exec(string2);
            } else {
                string2 = "netscape -remote openURL(" + string + ")";
                Process process = Runtime.getRuntime().exec(string2);
                int n = process.waitFor();
                if (n != 0) {
                    string2 = "netscape " + string;
                    Runtime.getRuntime().exec(string2);
                }
            }
        }
        catch (Exception exception) {
            logger.warning("Couldn't invoke browser, command=" + string2);
            LogUtils.processException(logger, exception);
        }
    }

    public static void openPDF(File file) {
        boolean bl = Utils.isWindows();
        String string = "";
        try {
            string = bl ? "rundll32 url.dll,FileProtocolHandler " + file.getPath() : "acroread " + file.getPath();
            Runtime.getRuntime().exec(string);
        }
        catch (Exception exception) {
            logger.warning("Couldn't invoke browser, command=" + string);
            LogUtils.processException(logger, exception);
        }
    }

    public static void showHomepage() {
        BrowserControl.showURL("http://wordrider.net");
    }
}

