/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.wordrider.core.Lng;
import net.wordrider.files.ti68kformat.TIFileInfo;
import net.wordrider.files.ti68kformat.TIImageDecoder;
import net.wordrider.utilities.LogUtils;

public final class AreaImage
extends ImageIcon
implements Cloneable {
    private final boolean isTiImage;
    private TIFileInfo info;
    private static final Logger logger = Logger.getLogger(AreaImage.class.getName());

    public AreaImage(Image image) {
        super(image);
        this.isTiImage = image.getSource() instanceof TIImageDecoder;
        if (this.isTiImage) {
            this.info = this.getImageDecoder().getFileInfo();
            this.updateDescription();
        } else {
            logger.warning("Not supported image!");
        }
    }

    public AreaImage(Image image, TIFileInfo tIFileInfo) {
        super(image);
        this.isTiImage = false;
        this.info = tIFileInfo;
        this.updateDescription();
    }

    private void updateDescription() {
        String string = this.isTiImage ? this.info.getComment() : Lng.getLabel("editor.areaImage.fnf");
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append("<html><b>").append(Lng.getLabel("editor.areaImage.folder")).append(" </b>").append(this.info.getFolderName()).append("<br><b>").append(Lng.getLabel("editor.areaImage.variable"));
        stringBuilder.append(" </b>").append(this.info.getVarName());
        if (string.length() > 0) {
            stringBuilder.append("<br><i>").append(string).append(" </i>");
        }
        stringBuilder.append("</html>");
        this.setDescription(stringBuilder.toString());
    }

    public final TIFileInfo getTIFileInfo() {
        return this.info;
    }

    public final void setTIFileInfo(TIFileInfo tIFileInfo) {
        if (this.isTiImage) {
            this.getImageDecoder().setFileInfo(tIFileInfo);
        }
        this.info = tIFileInfo;
        this.updateDescription();
    }

    private TIImageDecoder getImageDecoder() {
        if (this.isTiImage) {
            ImageProducer imageProducer = this.getImage().getSource();
            return (TIImageDecoder)imageProducer;
        }
        return null;
    }

    public final String getImagePath() {
        File file = this.getOriginalFile();
        if (file != null) {
            return file.getParent();
        }
        return "";
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LogUtils.processException(logger, cloneNotSupportedException);
            return null;
        }
    }

    public final File getOriginalFile() {
        if (this.isTiImage) {
            return this.getImageDecoder().getOriginalFile();
        }
        return null;
    }

    public final void setOriginalFile(File file) {
        if (this.isTiImage) {
            this.getImageDecoder().setOriginalFile(file);
        }
    }

    public final String toString() {
        return "&P" + this.info.getFolderName() + "/" + this.info.getVarName();
    }
}

