/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.area.actions.UndoAction;
import net.wordrider.utilities.LogUtils;

public final class RedoAction
extends TextAreaAction {
    private static final RedoAction instance = new RedoAction();
    private static final String CODE = "RedoAction";
    private static final Logger logger = Logger.getLogger(RedoAction.class.getName());

    public static RedoAction getInstance() {
        return instance;
    }

    private RedoAction() {
        super(CODE, KeyStroke.getKeyStroke(90, 3), "redo.gif");
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionPerformed(ActionEvent actionEvent) {
        RiderArea riderArea = (RiderArea)this.getTextComponent(actionEvent);
        if (riderArea != null) {
            try {
                riderArea.setBusy(true);
                riderArea.getUndoManager().redo();
            }
            catch (CannotRedoException cannotRedoException) {
                LogUtils.processException(logger, cannotRedoException);
            }
            finally {
                riderArea.setBusy(false);
            }
            this.updateRedoState(riderArea);
            UndoAction.getInstance().updateUndoState(riderArea);
        }
    }

    public final void updateRedoState(JTextComponent jTextComponent) {
        RiderArea riderArea = (RiderArea)jTextComponent;
        if (riderArea != null) {
            UndoManager undoManager = riderArea.getUndoManager();
            if (undoManager != null) {
                this.setEnabled(undoManager.canRedo());
            }
        } else {
            this.setEnabled(false);
        }
    }
}

