/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.StyledAreaAction;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.utilities.LogUtils;

public final class UndoAction
extends TextAreaAction {
    private static final UndoAction instance = new UndoAction();
    private static final String CODE = "UndoAction";
    private static final Logger logger = Logger.getLogger(UndoAction.class.getName());

    public static UndoAction getInstance() {
        return instance;
    }

    private UndoAction() {
        super(CODE, KeyStroke.getKeyStroke(90, 2), "undo.gif");
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionPerformed(ActionEvent actionEvent) {
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea != null) {
            UndoManager undoManager = riderArea.getUndoManager();
            try {
                riderArea.setBusy(true);
                undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                LogUtils.processException(logger, cannotUndoException);
            }
            finally {
                riderArea.getCaret().setVisible(true);
                riderArea.setBusy(false);
            }
            this.updateUndoState(riderArea);
            RedoAction.getInstance().updateRedoState(riderArea);
            StyledAreaAction.updateStatus();
        }
    }

    public final void updateUndoState(JTextComponent jTextComponent) {
        RiderArea riderArea = (RiderArea)jTextComponent;
        if (riderArea != null) {
            UndoManager undoManager = riderArea.getUndoManager();
            if (undoManager != null) {
                this.setEnabled(undoManager.canUndo());
            }
        } else {
            this.setEnabled(false);
        }
    }
}

