/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.io.File;
import net.wordrider.core.actions.FileProcessor;
import net.wordrider.core.actions.NotefolioFileProcessor;
import net.wordrider.core.actions.PureTextFileProcessor;
import net.wordrider.core.actions.TextFileProcessor;
import net.wordrider.utilities.Utils;

class FileProcessorFactory {
    private static final FileProcessorFactory instance = new FileProcessorFactory();

    private FileProcessorFactory() {
    }

    public static FileProcessorFactory getInstance() {
        return instance;
    }

    public FileProcessor getProcessorByFile(File file) {
        String string = Utils.getExtension(file);
        if (string.equals("89y") || string.equals("9xy")) {
            return new NotefolioFileProcessor(file);
        }
        if (string.equals("txt")) {
            return new PureTextFileProcessor(file);
        }
        return new TextFileProcessor(file);
    }
}

