/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.JButtonGroup;
import net.wordrider.dialogs.layouts.EqualsLayout;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

public final class ChooseFormatDialog
extends AppDialog {
    public static final int CHOOSE_INPUT_FORMAT = 0;
    public static final int CHOOSE_OUTPUT_FORMAT = 1;
    private JRadioButton radioChoose1;
    private JRadioButton radioChoose2;
    private JButton btnCancel;
    private JButton btnSave;
    private final JCheckBox dontShowAgain = Swinger.getCheckBox("dialog.chooseFormat.dontshow");
    private int dialogType;
    private static final Logger logger = Logger.getLogger(ChooseFormatDialog.class.getName());

    public ChooseFormatDialog(Frame frame, int n) {
        super(frame, true);
        this.dialogType = n;
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.initDialogContents();
        this.pack();
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void initDialogContents() {
        switch (this.dialogType) {
            case 0: {
                this.setTitle(Lng.getLabel("dialog.chooseFormat.title2"));
                boolean bl = AppPrefs.getProperty("settings.inputFormatHibview", true);
                this.radioChoose1.setSelected(bl);
                this.radioChoose2.setSelected(!bl);
                this.dontShowAgain.setSelected(!AppPrefs.getProperty("settings.inputFormatRemember", true));
                break;
            }
            case 1: {
                this.setTitle(Lng.getLabel("dialog.chooseFormat.title"));
                boolean bl = AppPrefs.getProperty("settings.ti92ImageFormat", false);
                this.radioChoose1.setSelected(!bl);
                this.radioChoose2.setSelected(bl);
                this.dontShowAgain.setSelected(!AppPrefs.getProperty("settings.imageFormatRemember", true));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not defined argument");
            }
        }
    }

    public final int getResult() {
        return this.result;
    }

    private void doCancelButtonAction() {
        this.doClose();
    }

    protected AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    protected AbstractButton getOkButton() {
        return this.btnSave;
    }

    private void btnSave_actionPerformed() {
        switch (this.dialogType) {
            case 0: {
                AppPrefs.storeProperty("settings.inputFormatRemember", !this.dontShowAgain.isSelected());
                AppPrefs.storeProperty("settings.inputFormatHibview", this.radioChoose1.isSelected());
                break;
            }
            case 1: {
                AppPrefs.storeProperty("settings.imageFormatRemember", !this.dontShowAgain.isSelected());
                AppPrefs.storeProperty("settings.ti92ImageFormat", this.radioChoose2.isSelected());
                break;
            }
            default: {
                throw new IllegalArgumentException("Not defined argument");
            }
        }
        this.result = 0;
        this.doClose();
    }

    private void init() {
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        container.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), Lng.getLabel("dialog.chooseFormat.formats")));
        switch (this.dialogType) {
            case 0: {
                this.radioChoose1 = Swinger.getRadio("dialog.chooseFormat.hibview");
                this.radioChoose2 = Swinger.getRadio("dialog.chooseFormat.txtrider");
                break;
            }
            case 1: {
                this.radioChoose1 = Swinger.getRadio("dialog.chooseFormat.ti89choice");
                this.radioChoose2 = Swinger.getRadio("dialog.chooseFormat.ti92choice");
                break;
            }
            default: {
                throw new IllegalArgumentException("Not defined argument");
            }
        }
        JPanel jPanel2 = new JPanel(new EqualsLayout(5));
        jPanel2.setPreferredSize(new Dimension(250, 28));
        Dimension dimension = new Dimension(85, 25);
        this.btnCancel = Swinger.getButton("dialog.chooseFormat.cancelBtn");
        this.btnCancel.setMinimumSize(dimension);
        this.btnSave = Swinger.getButton("dialog.chooseFormat.saveBtn");
        this.btnSave.setMinimumSize(dimension);
        ActionButtonsAdapter actionButtonsAdapter = new ActionButtonsAdapter();
        this.btnSave.addActionListener(actionButtonsAdapter);
        this.btnCancel.addActionListener(actionButtonsAdapter);
        jPanel.add((Component)this.radioChoose1, "North");
        jPanel.add((Component)this.radioChoose2, "South");
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.radioChoose1.setBorder(border);
        this.radioChoose2.setBorder(border);
        JButtonGroup jButtonGroup = new JButtonGroup();
        jButtonGroup.add(this.radioChoose1);
        jButtonGroup.add(this.radioChoose2);
        container.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        container.add((Component)this.dontShowAgain, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel2.add(this.btnSave);
        jPanel2.add(this.btnCancel);
        container.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 1, new Insets(2, 2, 2, 6), 0, 2));
    }

    private final class ActionButtonsAdapter
    implements ActionListener {
        private ActionButtonsAdapter() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ChooseFormatDialog.this.btnSave)) {
                ChooseFormatDialog.this.btnSave_actionPerformed();
            } else {
                ChooseFormatDialog.this.doCancelButtonAction();
            }
        }
    }
}

