/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.MainAppFrame;
import net.wordrider.gui.LaF;
import net.wordrider.gui.WordRiderMetalTheme;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LookAndFeels {
    private static final String KUNSTSTOFF = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
    private static final String LOOK_AND_FEEL_SELECTED_KEY = "lookAndFeel";
    private static final String LOOK_AND_FEEL_OPAQUE_KEY = "lafOpaque";
    private static final String THEME_SELECTED_KEY = "theme";
    private LaF selectedLookAndFeel;
    private static final Logger logger = Logger.getLogger(LookAndFeels.class.getName());
    private static final LookAndFeels instance = new LookAndFeels();
    private ClassLoader classLoader = this.initClassLoader();
    private Vector<LaF> availableLaFs = null;

    public static LookAndFeels getInstance() {
        return instance;
    }

    private LookAndFeels() {
        String string = AppPrefs.getProperty(LOOK_AND_FEEL_SELECTED_KEY, KUNSTSTOFF);
        boolean bl = AppPrefs.getProperty(LOOK_AND_FEEL_OPAQUE_KEY, true);
        String string2 = AppPrefs.getProperty(THEME_SELECTED_KEY, null);
        if (string2 == null && string.equals(KUNSTSTOFF)) {
            string2 = WordRiderMetalTheme.class.getName();
        }
        this.selectedLookAndFeel = new LaF(string, "", string2, bl);
    }

    private ClassLoader initClassLoader() {
        String string = AppPrefs.getAppPath() + "lib";
        logger.info("Loading plugin path " + string);
        File file = new File(string);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (file.exists()) {
                File[] fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".jar");
                    }
                });
                int n = fileArray.length;
                URL[] uRLArray = new URL[n];
                boolean bl = logger.isLoggable(Level.INFO);
                for (int i = 0; i < n; ++i) {
                    uRLArray[i] = fileArray[i].toURL();
                    if (!bl) continue;
                    logger.info("Loading URL with a jar " + uRLArray[i]);
                }
                classLoader = new URLClassLoader(uRLArray, classLoader);
            }
            return classLoader;
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            return classLoader;
        }
    }

    public final Vector<LaF> getAvailableLookAndFeels() {
        if (this.availableLaFs == null) {
            String string;
            String string2;
            this.availableLaFs = new Vector(5);
            Properties properties = Utils.loadProperties("resources/lookandfeels/lookandfeels.properties", true);
            int n = -1;
            while ((string2 = properties.getProperty(string = "laf" + ++n)) != null) {
                String string3;
                String string4;
                if (this.isPresent(string2) == null) continue;
                boolean bl = properties.getProperty(string + ".opaque", "true").equals("true");
                int n2 = -1;
                String string5 = properties.getProperty(string + ".name", string2);
                if (properties.getProperty(string + ".alone", "true").equals("true")) {
                    this.availableLaFs.add(new LaF(string2, string5, null, bl));
                }
                while ((string4 = properties.getProperty(string3 = string + ".theme" + ++n2, null)) != null) {
                    if (this.isPresent(string4) == null) continue;
                    String string6 = string5 + " - " + properties.getProperty(string3 + ".name", " - theme");
                    this.availableLaFs.add(new LaF(string2, string6, string4, bl));
                }
            }
        }
        return this.availableLaFs;
    }

    public final LaF getSelectedLaF() {
        return this.selectedLookAndFeel;
    }

    public final void storeSelectedLaF(LaF laF) {
        AppPrefs.storeProperty(LOOK_AND_FEEL_SELECTED_KEY, laF.getClassName());
        AppPrefs.storeProperty(LOOK_AND_FEEL_OPAQUE_KEY, laF.isToolbarOpaque());
        if (laF.getThemeClass() == null) {
            AppPrefs.removeProperty(THEME_SELECTED_KEY);
        } else {
            AppPrefs.storeProperty(THEME_SELECTED_KEY, laF.getThemeClass());
        }
        this.selectedLookAndFeel = laF;
    }

    public final void loadLookAndFeelSettings() {
        this.loadLookAndFeel(this.selectedLookAndFeel, false);
    }

    private Class<?> isPresent(String string) {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            logger.info("Possible problem. Look and feel class/theme " + string + " cannot be instantied. Probably higher version of the JDK is required.");
            return null;
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Possible problem.Look and feel class/theme " + string + " was not detected(not in /lib?).Check " + "resources/lookandfeels/lookandfeels.properties");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean loadLookAndFeel(LaF laF, boolean bl) {
        String string = laF.getClassName();
        String string2 = laF.getThemeClass();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (string.equals(KUNSTSTOFF)) {
                this.initKunststoff();
            } else {
                this.initLaf(string, string2);
            }
        }
        catch (Exception exception) {
            logger.warning(string + " was not found.");
            if (!string.equals(KUNSTSTOFF)) {
                if (logger.isLoggable(Level.INFO)) {
                    LogUtils.processException(logger, exception);
                }
                try {
                    this.initKunststoff();
                }
                catch (Exception exception2) {
                    logger.warning("Kunststoff Look and Feel was not found. Using a default metal theme.");
                    boolean bl2 = false;
                    return bl2;
                }
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl) {
                MainAppFrame mainAppFrame = MainApp.getInstance().getMainAppFrame();
                mainAppFrame.getManagerDirector().beforeLookAndFeelUpdate();
                LookAndFeels.updateAllUIs();
                UIManager.getLookAndFeel().getDefaults();
                mainAppFrame.getManagerDirector().afterLookAndFeelUpdate();
                mainAppFrame.invalidate();
                mainAppFrame.validate();
                mainAppFrame.repaint();
            }
        }
        return true;
    }

    private void initKunststoff() throws Exception {
        this.initLafWithTheme(KUNSTSTOFF, new WordRiderMetalTheme());
    }

    private void initLafWithTheme(String string, MetalTheme metalTheme) throws Exception {
        LookAndFeel lookAndFeel = (LookAndFeel)this.classLoader.loadClass(string).newInstance();
        if (metalTheme != null && lookAndFeel instanceof MetalLookAndFeel) {
            lookAndFeel.getClass().getMethod("setCurrentTheme", MetalTheme.class).invoke((Object)lookAndFeel, metalTheme);
        }
        UIManager.put("ClassLoader", this.classLoader);
        UIManager.setLookAndFeel(lookAndFeel);
        UIManager.put("ClassLoader", this.classLoader);
    }

    private void initLaf(String string, String string2) throws Exception {
        if (string2 != null) {
            Class<?> clazz = this.isPresent(string2);
            if (clazz != null) {
                Object obj = clazz.newInstance();
                if (obj instanceof MetalTheme) {
                    this.initLafWithTheme(string, (MetalTheme)obj);
                } else {
                    logger.warning("Theme " + obj.getClass().getName() + " cannot be set.Theme is not an instance of Metaltheme");
                    this.initLafWithTheme(string, null);
                }
            }
        } else {
            this.initLafWithTheme(string, null);
        }
    }

    private static void updateAllUIs() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            LookAndFeels.updateWindowUI(frame);
        }
    }

    public static void updateWindowUI(Window window) {
        Window[] windowArray;
        try {
            LookAndFeels.updateComponentTreeUI(window);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            LookAndFeels.updateWindowUI(window2);
        }
    }

    public static void updateComponentTreeUI(Component component) {
        LookAndFeels.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        Component[] componentArray = null;
        if (component instanceof JToolBar) {
            componentArray = ((JToolBar)component).getComponents();
            if (componentArray != null) {
                boolean bl = LookAndFeels.getInstance().getSelectedLaF().isToolbarOpaque();
                for (Component component2 : componentArray) {
                    LookAndFeels.updateComponentTreeUI0(component2);
                    if (!(component2 instanceof JComponent)) continue;
                    ((JComponent)component2).setOpaque(!bl);
                }
            }
            ((JComponent)component).updateUI();
        } else {
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
            if (component instanceof JMenu) {
                componentArray = ((JMenu)component).getMenuComponents();
            } else if (component instanceof Container) {
                componentArray = ((Container)component).getComponents();
            }
            if (componentArray != null) {
                for (Component component3 : componentArray) {
                    LookAndFeels.updateComponentTreeUI0(component3);
                }
            }
        }
    }
}

