/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.plugintools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.plugintools.PluginTool;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharacterList
extends PluginTool
implements MouseMotionListener,
MouseListener,
ItemListener {
    private static final int zoomWindowWidth = 36;
    private JTable charsTable;
    private JTable lastUsedCharsTable;
    private JTextPane editor = null;
    private JComboBox charsTypeCombo;
    private static Cursor blankCursor;
    private static boolean nowZooming;
    private boolean firstTime = true;
    private JWindow zoomWindow;
    private BufferedImage zoomImage = null;
    private static final Logger logger;
    private Character activeCharacter;
    public static final char[] TI92PC_UNICODE_FONT;

    public CharacterList() {
        try {
            this.setFileInstance(null);
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    @Override
    public final String getName() {
        return Lng.getLabel("characters.title");
    }

    @Override
    public String getTabName() {
        return this.getName();
    }

    @Override
    public final Icon getIcon() {
        return Swinger.getIcon("char.gif");
    }

    @Override
    public final String getTip() {
        return Lng.getLabel("characters.tooltip");
    }

    @Override
    public final void activate() {
        this.setFileInstance((IFileInstance)AreaManager.getInstance().getActiveInstance());
        logger.info("CharsList activated");
    }

    @Override
    public final void deactivate() {
        this.setFileInstance(null);
        logger.info("CharsList deactivated");
    }

    private void setEditor(JTextComponent jTextComponent) {
        this.getContentPane().setEnabled((this.editor = (JTextPane)jTextComponent) != null);
    }

    @Override
    public void setFileInstance(IFileInstance iFileInstance) {
        if (iFileInstance != null) {
            this.setEditor((JTextComponent)iFileInstance.getRiderArea());
        } else {
            this.setEditor(null);
        }
    }

    @Override
    public void updateData() {
    }

    private CharsTableModel getCharsTableModel() {
        return (CharsTableModel)this.charsTable.getModel();
    }

    private void initTable(JTable jTable, KeyListener keyListener, TableCellRenderer tableCellRenderer) {
        jTable.setDefaultRenderer(Object.class, tableCellRenderer);
        jTable.setSelectionMode(0);
        jTable.setColumnSelectionAllowed(false);
        jTable.setRowSelectionAllowed(false);
        jTable.setTableHeader(null);
        jTable.addMouseMotionListener(this);
        jTable.setFont(RiderStyles.getAreaFont().deriveFont(0, 13.0f));
        jTable.addMouseListener(this);
        jTable.setRowHeight(25);
        jTable.addKeyListener(keyListener);
        jTable.setFocusCycleRoot(true);
    }

    private static Stack<Character> getLastUsedCharsFromPreferences() {
        Stack<Character> stack = new Stack<Character>();
        if (AppPrefs.getProperty("settings.usedcharsSave", true)) {
            String string = AppPrefs.getProperty("settings.usedchars", "");
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                stack.add(Character.valueOf(string.charAt(i)));
            }
        }
        return stack;
    }

    private void storeLastUsedChars() {
        if (AppPrefs.getProperty("settings.usedcharsSave", true)) {
            Stack<Character> stack = this.getUsedCharsTableModel().getValues();
            StringBuilder stringBuilder = new StringBuilder(stack.size());
            for (Character c : stack) {
                Character c2 = c;
                if (c2 == null) continue;
                stringBuilder.append(c2.charValue());
            }
            AppPrefs.storeProperty("settings.usedchars", stringBuilder.toString());
            AppPrefs.storeProperty("settings.usedcharsSave", true);
        } else {
            AppPrefs.removeProperty("settings.usedchars");
        }
    }

    private void init() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] byArray = new byte[]{0};
        blankCursor = toolkit.createCustomCursor(toolkit.createImage(byArray), new Point(0, 0), "");
        this.zoomWindow = new JWindow(MainApp.getInstance().getMainAppFrame()){

            public void paint(Graphics graphics) {
                graphics.drawImage(CharacterList.this.zoomImage, 0, 0, CharacterList.this.zoomWindow);
            }
        };
        this.zoomWindow.setCursor(blankCursor);
        this.zoomWindow.pack();
        CellRenderer cellRenderer = new CellRenderer();
        AddCharByKeyListener addCharByKeyListener = new AddCharByKeyListener();
        this.charsTable = new JTable(new CharsTableModel());
        this.initTable(this.charsTable, addCharByKeyListener, cellRenderer);
        this.lastUsedCharsTable = new JTable(new LastUsedCharsTableModel(CharacterList.getLastUsedCharsFromPreferences()));
        this.initTable(this.lastUsedCharsTable, addCharByKeyListener, cellRenderer);
        this.lastUsedCharsTable.setBorder(BorderFactory.createEtchedBorder());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.charsTypeCombo = new JComboBox();
        this.charsTypeCombo.setPreferredSize(new Dimension(170, 23));
        ArrayList<String> arrayList = this.getCharsTableModel().getAvailableCharTables();
        for (String object2 : arrayList) {
            this.charsTypeCombo.addItem(object2);
        }
        this.charsTypeCombo.addItemListener(this);
        this.itemStateChanged(null);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(150, 30));
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "South");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 4));
        jPanel3.add((Component)this.lastUsedCharsTable, "Center");
        jPanel3.setPreferredSize(new Dimension(150, 35));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 4, 5));
        jPanel2.add((Component)this.charsTypeCombo, "West");
        JScrollPane jScrollPane = new JScrollPane(this.charsTable);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        container.add((Component)jPanel, "North");
        container.add((Component)new JScrollPane(this.charsTable), "Center");
        JComponent jComponent = this.getComponent();
        jComponent.setPreferredSize(new Dimension(180, 250));
        jComponent.setMaximumSize(new Dimension(200, 250));
        jComponent.setVisible(true);
    }

    private boolean firstTime() {
        return this.firstTime;
    }

    private void refresh() {
        this.firstTime = false;
        this.getContentPane().repaint();
    }

    private void showZoomed(JTable jTable, int n, int n2, Character c) {
        if (c == null) {
            return;
        }
        this.activeCharacter = c;
        jTable.setCursor(blankCursor);
        if (!nowZooming) {
            if (this.zoomWindow.getWarningString() != null) {
                this.zoomWindow.setSize(36, 36);
            } else {
                this.zoomWindow.setSize(37, 37);
            }
        }
        this.zoomImage = (BufferedImage)this.zoomWindow.createImage(37, 37);
        Graphics2D graphics2D = (Graphics2D)this.zoomImage.getGraphics();
        Font font = RiderStyles.getAreaBigFont();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 36, 36);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, 36, 36);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = jTable.getFontMetrics(font);
        graphics2D.drawString(c.toString(), (36 - fontMetrics.charWidth(c.charValue())) / 2, (36 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        graphics2D.dispose();
        this.zoomWindow.getGraphics().drawImage(this.zoomImage, 0, 0, this.getContentPane());
        Rectangle rectangle = jTable.getCellRect(n, n2, false);
        Point point = jTable.getLocationOnScreen();
        int n3 = rectangle.x - (36 - rectangle.width) / 2;
        int n4 = rectangle.y - (36 - rectangle.height) / 2;
        this.zoomWindow.setLocation(point.x + n3, point.y + n4);
        if (!nowZooming) {
            this.zoomWindow.setVisible(true);
        }
        nowZooming = true;
        if (this.firstTime()) {
            this.refresh();
        }
    }

    private static Character getSelectedCharacter(JTable jTable, int n, int n2) {
        return (Character)jTable.getModel().getValueAt(n, n2);
    }

    private static Character getSelectedCharacter(JTable jTable) {
        return (Character)jTable.getModel().getValueAt(jTable.getSelectedRow(), jTable.getSelectedColumn());
    }

    @Override
    public final void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        JTable jTable;
        Character c;
        if (nowZooming && (c = CharacterList.getSelectedCharacter(jTable = (JTable)mouseEvent.getSource(), n2 = jTable.rowAtPoint(mouseEvent.getPoint()), n = jTable.columnAtPoint(mouseEvent.getPoint()))) != null && c.compareTo(this.activeCharacter) != 0) {
            this.showZoomed(jTable, n2, n, c);
        }
    }

    @Override
    public final void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
        Character c = CharacterList.getSelectedCharacter(jTable, n, n2);
        this.showZoomed(jTable, n, n2, c);
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        if (nowZooming) {
            this.zoomWindow.setVisible(false);
        }
        nowZooming = false;
        JTable jTable = (JTable)mouseEvent.getSource();
        Character c = CharacterList.getSelectedCharacter(jTable, jTable.rowAtPoint(mouseEvent.getPoint()), jTable.columnAtPoint(mouseEvent.getPoint()));
        if (c != null) {
            this.insertCharacter(c);
            if (jTable.equals(this.charsTable)) {
                this.getUsedCharsTableModel().addUsedChar(c);
            }
        }
        mouseEvent.consume();
        jTable.setCursor(Cursor.getDefaultCursor());
    }

    private LastUsedCharsTableModel getUsedCharsTableModel() {
        return (LastUsedCharsTableModel)this.lastUsedCharsTable.getModel();
    }

    @Override
    public final void itemStateChanged(ItemEvent itemEvent) {
        this.getCharsTableModel().selectCharTable(this.charsTypeCombo.getSelectedIndex());
    }

    private void insertCharacter(Character c) {
        if (this.editor == null) {
            return;
        }
        this.editor.replaceSelection(c.toString());
        Swinger.inputFocus(this.editor);
    }

    @Override
    public boolean closeSoft() {
        this.storeLastUsedChars();
        return true;
    }

    @Override
    public void closeHard() {
    }

    static {
        nowZooming = false;
        logger = Logger.getLogger(CharacterList.class.getName());
        TI92PC_UNICODE_FONT = new char[]{'\u20ac', '\u0081', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u008d', '\u017d', '\u008f', '\u0090', '\u2018', '\u2019', '\u201c', '\u201d', '\u2013', '\u2014', '\u00c6', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u009d', '\u017e', '\u0178', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '|', '\u00a7', '\u00a7', '\u00a8', '\u00aa', '\u00d7', '\u00a9', '\u00aa', '\u00a8', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b6', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00de', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00e6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cd', '\u00cc', '\u00cd', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', 'x', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00fe', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LastUsedCharsTableModel
    extends AbstractTableModel {
        private static final int COLUMNS_COUNT = 8;
        private final Stack<Character> usedCharsList;

        public LastUsedCharsTableModel(Stack<Character> stack) {
            this.usedCharsList = stack;
            this.usedCharsList.setSize(8);
        }

        public final Stack<Character> getValues() {
            return this.usedCharsList;
        }

        public final void addUsedChar(Character c) {
            if (!this.usedCharsList.contains(c)) {
                this.usedCharsList.add(0, c);
                this.usedCharsList.setSize(8);
                this.fireTableDataChanged();
            }
        }

        @Override
        public final int getColumnCount() {
            return 8;
        }

        @Override
        public final int getRowCount() {
            return 1;
        }

        @Override
        public final boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public final Object getValueAt(int n, int n2) {
            return n2 >= 0 && n2 < this.usedCharsList.size() ? (Character)this.usedCharsList.get(n2) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharsTableModel
    extends AbstractTableModel {
        private static final char[] GREEK_CHARS = new char[]{'\u20ac', '\u0081', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u00b1', '\u0160', '\u0152', '\u008d', '\u008f', '\u0090', '\u2018', '\u2019', '\u201c', '\u201d', '\u00b7', '\u00b6', '\u017d', '\u2039'};
        private static final char[] MATH_SYMBOLS1 = new char[]{'\u00b4', '\u00ae', '\u00af', '\u00b0', '\u00b8', '\u00a7', '\u2014', '\u00c6', '\u0152', '\u00aa', '\u00bf', '\u00bd', '\u00bc', '\u00be', '\u00a9', '\u0153', '\u017e', '\u009d', '\u0161', '\u203a', '\u0178', '\u00a2', '\u02dc', '\u00ac', '\u00b3', '\u00d7', '\u00de', '\u00bb'};
        private static final char[] MATH_SYMBOLS2 = new char[]{'\u00c6', '\u00b8', '|', '\"', ';', ':', '\u02c6', '\\', '\u2013', '<', '>', '{', '}', '[', ']', '(', ')', ',', '^', '\u0152'};
        private static final char[] SPECIAL_SYMBOLS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '?', '@', '_', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a8', '\u00ac', '\u00b9', '\u00d7', '\u00de'};
        private static final int columnsCount = 5;
        private int dataLength = 0;
        private char[] charArray;

        private CharsTableModel() {
        }

        @Override
        public final int getColumnCount() {
            return 5;
        }

        @Override
        public final int getRowCount() {
            return this.dataLength / 5 + (this.dataLength % 5 != 0 ? 1 : 0);
        }

        @Override
        public final boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public final Object getValueAt(int n, int n2) {
            return (n = n * 5 + n2) < this.dataLength && n >= 0 ? Character.valueOf(this.charArray[n]) : null;
        }

        public final ArrayList<String> getAvailableCharTables() {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            arrayList.add(Lng.getLabel("characters.list.greek"));
            arrayList.add(Lng.getLabel("characters.list.math1"));
            arrayList.add(Lng.getLabel("characters.list.math2"));
            arrayList.add(Lng.getLabel("characters.list.specialSyms"));
            arrayList.add(Lng.getLabel("characters.list.allChars"));
            return arrayList;
        }

        private void setCharArray(char[] cArray) {
            this.charArray = cArray;
            this.dataLength = cArray.length;
            this.fireTableDataChanged();
        }

        public final void selectCharTable(int n) {
            switch (n) {
                case 0: {
                    this.setCharArray(GREEK_CHARS);
                    break;
                }
                case 1: {
                    this.setCharArray(MATH_SYMBOLS1);
                    break;
                }
                case 2: {
                    this.setCharArray(MATH_SYMBOLS2);
                    break;
                }
                case 3: {
                    this.setCharArray(SPECIAL_SYMBOLS);
                    break;
                }
                default: {
                    this.setCharArray(TI92PC_UNICODE_FONT);
                }
            }
        }
    }

    private final class AddCharByKeyListener
    implements KeyListener {
        private AddCharByKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTable jTable = (JTable)keyEvent.getSource();
                Character c = CharacterList.getSelectedCharacter(jTable);
                if (c != null) {
                    CharacterList.this.insertCharacter(c);
                    if (jTable.equals(CharacterList.this.charsTable)) {
                        ((LastUsedCharsTableModel)CharacterList.this.lastUsedCharsTable.getModel()).addUsedChar(c);
                    }
                }
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private static final class CellRenderer
    extends DefaultTableCellRenderer {
        private static final boolean isWindows = Utils.isWindows();

        public CellRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
        }

        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                char c = ((Character)object).charValue();
                String string = c < '\u00ff' && isWindows ? "alt-0" + c + "  " : "";
                this.setToolTipText(string + Lng.getLabel("characters.unicode", Integer.toHexString(c)));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

