/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area;

import net.wordrider.area.actions.*;
import net.wordrider.core.actions.ChangeImagePropertiesAction;
import net.wordrider.core.actions.CloseActiveAction;

import javax.swing.*;

/**
 * @author Vity
 */
final class ContextMenu extends JPopupMenu {
    private final static ContextMenu instance = new ContextMenu();

    private ContextMenu() {
        super();    //call to super
        add(CloseActiveAction.getInstance());
        addSeparator();
        add(CutAction.getInstance());
        add(CopyAction.getInstance());
        add(PasteAction.getInstance());
        add(SelectAllAction.getInstance());
        addSeparator();
        add(ShowFindReplaceDialogAction.getInstance());
        addSeparator();
        add(ChangeImagePropertiesAction.getInstance());
    }

    public static ContextMenu getInstance() {
        instance.updateUI();
        return instance;
    }
}
