/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

import net.wordrider.area.RiderArea;

import javax.swing.*;
import javax.swing.text.Style;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
abstract class ChangeParagraphStyleAction extends StyledAreaAction {
    private String styleCode = null;
    Style style = null;


    protected ChangeParagraphStyleAction(final String actionCode, final String styleCode, final KeyStroke keyStroke, final String smallIcon) {
        this(actionCode, keyStroke, smallIcon);
        this.styleCode = styleCode;
    }

    protected ChangeParagraphStyleAction(final String actionCode, final KeyStroke keyStroke, final String smallIcon) {
        super(actionCode, keyStroke, smallIcon);
    }

    public void actionPerformed(final ActionEvent e) {
        super.actionPerformed(e);
        final RiderArea area = getRiderArea(e);
        if (area != null && (styleCode != null || style != null)) {
            setParagraphAttributes(area, (style != null) ? style : area.getDoc().getStyle(styleCode), false);
        }
    }


}
